package com.biz.crm.dms.business.policy.local.service;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyLimit;

import java.util.Set;

/**
 * 促销政策限量控制服务接口类
 *
 * @author pengxi
 * @date 2022/01/11
 */
public interface SalePolicyLimitService {

  /**
   * 新增促销政策/优惠政策所绑定的销量政策
   *
   * @param salePolicyLimit
   */
  void create(SalePolicyLimit salePolicyLimit);

  /**
   * 按照优惠政策主键ID进行已绑定限量信息的刪除操作
   * @param ids ID集合
   */
  void deleteByIds(Set<String> ids);

  /**
   * 按照优惠政策业务编码和二级租户信息、限量政策业务编号进行符合要求的限量信息的查询
   * @param salePolicyCode 指定的优惠政策业务编码
   * @param tenantCode 指定的二级租户信息
   * @param limitStrategyCode 限量政策业务编号
   * @return
   */
  SalePolicyLimit findBySalePolicyCodeAndTenantCodeAndLimitStrategyCode(String salePolicyCode, String tenantCode, String limitStrategyCode);
}
