package com.biz.crm.dms.business.policy.local.service;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyProduct;

import java.util.List;
import java.util.Set;

/**
 * 该服务接口面向SalePolicyProduct实体
 * @author yinwenjie
 */
public interface SalePolicyProductService {
  /**
   * 批量进行优惠政策本品信息的验证和添加
   * @param salePolicyProducts 批量需要保存的优惠政策本品信息
   * @return
   */
  public void createBatch(Set<SalePolicyProduct> salePolicyProducts);
  
  /**
   * 按照指定的门槛涉及的优惠政策业务编号信息，进行商品本品信息的查询(可能是多个)
   * @param salePolicyCode 指定的优惠政策业务编号 
   * @return
   */
  List<SalePolicyProduct> findBySalePolicyCode(String salePolicyCode, String tenantCode);
  
}
