package com.biz.crm.dms.business.policy.local.service;

import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecord;

import java.util.Set;

/**
 * 促销政策/优惠政策使用记录表的服务接口类
 * @author pengxi yinwenjie
 */
public interface SalePolicyRecordService {
  /**
   * 由标品提供的新增促销政策/优惠政策使用记录，基于当前正在执行的优惠政策
   * @param billCode 业务单据编号
   * @param executeContext 记录信息
   */
  void create(String billCode , DefaultPolicyExecuteContext executeContext);
  
  /**
   * 有标品提供的按照外部单据（票据号）进行优惠政策流水信息删除的功能
   * @param billCode 业务单据编号
   * @param tenantCode 客户编号
   * @param customerCode 客户编号
   */
  void deleteByBillCode(String billCode , String tenantCode , String customerCode);
  
  /**
   * 按照特定的单据信息，对当时单据执行的优惠政策过程进行还原</br>
   * @param billCode 业务单据编号
   * @param tenantCode 客户编号
   * @param customerCode 客户编号
   * @return
   */
  SalePolicyRecord findByBillCode(String billCode , String tenantCode , String customerCode);

  /**
   * 按照指定的维度，查询优惠政策执行的历史流水信息
   * @param tenantCode 租户编码
   * @param salePolicyCode 促销政策编码
   * @return SalePolicyRecord
   */
  Set<SalePolicyRecord> findByTenantCodeAndSalePolicyCode(String tenantCode, String salePolicyCode);

  /**
   * 按照指定的维度，查询优惠政策执行的历史流水信息
   * @param tenantCode 租户编码
   * @param salePolicyCode 促销政策编码
   * @param customerCode 客户编号
   * @return SalePolicyRecord
   */
  Set<SalePolicyRecord> findByTenantCodeAndSalePolicyCodeAndCustomerCode(String tenantCode, String salePolicyCode, String customerCode);

  /**
   * 按照指定的维度，查询优惠政策执行的历史流水信息
   * @param tenantCode 租户编码
   * @param salePolicyCode 促销政策编码
   * @param customerCode 客户编号
   * @param billCode 单据编号
   * @return SalePolicyRecord
   */
  Set<SalePolicyRecord> findByTenantCodeAndSalePolicyCodeAndCustomerCodeAndBillCode(String tenantCode, String salePolicyCode, String customerCode, String billCode);
}
