package com.biz.crm.dms.business.policy.local.service;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyScopeInfo;

import java.util.List;
import java.util.Set;

/**
 * 优惠政策适用范围服务层接口定义
 * @author yinwenjie
 */
public interface SalePolicyScopeInfoService {
  /**
   * 进行批量的优惠政策适用范围的添加操作
   * @param salePolicyScopeInfos
   * @return
   */
  public void createBatch(Set<SalePolicyScopeInfo> salePolicyScopeInfos);

  /**
   * 根据租户编码、优惠政策业务编号、客户范围控制策略的识别类型号查询数据集合
   * @param tenantCode 租户编码
   * @param salePolicyCode 优惠政策业务编号
   * @param customerScopeType 客户范围控制策略的识别类型号
   * @return
   */
  List<SalePolicyScopeInfo> findByTenantCodeAndSalePolicyCodeAndCustomerScopeType(String tenantCode, String salePolicyCode, String customerScopeType);
}
