package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutorLadderGift;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyExecutorLadderGiftRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyExecutorLadderGiftService;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * 标品中默认的优惠政策执行信息阶梯赠品部分的服务层实现（默认的）
 * @author songjingen
 */
@Service
public class SalePolicyExecutorLadderGiftServiceImpl implements SalePolicyExecutorLadderGiftService {

  @Autowired(required = false)
  private SalePolicyExecutorLadderGiftRepository salePolicyExecutorLadderGiftRepository;

  /**
   * 批量创建阶梯赠品信息
   * @param salePolicyExecutorLadderGifts 阶梯赠品信息集合
   * @param salePolicyExecutorLadderId 阶梯id
   */
  @Override
  @Transactional
  public void createBatch(Set<SalePolicyExecutorLadderGift> salePolicyExecutorLadderGifts, String salePolicyExecutorLadderId) {
    Validate.isTrue(!CollectionUtils.isEmpty(salePolicyExecutorLadderGifts), "创建优惠政策执行信息阶梯赠品时，创建集合不能为空！");
    Validate.notBlank(salePolicyExecutorLadderId, "创建优惠政策执行信息变量时, 阶梯id不能为空");
    // 赠品的编码不能重复
    long codeCount = salePolicyExecutorLadderGifts.stream().filter(item -> StringUtils.isNotBlank(item.getGiftCode())).distinct().count();
    Validate.isTrue(codeCount == salePolicyExecutorLadderGifts.size() , "在维护优惠政策执行信息赠品时，发现赠品的业务编码可能存在重复或者漏填的情况，请检查!!");
    for (SalePolicyExecutorLadderGift salePolicyExecutorLadderGift : salePolicyExecutorLadderGifts) {
      salePolicyExecutorLadderGift.setExecutorLadderId(salePolicyExecutorLadderId);
      this.createValidate(salePolicyExecutorLadderGift);
    }
    salePolicyExecutorLadderGiftRepository.saveBatch(salePolicyExecutorLadderGifts);
  }

  /**
   * 改私有方法是创建时验证数据
   */
  private void createValidate(SalePolicyExecutorLadderGift salePolicyExecutorLadderGift) {
    Validate.notNull(salePolicyExecutorLadderGift, "创建优惠政策执行信息阶梯赠品时，创建对象不能为空！");
    salePolicyExecutorLadderGift.setId(null);
    Validate.notBlank(salePolicyExecutorLadderGift.getExecutorLadderId(), "创建优惠政策执行信息阶梯赠品时, 阶梯id不能为空！");
    Validate.notBlank(salePolicyExecutorLadderGift.getGiftCode(), "创建优惠政策执行信息阶梯赠品时, 赠品编码不能为空！");
    Validate.notBlank(salePolicyExecutorLadderGift.getGiftName(), "创建优惠政策执行信息阶梯赠品时, 赠品名称不能为空！");
    Validate.inclusiveBetween(1, 2, salePolicyExecutorLadderGift.getGiftType() , "创建优惠政策执行信息阶梯赠品时, 赠品赠送性质（giftType）必须填写正确，请检查!!");
    Validate.notNull(salePolicyExecutorLadderGift.getGiftValue() , "创建优惠政策执行信息阶梯赠品时, 赠品值不能为空！");
    Validate.isTrue(salePolicyExecutorLadderGift.getGiftValue() > 0 , "创建优惠政策执行信息阶梯赠品时, 赠品赠送值必须大于0！");
  }
}
