package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyLimit;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyLimitJpaRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyLimitRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyLimitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Set;

/**
 * 促销政策限量控制服务实现类
 *
 * @author pengxi
 * @date 2022/01/11
 */
@Service
public class SalePolicyLimitServiceImpl implements SalePolicyLimitService {

  @Autowired(required = false)
  private SalePolicyLimitRepository salePolicyLimitRepository;

  @Autowired(required = false)
  private SalePolicyLimitJpaRepository salePolicyLimitJpaRepository;

  @Override
  public void create(SalePolicyLimit salePolicyLimit) {
    salePolicyLimit = ObjectUtils.defaultIfNull(salePolicyLimit, new SalePolicyLimit());
    salePolicyLimit.setTenantCode(TenantUtils.getTenantCode());
    Validate.notNull(salePolicyLimit.getSalePolicyCode(), "优惠政策业务编号不能为空！");
    // TODO 校验项完善
    salePolicyLimitRepository.save(salePolicyLimit);
  }

  @Override
  public void deleteByIds(Set<String> ids) {
    Validate.notEmpty(ids, "ID集合不能为空！");
    this.salePolicyLimitRepository.deleteByIds(ids);
  }

  @Override
  public SalePolicyLimit findBySalePolicyCodeAndTenantCodeAndLimitStrategyCode(String salePolicyCode, String tenantCode, String limitStrategyCode) {
    return salePolicyLimitJpaRepository.findBySalePolicyCodeAndTenantCodeAndLimitStrategyCode(salePolicyCode, tenantCode, limitStrategyCode);
  }
}
