package com.biz.crm.dms.business.policy.local.sharestrategy;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.stereotype.Component;

import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.context.UnitpriceCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.ProductPolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.StepType;
import com.biz.crm.dms.business.policy.sdk.context.UnitpriceCycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.UnitpriceProduct;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.google.common.collect.Sets;

/**
 * 专门服务于 商品-单价满减、商品-单价特价 的分摊逻辑（按本品数量进行分摊）。
 * 所以不适用标品中提供的ExecuteShareStrategyWithAmount或者ExecuteShareStrategyWithNumber分摊逻辑</p>
 * 
 * 另外注意，直接减单价的优惠结束后，分摊时是否揉价的设定就不再起作用了，因为单价已经全部在本品上被剪掉了
 * 
 * @deprecated 2022-05-10，由于需求变更，该分摊策略不再有效
 * @author yinwenjie
 */
@Deprecated
@Component
public class UnitpriceShareStrategyWithNumber implements SalePolicyExecuteShareStrategy {

  @Override
  public void share(String customer , SalePolicyVo salePolicy ,  AbstractPolicyExecuteContext abstractPolicyExecuteContext , AbstractCycleExecuteContext abstractCycleExecuteContext , Set<String> productCodes) {
    DefaultPolicyExecuteContext policyExecuteContext = (DefaultPolicyExecuteContext)abstractPolicyExecuteContext;
    UnitpriceCycleExecuteContext cycleExecuteContext = (UnitpriceCycleExecuteContext)abstractCycleExecuteContext;
    UnitpriceCycleStepResult cycleLastStepResult = cycleExecuteContext.findLastStepResult();
    
    /*
     * 因为按照单价进行优惠的情况，实际上已经将优惠总价分摊到了本品上。
     * 所以只需要基于cycleExecuteContext中的本品最新单价和小计价格，完成优惠政策上下文中的优惠步进创建，操作步骤如下：
     * 1、累加参与本次计算的所有本品的数量总和（因为分摊“已参与优惠的数量”，还需要这个汇总信息）
     * 2、基于优惠本品状态，直接记录本品最新的单价和小计价格
     * 3、按照各个本品在数量中的比例，将总的优惠金额分摊到每个本品上，并记录到policyExecuteContext中
     * */
    
    // 1、=======
    // 这个变量cycleLastSurplusSubtotalNumber代表，经过本次所有阶梯计算后，总计还有多少本品数量没有享受优惠
    Integer cycleLastSurplusSubtotalNumber = cycleLastStepResult.getLastSurplusSubtotalNumber();
    // 变量 sumLastNumber 表示这些商品累计的数量
    BigDecimal sumLastNumber = BigDecimal.ZERO;
    Set<ProductPolicyStepResult> newProductPolicyStepResults = Sets.newLinkedHashSet();
    for (String productCode : productCodes) {
      ProductPolicyStepResult productPolicyStepResult = policyExecuteContext.findLastProductStepResultByProductCode(productCode);
      sumLastNumber = sumLastNumber.add(new BigDecimal(productPolicyStepResult.getInitNumbers()));
    }
    
    // 2、=======
    Set<UnitpriceProduct> lastProducts = cycleLastStepResult.getLastProducts();
    Map<String , UnitpriceProduct> lastProductMapping = lastProducts.stream().collect(Collectors.toMap(UnitpriceProduct::getProductCode , item-> item));
    for (String productCode : productCodes) {
      ProductPolicyStepResult productPolicyStepResult = policyExecuteContext.findLastProductStepResultByProductCode(productCode);
      BigDecimal initNumbers = new BigDecimal(productPolicyStepResult.getInitNumbers());
      // 找到对应的优惠本品状态
      UnitpriceProduct fullminusUnitpriceProduct = lastProductMapping.get(productCode);
      // 为当前商品添加一个新的优惠步进
      ProductPolicyStepResult newProductPolicyStepResult = new ProductPolicyStepResult();
      newProductPolicyStepResult.setStepType(salePolicy.getWholePolicy()?StepType.POLICY:StepType.PRODUCT);
      newProductPolicyStepResult.setSalePolicyCode(salePolicy.getSalePolicyCode());
      newProductPolicyStepResult.setExecuteCode(abstractCycleExecuteContext.getExecuteCode());
      newProductPolicyStepResult.setProductCode(productCode);
      newProductPolicyStepResult.setInitNumbers(productPolicyStepResult.getInitNumbers());
      newProductPolicyStepResult.setInitPrices(productPolicyStepResult.getInitPrices());
      newProductPolicyStepResult.setInitSubtotal(productPolicyStepResult.getInitSubtotal());
      newProductPolicyStepResult.setPreGifts(productPolicyStepResult.getLastGifts());
      newProductPolicyStepResult.setPrePrices(productPolicyStepResult.getLastPrices());
      newProductPolicyStepResult.setPreSubtotal(productPolicyStepResult.getLastSubtotal());
      newProductPolicyStepResult.setPreSurplusTotalAmount(productPolicyStepResult.getLastSurplusTotalAmount());
      newProductPolicyStepResult.setPreSurplusTotalNumber(productPolicyStepResult.getLastSurplusTotalNumber());
      newProductPolicyStepResult.setPreGiftEnjoyedTotalNumber(productPolicyStepResult.getLastGiftEnjoyedTotalNumber());
      newProductPolicyStepResult.setPreGiftEnjoyedTotalAmount(productPolicyStepResult.getLastGiftEnjoyedTotalAmount());
      // 因为不是买赠优惠，所以赠品数量、已享受优惠的赠品数量和金额不会改变
      newProductPolicyStepResult.setLastGifts(productPolicyStepResult.getLastGifts());
      newProductPolicyStepResult.setLastGiftEnjoyedTotalNumber(productPolicyStepResult.getLastGiftEnjoyedTotalNumber());
      newProductPolicyStepResult.setLastGiftEnjoyedTotalAmount(productPolicyStepResult.getLastGiftEnjoyedTotalAmount());
      // 因为不是按照金额进行的优惠，所以“还有多少本品小计金额还未进行优惠”的值，也不会改变
      newProductPolicyStepResult.setLastSurplusTotalAmount(productPolicyStepResult.getLastSurplusTotalAmount());
      
      /*
       * 本质上要完成以下本品信息的步进变化：
       * a、记录单价减少后最新的单价信息（注意，单价可能为0）
       * b、记录单价减少后最新的本品小计信息（注意，小计价格可能为0）
       * c、计算这个本品还有多少小计数量，没有参与任何优惠
       * 还没有参与优惠的本品小计数量 = 商品之前没有参与优惠的小计数量 - (优惠了多少小计数量)
       * */
      // a、===
      newProductPolicyStepResult.setLastPrices(fullminusUnitpriceProduct.getPrices());
      // b、===
      BigDecimal newLastSubtotal = new BigDecimal(fullminusUnitpriceProduct.getNumbers()).multiply(fullminusUnitpriceProduct.getPrices());
      newProductPolicyStepResult.setLastSubtotal(newLastSubtotal);
      // c、===
      BigDecimal lastRealSubtotalNumber = new BigDecimal(cycleLastSurplusSubtotalNumber).multiply(initNumbers.divide(sumLastNumber, 20, RoundingMode.HALF_UP)).setScale(0, RoundingMode.HALF_UP);
      newProductPolicyStepResult.setLastSurplusTotalNumber(lastRealSubtotalNumber.intValue());
      newProductPolicyStepResults.add(newProductPolicyStepResult);
    }
    
    // 3、======
    policyExecuteContext.addPolicyStepResult(newProductPolicyStepResults);
  }
}
