package com.biz.crm.dms.business.policy.local.utils;

import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

/**
 * 这个工具专门用来分析优惠政策标品默认实现中的各种表达式结构
 * @author yinwenjie
 */
public final class AnalyzeExpressionUtils {
  private AnalyzeExpressionUtils() {
    
  }
  /**
   * 该私有方法用于分析阶梯表达式中，有多少个需要填写的变量信息</br>
   * 注意标品中的阶梯表达式，采用的标量格式为{type:controller:varname}，而这里最主要分析的就是varname信息
   * @param expression 
   * @return
   */
  public static Map<Integer, String> analyzeLadderExpressionMapping(String expression) {
    Map<Integer, String> params = Maps.newHashMap();
    String patternMathed = "[:]{1}[\\w]+\\}";
    Matcher matcher = Pattern.compile(patternMathed).matcher(expression);
    int matcher_start = 0;
    int index = 1;
    while (matcher.find(matcher_start)){
      matcher_start = matcher.end();
      String group = matcher.group();
      params.put(index++ , StringUtils.substring(group, 1 , group.length() - 1));
    }
    return params;
  }
  
  /**
   * 该私有方法用于分析限量表达式中，有多少个需要填写的变量信息</br>
   * 注意标品中的阶梯表达式，采用的标量格式为{type:varname}，而这里最主要分析的就是varname信息
   * @param expression
   * @return
   */
  public static Set<String> analyzeLimiterExpressionMapping(String expression) {
    Set<String> paramNames = Sets.newLinkedHashSet();
    String patternMathed = "[:]{1}[\\w]+";
    Matcher matcher = Pattern.compile(patternMathed).matcher(expression);
    int matcher_start = 0;
    while (matcher.find(matcher_start)) {
      matcher_start = matcher.end();
      String groupSubString = matcher.group();
      paramNames.add(StringUtils.substring(groupSubString, 1));
    }
    return paramNames;
  }
}
