package com.biz.crm.dms.business.policy.local.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 促销政策/销售策略 使用的促销类型中 所设定的 政策类型执行器 的赠品
 * @author songjingen
 */
@Getter
@Setter
public class SalePolicyExecutorLadderGiftVo extends UuidVo {
  private static final long serialVersionUID = -3941772683050842091L;
  /**
   * 赠品编码
   */
  @ApiModelProperty("赠品编码")
  private String giftCode;
  /**
   * 赠品名称
   */
  @ApiModelProperty("赠品名称")
  private String giftName;
  /**
   * 赠品类型。1：赠送数量；2：赠送金额
   */
  @ApiModelProperty("赠品类型。1：赠送数量；2：赠送金额")
  private Integer giftType;
  /**
   * 赠送值，如果赠品类型（giftType）为1，则这里表示赠送数量；如果赠品类型（giftType）为2，则这里表示赠送金额
   */
  @ApiModelProperty("赠送值，如果赠品类型（giftType）为1，则这里表示赠送数量；如果赠品类型（giftType）为2，则这里表示赠送金额")
  private Integer giftValue;
}