package com.biz.crm.dms.business.policy.local.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

/**
 * 促销政策/销售策略 政策明细阶梯映射，如果当前销售政策不允许阶梯，则阶梯映射和销售政策只有一条对应关系信息
 * @author Administrator
 */
public class SalePolicyExecutorLadderVo extends UuidVo {
  private static final long serialVersionUID = -1942879272869887356L;
  
  @ApiModelProperty("阶梯编号，阶梯编号越小，执行优先级越高")
  private Integer indexs;
  
  @ApiModelProperty("对应设定的各个脚本值")
  private Set<SalePolicyExecutorLadderVarVo> executorLadderVars;

  @ApiModelProperty("对应设定的各个脚本值")
  private Set<SalePolicyExecutorLadderGiftVo> executorLadderGifts;

  public Integer getIndexs() {
    return indexs;
  }

  public void setIndexs(Integer indexs) {
    this.indexs = indexs;
  }

  public Set<SalePolicyExecutorLadderVarVo> getExecutorLadderVars() {
    return executorLadderVars;
  }

  public void setExecutorLadderVars(Set<SalePolicyExecutorLadderVarVo> executorLadderVars) {
    this.executorLadderVars = executorLadderVars;
  }

  public Set<SalePolicyExecutorLadderGiftVo> getExecutorLadderGifts() {
    return executorLadderGifts;
  }

  public void setExecutorLadderGifts(Set<SalePolicyExecutorLadderGiftVo> executorLadderGifts) {
    this.executorLadderGifts = executorLadderGifts;
  }
}
