package com.biz.crm.dms.business.policy.local.vo;

import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import io.swagger.annotations.ApiModelProperty;

/**
 * 以圈定经销商范围的方式，确认特定优惠政策的适用客户范围
 * @author yinwenjie
 */
public class SalePolicyScopeDistributorInfoVo extends AbstractSalePolicyCustomerScopeInfo {
  private static final long serialVersionUID = 1L;
  
  @ApiModelProperty("经销商的选定方式：include：包括；exclude：排除")
  private String selectionMethod;
  
  @ApiModelProperty("被选定或者被排除的经销商业务编号")
  private String distributorCode;
  
  @ApiModelProperty("被选定或者被排除的经销商业务名称")
  private String distributorName;

  public String getSelectionMethod() {
    return selectionMethod;
  }

  public void setSelectionMethod(String selectionMethod) {
    this.selectionMethod = selectionMethod;
  }

  public String getDistributorCode() {
    return distributorCode;
  }

  public void setDistributorCode(String distributorCode) {
    this.distributorCode = distributorCode;
  }

  public String getDistributorName() {
    return distributorName;
  }

  public void setDistributorName(String distributorName) {
    this.distributorName = distributorName;
  }
  
  @Override
  public String scopeCode() {
    return this.distributorCode;
  }
}
