/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.characteristic;

import com.biz.crm.dms.business.policy.local.entity.NotStackingCharacteristicInfo;
import com.biz.crm.dms.business.policy.local.repository.NotStackingCharacteristicInfoRepository;
import com.biz.crm.dms.business.policy.local.vo.NotStackingCharacteristicInfoVo;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicVoter;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractCharacteristicInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NotStackingCharacteristicStrategy
implements CharacteristicStrategy<NotStackingCharacteristicInfoVo> {
    @Autowired(required=false)
    private NotStackingCharacteristicInfoRepository notStackingCharacteristicInfoRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String characteristicCode() {
        return "notStackingCharacteristicStrategy";
    }

    public String characteristicName() {
        return "\u9009\u5b9a\u540e\u8868\u793a\u8be5\u4f18\u60e0\u653f\u7b56\u4e0d\u53ef\u8fdb\u884c\u53e0\u52a0";
    }

    public String getExpression() {
        return "\u9009\u5b9a\u540e\u8be5\u4f18\u60e0\u653f\u7b56\u4e0d\u53ef\u8fdb\u884c\u53e0\u52a0";
    }

    public Class<NotStackingCharacteristicInfoVo> getCharacteristicInfoClass() {
        return NotStackingCharacteristicInfoVo.class;
    }

    public NotStackingCharacteristicInfoVo onRequestCharacteristicInfo(String salePolicyCode) {
        String tenantCode = TenantUtils.getTenantCode();
        NotStackingCharacteristicInfo notStackingCharacteristicInfo = this.notStackingCharacteristicInfoRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
        if (notStackingCharacteristicInfo == null) {
            return null;
        }
        NotStackingCharacteristicInfoVo vo = (NotStackingCharacteristicInfoVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)notStackingCharacteristicInfo, NotStackingCharacteristicInfoVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        return vo;
    }

    public void onSaveCharacteristicInfo(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy) {
        Set characteristicInfos = currentSalePolicy.getCharacteristicInfos();
        String characteristicCode = this.characteristicCode();
        if (!CollectionUtils.isEmpty((Collection)characteristicInfos) && characteristicInfos.stream().map(AbstractCharacteristicInfo::getCharacteristicCode).collect(Collectors.toSet()).contains(characteristicCode)) {
            String tenantCode;
            String salePolicyCode = currentSalePolicy.getSalePolicyCode();
            NotStackingCharacteristicInfo exsit = this.notStackingCharacteristicInfoRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode = currentSalePolicy.getTenantCode());
            if (exsit != null) {
                return;
            }
            NotStackingCharacteristicInfo notStackingCharacteristicInfo = new NotStackingCharacteristicInfo();
            notStackingCharacteristicInfo.setCharacteristicCode(characteristicCode);
            notStackingCharacteristicInfo.setSalePolicyCode(salePolicyCode);
            notStackingCharacteristicInfo.setTenantCode(tenantCode);
            this.notStackingCharacteristicInfoRepository.save((Object)notStackingCharacteristicInfo);
        } else if (update && (CollectionUtils.isEmpty((Collection)characteristicInfos) || !characteristicInfos.stream().map(AbstractCharacteristicInfo::getCharacteristicCode).collect(Collectors.toSet()).contains(characteristicCode))) {
            String salePolicyCode = currentSalePolicy.getSalePolicyCode();
            String tenantCode = currentSalePolicy.getTenantCode();
            this.notStackingCharacteristicInfoRepository.deleteBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
        }
    }

    public CharacteristicVoter make(AbstractPolicyExecuteContext executeContext, SalePolicyVo salePolicyVo, String customerCode, boolean formal, String relevanceCode) {
        String tenantCode;
        String salePolicyCode = salePolicyVo.getSalePolicyCode();
        NotStackingCharacteristicInfo exsit = this.notStackingCharacteristicInfoRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode = salePolicyVo.getTenantCode());
        if (exsit == null) {
            return CharacteristicVoter.GRANTED;
        }
        return CharacteristicVoter.MONOPOLY;
    }

    public String errorMsg(SalePolicyVo salePolicyVo) {
        String salePolicyName = salePolicyVo.getSalePolicyName();
        return String.format("\u9009\u62e9\u4e86\u4e0d\u53ef\u53e0\u52a0\u7684\u4f18\u60e0\u653f\u7b56\u3010%s\u3011", salePolicyName);
    }
}

