/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.context;

import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.CycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.google.common.collect.Queues;
import java.math.BigDecimal;
import java.util.Deque;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public class DefaultCycleExecuteContext
implements AbstractCycleExecuteContext {
    private Set<SalePolicyConProduct> initPolicyProducts;
    private String executeCode;
    private final BigDecimal initSubtotalAmount;
    private final Integer initSubtotalNumber;
    private String customerCode;
    private Deque<CycleStepResult> cycleStepResults;

    public DefaultCycleExecuteContext(String executeCode, String customerCode, Set<SalePolicyConProduct> initPolicyProducts, BigDecimal initSubtotalAmount, Integer initSubtotalNumber, BigDecimal preSubtotalAmount, BigDecimal preSurplusSubtotalAmount, Integer preSurplusSubtotalNumber) {
        this.customerCode = customerCode;
        Validate.notBlank((CharSequence)executeCode, (String)"\u4f18\u60e0\u653f\u7b56\u6b65\u8fdb\u6267\u884c\u65f6\uff0c\u5fc5\u987b\u8bbe\u5b9a\u6b65\u8fdb\u6267\u884c\u6240\u4f7f\u7528\u7684\u5ba2\u6237\u7f16\u53f7customerCode", (Object[])new Object[0]);
        this.executeCode = executeCode;
        Validate.notBlank((CharSequence)executeCode, (String)"\u4f18\u60e0\u653f\u7b56\u6b65\u8fdb\u6267\u884c\u65f6\uff0c\u5fc5\u987b\u8bbe\u5b9a\u6b65\u8fdb\u6267\u884c\u6240\u4f7f\u7528\u7684\u6267\u884c\u5668\u7f16\u53f7executorCode", (Object[])new Object[0]);
        this.initPolicyProducts = initPolicyProducts;
        Validate.isTrue((!CollectionUtils.isEmpty(initPolicyProducts) ? 1 : 0) != 0, (String)"\u5728\u521d\u59cb\u5316\u653f\u7b56\u9636\u68af\u6267\u884c\u4e0a\u4e0b\u6587\u65f6\uff0c\u80fd\u591f\u53c2\u4e0e\u672c\u6b21\u4f18\u60e0\u653f\u7b56\u8ba1\u7b97\u7684\u672c\u54c1\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\u3002", (Object[])new Object[0]);
        this.initSubtotalAmount = initSubtotalAmount;
        Validate.notNull((Object)this.initSubtotalAmount, (String)"\u5728\u521d\u59cb\u5316\u653f\u7b56\u9636\u68af\u6267\u884c\u4e0a\u4e0b\u6587\u65f6\uff0c\u8ba1\u7b97\u521d\u59cb\u7684\u5c0f\u8ba1\u4ef7\u683c\u5fc5\u987b\u4f20\u5165\u3002", (Object[])new Object[0]);
        Validate.isTrue((this.initSubtotalAmount.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u5728\u521d\u59cb\u5316\u653f\u7b56\u9636\u68af\u6267\u884c\u4e0a\u4e0b\u6587\u65f6\uff0c\u8ba1\u7b97\u521d\u59cb\u7684\u5c0f\u8ba1\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0\u3002", (Object[])new Object[0]);
        this.initSubtotalNumber = initSubtotalNumber;
        Validate.notNull((Object)this.initSubtotalNumber, (String)"\u5728\u521d\u59cb\u5316\u653f\u7b56\u9636\u68af\u6267\u884c\u4e0a\u4e0b\u6587\u65f6\uff0c\u8ba1\u7b97\u521d\u59cb\u7684\u5c0f\u8ba1\u6570\u91cf\u5fc5\u987b\u4f20\u5165\u3002", (Object[])new Object[0]);
        Validate.isTrue((this.initSubtotalNumber > 0 ? 1 : 0) != 0, (String)"\u5728\u521d\u59cb\u5316\u653f\u7b56\u9636\u68af\u6267\u884c\u4e0a\u4e0b\u6587\u65f6\uff0c\u8ba1\u7b97\u521d\u59cb\u7684\u5c0f\u8ba1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002", (Object[])new Object[0]);
        this.cycleStepResults = Queues.newArrayDeque();
        CycleStepResult initCycleStepResult = new CycleStepResult(0, 0, preSubtotalAmount, preSurplusSubtotalAmount, preSurplusSubtotalNumber);
        initCycleStepResult.setLastSubtotalAmount(preSubtotalAmount);
        initCycleStepResult.setLastSurplusSubtotalAmount(preSurplusSubtotalAmount);
        initCycleStepResult.setLastSurplusSubtotalNumber(preSurplusSubtotalNumber);
        this.cycleStepResults.push(initCycleStepResult);
    }

    public void addStepResult(CycleStepResult newCycleStepResult) {
        Validate.notNull((Object)newCycleStepResult, (String)"\u65b0\u7684\u9636\u68af\u6b65\u9aa4\u4f18\u60e0\u7ed3\u679c\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Integer ladderIndex = newCycleStepResult.getLadderIndex();
        Integer executeTimes = newCycleStepResult.getExecuteTimes();
        Validate.isTrue((ladderIndex != null && ladderIndex >= 0 ? 1 : 0) != 0, (String)"\u65b0\u7684\u9636\u68af\u6b65\u9aa4\u4f18\u60e0\u5c42\u7ea7\u9700\u8981\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((executeTimes != null && executeTimes >= 1 ? 1 : 0) != 0, (String)"\u65b0\u7684\u9636\u68af\u6b65\u9aa4\u4f18\u60e0\u6267\u884c\u5e8f\u53f7\u9700\u8981\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (CycleStepResult oldCycleStepResult : this.cycleStepResults) {
            Validate.isTrue((oldCycleStepResult.getExecuteTimes().intValue() != executeTimes.intValue() ? 1 : 0) != 0, (String)"\u65b0\u7684\u9636\u68af\u6b65\u9aa4\u4f18\u60e0\u6267\u884c\u5e8f\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u91cd\u590d\u6027!!", (Object[])new Object[0]);
        }
        BigDecimal preSubtotalAmount = newCycleStepResult.getPreSubtotalAmount();
        Validate.notNull((Object)preSubtotalAmount, (String)"\u65b0\u7684\u9636\u68af\u6b65\u9aa4\u5fc5\u987b\u4f20\u5165preSubtotalAmount\uff0c\u9636\u68af\u4f18\u60e0\u524d\u7684\u603b\u5c0f\u8ba1\u4ef7\u683c", (Object[])new Object[0]);
        BigDecimal preSurplusSubtotalAmount = newCycleStepResult.getPreSurplusSubtotalAmount();
        Validate.notNull((Object)preSurplusSubtotalAmount, (String)"\u65b0\u7684\u9636\u68af\u6b65\u9aa4\u5fc5\u987b\u4f20\u5165preSurplusSubtotalAmount\uff0c\u9636\u68af\u4f18\u60e0\u524d\u8fd8\u672a\u8fdb\u884c\u4f18\u60e0\u7684\u5c0f\u8ba1\u4ef7\u683c", (Object[])new Object[0]);
        Integer preSurplusSubtotalNumber = newCycleStepResult.getPreSurplusSubtotalNumber();
        Validate.notNull((Object)preSurplusSubtotalNumber, (String)"\u65b0\u7684\u9636\u68af\u6b65\u9aa4\u5fc5\u987b\u4f20\u5165preSurplusSubtotalNumber\uff0c\u9636\u68af\u4f18\u60e0\u524d\u8fd8\u672a\u8fdb\u884c\u4f18\u60e0\u7684\u5c0f\u8ba1\u6570\u91cf", (Object[])new Object[0]);
        BigDecimal lastSubtotalAmount = newCycleStepResult.getLastSubtotalAmount();
        Validate.notNull((Object)lastSubtotalAmount, (String)"\u65b0\u7684\u9636\u68af\u6b65\u9aa4\u5fc5\u987b\u4f20\u5165lastSubtotalAmount\uff0c\u9636\u68af\u4f18\u60e0\u540e\u7684\u603b\u5c0f\u8ba1\u4ef7\u683c", (Object[])new Object[0]);
        BigDecimal lastSurplusSubtotalAmount = newCycleStepResult.getLastSurplusSubtotalAmount();
        Validate.notNull((Object)lastSurplusSubtotalAmount, (String)"\u65b0\u7684\u9636\u68af\u6b65\u9aa4\u5fc5\u987b\u4f20\u5165lastSurplusSubtotalAmount\uff0c\u9636\u68af\u4f18\u60e0\u540e\u7684\u8fd8\u672a\u8fdb\u884c\u4f18\u60e0\u7684\u5c0f\u8ba1\u4ef7\u683c", (Object[])new Object[0]);
        Integer lastSurplusSubtotalNumber = newCycleStepResult.getLastSurplusSubtotalNumber();
        Validate.notNull((Object)lastSurplusSubtotalNumber, (String)"\u65b0\u7684\u9636\u68af\u6b65\u9aa4\u5fc5\u987b\u4f20\u5165lastSurplusSubtotalNumber\uff0c\u9636\u68af\u4f18\u60e0\u540e\u7684\u8fd8\u672a\u8fdb\u884c\u4f18\u60e0\u7684\u5c0f\u8ba1\u6570\u91cf", (Object[])new Object[0]);
        this.cycleStepResults.push(newCycleStepResult);
    }

    public CycleStepResult findFirstStepResult() {
        return this.cycleStepResults.peekLast();
    }

    public CycleStepResult findLastStepResult() {
        return this.cycleStepResults.peek();
    }

    public Set<SalePolicyConProduct> getInitPolicyProducts() {
        return this.initPolicyProducts;
    }

    public BigDecimal getInitSubtotalAmount() {
        return this.initSubtotalAmount;
    }

    public Integer getInitSubtotalNumber() {
        return this.initSubtotalNumber;
    }

    public String getExecuteCode() {
        return this.executeCode;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }
}

