/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.context;

import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.GiftResultInfo;
import com.biz.crm.dms.business.policy.sdk.context.PolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.ProductPolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.context.StepType;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.util.CollectionUtils;

@ApiModel(value="DefaultPolicyExecuteContext", description="\u5173\u4e8e\u4f18\u60e0\u653f\u7b56\u6267\u884c/\u9884\u6267\u884c\u4e0a\u4e0b\u7684\u9ed8\u8ba4\u5b9e\u73b0")
public class DefaultPolicyExecuteContext
implements AbstractPolicyExecuteContext {
    private static final long serialVersionUID = 7243177308073572661L;
    private Set<SalePolicyConProduct> initPolicyProducts;
    @ApiModelProperty(value="\u5728\u6d3b\u52a8\u653f\u7b56\u6267\u884c\u7684\u4e00\u77ac\u95f4\uff0c\u6307\u5b9a\u7ecf\u9500\u5546\u53ef\u4ee5\u4f7f\u7528\u7684\u653f\u7b56\u4fe1\u606f(\u6ce8\u610f\u662f\u53ef\u4f7f\u7528\u7684\uff0c\u4e0d\u662f\u7ecf\u8fc7\u95e8\u69db\u5339\u914d\u7684\uff0c\u4e5f\u6ca1\u6709\u7ecf\u8fc7\u5546\u54c1\u8303\u56f4\u5339\u914d)")
    private Set<SalePolicyVo> initSalePolicys;
    @ApiModelProperty(value="\u5f53\u524d\u6d3b\u52a8\u653f\u7b56\u6267\u884c\u6240\u6d89\u53ca\u7684\u7ecf\u9500\u5546\u4fe1\u606f\uff08\u4e0a\u4e0b\u6587\u521d\u59cb\u5316\u540e\u4e0d\u53ef\u53d8\uff09")
    private final String tenantCode;
    @ApiModelProperty(value="\u5f53\u524d\u6d3b\u52a8\u653f\u7b56\u6267\u884c\u6240\u6d89\u53ca\u7684\u5ba2\u6237\u4fe1\u606f\uff08\u4e0a\u4e0b\u6587\u521d\u59cb\u5316\u540e\u4e0d\u53ef\u53d8\uff09")
    private final String customerCode;
    private final boolean kneading;
    private final boolean formal;
    private String relevanceCode;
    @ApiModelProperty(value="\u8be5\u503c\u8868\u793a\u5728\u6b63\u786e\u5b8c\u6210\u8ba1\u7b97\u540e\uff0c\u603b\u4f53\u4f18\u60e0\u91d1\u989d\u5dee\u503c")
    private BigDecimal totalDiscountAmount = BigDecimal.ZERO;
    @ApiModelProperty(value="\u8be5\u503c\u8868\u793a\u5728\u6b63\u786e\u5b8c\u6210\u8ba1\u7b97\u540e\uff0c\u603b\u4f53\u4f18\u60e0\u8d60\u54c1\u7684\u6c47\u603b")
    private List<GiftResultInfo> totalGiftResultInfos = Lists.newArrayList();
    @ApiModelProperty(value="\u6574\u5f20\u5355\u636e\u7684\u521d\u59cb\u4ef7\u683c\uff08\u5373\u6240\u6709\u8ba1\u7b97\u5f00\u59cb\u524d\u7684\u4ef7\u683c\uff09")
    private BigDecimal initTotalAmount;
    @ApiModelProperty(value="\u6574\u5f20\u5355\u636e\u7684\u521d\u59cb\u6570\u91cf\uff08\u5373\u6240\u6709\u8ba1\u7b97\u5f00\u59cb\u524d\u7684\u6570\u91cf\uff09")
    private Integer initTotalNumber;
    @ApiModelProperty(value="\u5546\u54c1\u5df2\u5339\u914d\u7684\u4f18\u60e0\u653f\u7b56\u57fa\u672c\u4fe1\u606f\uff08Key,\u5546\u54c1\u4e1a\u52a1\u7f16\u53f7\uff0cValue\uff1a\u4f18\u60e0\u653f\u7b56\u7f16\u53f7\uff0c\u6ce8\u610f\uff0c\u8fd9\u91cc\u53ea\u662f\u4f18\u60e0\u653f\u7b56\u7684\u4fe1\u606f(\u4e1a\u52a1\u7f16\u53f7)\uff0c\u5e76\u4e0d\u662f\u6bcf\u4e00\u4e2a\u5546\u54c1\u9488\u5bf9\u4f18\u60e0\u653f\u7b56\u7684\u6267\u884c\u7ed3\u679c\uff0c\u540e\u8005\u8bf7\u53c2\u89c1productPolicyStepResultMapping\u5c5e\u6027")
    private Map<String, Set<String>> matchedProductInfoMapping;
    @ApiModelProperty(value="\u5546\u54c1\u6bcf\u4e00\u6b21\u6267\u884c\u9636\u68af\u8ba1\u7b97\u540e\u7684\u7ed3\u679c\u4fe1\u606f\uff08\u65e0\u8bba\u5546\u54c1\u662f\u5426\u6ee1\u8db3\u4f18\u60e0\u653f\u7b56\u95e8\u69db\uff0c\u5e76\u8fdb\u884c\u4e86\u5b9e\u9645\u7684\u4f18\u60e0\uff09\uff0c\u6bcf\u4e00\u4e2ainitPolicyProducts\u96c6\u5408\u4e2d\u7684\u5546\u54c1\uff0c\u5728\u8fd9\u91cc\u90fd\u81f3\u5c11\u6709\u4e00\u6761\u4fe1\u606f\uff08\u65e2\u8fd9\u4e2a\u5546\u54c1\u7684\u521d\u59cb\u4f18\u60e0\u6b65\u8fdb\u4fe1\u606f\uff09")
    private Map<String, Deque<ProductPolicyStepResult>> productPolicyStepResultMapping;
    @ApiModelProperty(value="\u5df2\u88ab\u6392\u9664\u7684\u4f18\u60e0\u7b56\u7565\uff08Key\uff1a\u4f18\u60e0\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7\uff1bValue\uff1a\u6392\u9664\u539f\u56e0\u7684\u4e2d\u6587\u63cf\u8ff0\uff09")
    private Map<String, String> excludedPolicyMapping;
    @ApiModelProperty(value="\u5df2\u5339\u914d\u7684\u4f18\u60e0\u653f\u7b56\uff08\u5305\u62ec\u5546\u54c1\u4f18\u60e0\u548c\u6574\u5355\u4f18\u60e0\uff09\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\uff08\u6ce8\u610f\uff0c\u8fd9\u91cc\u53ea\u6709\u653f\u7b56\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u53f7\uff0c\u5e76\u4e0d\u662f\u6bcf\u4e00\u4e2a\u4f18\u60e0\u653f\u7b56\u7684\u6bcf\u4e00\u6b21\u6267\u884c\u7ed3\u679c\uff0c\u540e\u8005\u8bf7\u53c2\u89c1matchedPolicyResultMapping\uff09")
    private Set<String> matchedPolicyInfos;
    private Deque<PolicyStepResult> policyStepResults;

    public DefaultPolicyExecuteContext(Set<SalePolicyConProduct> initPolicyProducts, Set<SalePolicyVo> initSalePolicys, BigDecimal initTotalAmount, Integer initTotalNumber, String tenantCode, String customerCode, boolean kneading, boolean formal, String relevanceCode) {
        this.initPolicyProducts = initPolicyProducts;
        if (CollectionUtils.isEmpty(initSalePolicys)) {
            initSalePolicys = Sets.newConcurrentHashSet();
        }
        this.initSalePolicys = initSalePolicys;
        this.tenantCode = tenantCode;
        this.customerCode = customerCode;
        this.initTotalAmount = initTotalAmount;
        this.initTotalNumber = initTotalNumber;
        this.kneading = kneading;
        this.formal = formal;
        this.relevanceCode = relevanceCode;
        Validate.notBlank((CharSequence)tenantCode, (String)"tenantCode not blank !", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerCode, (String)"customerCode not blank !", (Object[])new Object[0]);
        Validate.notNull((Object)initTotalAmount, (String)"initTotalAmount not null !", (Object[])new Object[0]);
        Validate.notNull((Object)initTotalNumber, (String)"initTotalNumber not null !", (Object[])new Object[0]);
        if (this.formal) {
            Validate.notBlank((CharSequence)relevanceCode, (String)"relevanceCode not blank !", (Object[])new Object[0]);
        }
        this.matchedProductInfoMapping = Maps.newLinkedHashMap();
        this.excludedPolicyMapping = Maps.newLinkedHashMap();
        this.matchedPolicyInfos = Sets.newLinkedHashSet();
        this.productPolicyStepResultMapping = Maps.newLinkedHashMap();
        if (CollectionUtils.isEmpty(initPolicyProducts)) {
            return;
        }
        long distinctCount = initPolicyProducts.stream().map(SalePolicyConProduct::getProductCode).distinct().count();
        Validate.isTrue(((long)initPolicyProducts.size() == distinctCount ? 1 : 0) != 0, (String)"\u521b\u5efa\u4e0a\u4e0b\u6587\u65f6\uff0c\u53d1\u73b0\u4f20\u5165\u7684\u5546\u54c1\u7f16\u53f7\u91cd\u590d\u6216\u8005\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (this.formal) {
            distinctCount = initPolicyProducts.stream().map(SalePolicyConProduct::getBillItemCode).distinct().count();
            Validate.isTrue(((long)initPolicyProducts.size() == distinctCount ? 1 : 0) != 0, (String)"\u5728\u6b63\u5f0f\u6267\u884c\u521b\u5efa\u4e0a\u4e0b\u6587\u65f6\uff0c\u53d1\u73b0\u4f20\u5165\u7684\u5546\u54c1\u7968\u636e\u884c\u9879\u76ee\u53f7\u91cd\u590d\u6216\u8005\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        Set salePolicyCodes = initSalePolicys.stream().map(SalePolicyVo::getSalePolicyCode).collect(Collectors.toSet());
        for (SalePolicyConProduct defaultPolicyConProduct : initPolicyProducts) {
            Object[] selectedPolicyCodes;
            String billItemCode = defaultPolicyConProduct.getBillItemCode();
            if (this.formal) {
                Validate.notBlank((CharSequence)billItemCode, (String)"\u5f53\u524d\u6267\u884c\u662f\u6b63\u5f0f\u6267\u884c\uff0c\u4f46\u662f\u53d1\u73b0\u7ed9\u5b9a\u7684\u521d\u59cb\u5316\u5546\u54c1\u4e2d\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u5546\u54c1\u6ca1\u6709\u4f20\u5165\u7968\u636e\u884c\u9879\u76ee\u53f7\uff08billItemCode\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
            String productCode = defaultPolicyConProduct.getProductCode();
            Validate.notBlank((CharSequence)productCode, (String)"\u4f20\u5165\u7684\u521d\u59cb\u5316\u5546\u54c1\u5fc5\u987b\u6709\u5546\u54c1\u7684\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            BigDecimal quantity = defaultPolicyConProduct.getQuantity();
            Validate.isTrue((quantity != null && quantity.compareTo(BigDecimal.ZERO) == 1 ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u521d\u59cb\u5316\u5546\u54c1\u5fc5\u987b\u6709\u6570\u91cf\u4fe1\u606f\uff0c\u4e14\u6570\u91cf\u4fe1\u606f\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
            BigDecimal subtotalAmount = defaultPolicyConProduct.getSubtotalAmount();
            Validate.isTrue((subtotalAmount != null && subtotalAmount.compareTo(BigDecimal.ZERO) != -1 ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u521d\u59cb\u5316\u5546\u54c1\u5fc5\u987b\u6709\u5c0f\u8ba1\u91d1\u989d\u4fe1\u606f\uff0c\u4e14\u5c0f\u8ba1\u91d1\u989d\u4fe1\u606f\u5fc5\u987b\u4e0d\u4e3a\u8d1f\u6570", (Object[])new Object[0]);
            BigDecimal unitPrice = defaultPolicyConProduct.getUnitPrice();
            Validate.isTrue((unitPrice != null && unitPrice.compareTo(BigDecimal.ZERO) != -1 ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u521d\u59cb\u5316\u5546\u54c1\u5fc5\u987b\u6709\u5355\u4ef7\u4fe1\u606f\uff0c\u4e14\u5355\u4ef7\u4fe1\u606f\u5fc5\u987b\u4e0d\u4e3a\u8d1f\u6570", (Object[])new Object[0]);
            if (defaultPolicyConProduct.getProductName() == null) {
                defaultPolicyConProduct.setProductName("");
            }
            if ((selectedPolicyCodes = defaultPolicyConProduct.getSelectedPolicyCodes()) == null || selectedPolicyCodes.length <= 0) continue;
            String[] realSelectedPolicyCodes = (String[])Sets.intersection((Set)Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])selectedPolicyCodes)), salePolicyCodes).toArray((Object[])new String[0]);
            defaultPolicyConProduct.setSelectedPolicyCodes(realSelectedPolicyCodes);
        }
        for (SalePolicyConProduct policyConProduct : initPolicyProducts) {
            ProductPolicyStepResult productPolicyStepResult = new ProductPolicyStepResult();
            productPolicyStepResult.setStepType(StepType.INIT);
            productPolicyStepResult.setProductCode(policyConProduct.getProductCode());
            productPolicyStepResult.setSalePolicyCode(null);
            productPolicyStepResult.setInitNumbers(Integer.valueOf(policyConProduct.getQuantity().intValue()));
            productPolicyStepResult.setInitPrices(policyConProduct.getUnitPrice().setScale(4, RoundingMode.HALF_UP));
            productPolicyStepResult.setInitSubtotal(policyConProduct.getSubtotalAmount().setScale(4, RoundingMode.HALF_UP));
            productPolicyStepResult.setPrePrices(productPolicyStepResult.getInitPrices());
            productPolicyStepResult.setPreSubtotal(productPolicyStepResult.getInitSubtotal());
            productPolicyStepResult.setPreSurplusTotalAmount(productPolicyStepResult.getInitSubtotal());
            productPolicyStepResult.setPreSurplusTotalNumber(productPolicyStepResult.getInitNumbers());
            productPolicyStepResult.setPreGiftEnjoyedTotalNumber(Integer.valueOf(0));
            productPolicyStepResult.setPreGiftEnjoyedTotalAmount(BigDecimal.ZERO);
            productPolicyStepResult.setPreGifts((List)Lists.newLinkedList());
            productPolicyStepResult.setLastPrices(productPolicyStepResult.getInitPrices());
            productPolicyStepResult.setLastSubtotal(productPolicyStepResult.getInitSubtotal());
            productPolicyStepResult.setLastSurplusTotalAmount(productPolicyStepResult.getInitSubtotal());
            productPolicyStepResult.setLastSurplusTotalNumber(productPolicyStepResult.getInitNumbers());
            productPolicyStepResult.setLastGiftEnjoyedTotalNumber(Integer.valueOf(0));
            productPolicyStepResult.setLastGiftEnjoyedTotalAmount(BigDecimal.ZERO);
            productPolicyStepResult.setLastGifts((List)Lists.newLinkedList());
            ArrayDeque productPolicyStepResults = Queues.newArrayDeque();
            productPolicyStepResults.add(productPolicyStepResult);
            this.productPolicyStepResultMapping.put(policyConProduct.getProductCode(), productPolicyStepResults);
        }
        PolicyStepResult policyStepResult = new PolicyStepResult();
        policyStepResult.setSalePolicyCode(null);
        policyStepResult.setStepType(StepType.INIT);
        policyStepResult.setInitNumbers(initTotalNumber);
        policyStepResult.setInitSubtotal(initTotalAmount);
        policyStepResult.setPreGifts((List)Lists.newArrayList());
        policyStepResult.setPreSubtotal(initTotalAmount);
        policyStepResult.setPreSurplusTotalAmount(initTotalAmount);
        policyStepResult.setPreSurplusTotalNumber(initTotalNumber);
        policyStepResult.setPreGiftEnjoyedTotalNumber(Integer.valueOf(0));
        policyStepResult.setPreGiftEnjoyedTotalAmount(BigDecimal.ZERO);
        policyStepResult.setLastGifts((List)Lists.newArrayList());
        policyStepResult.setLastSubtotal(initTotalAmount);
        policyStepResult.setLastSurplusTotalNumber(initTotalNumber);
        policyStepResult.setLastSurplusTotalAmount(initTotalAmount);
        policyStepResult.setLastGiftEnjoyedTotalNumber(Integer.valueOf(0));
        policyStepResult.setLastGiftEnjoyedTotalAmount(BigDecimal.ZERO);
        this.policyStepResults = Queues.newArrayDeque();
        this.policyStepResults.push(policyStepResult);
    }

    public void addExcludedPolicy(SalePolicyVo excludedPolicy, String message) {
        Validate.notNull((Object)excludedPolicy, (String)"\u6dfb\u52a0\u6392\u9664\u653f\u7b56\u65f6\uff0c\u653f\u7b56\u4fe1\u606f\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)message, (String)"\u6dfb\u52a0\u6392\u9664\u653f\u7b56\u65f6\uff0c\u6392\u9664\u539f\u56e0\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.initSalePolicys.contains(excludedPolicy), (String)"\u6dfb\u52a0\u6392\u9664\u653f\u7b56\u65f6\uff0c\u653f\u7b56\u4fe1\u606f\u5fc5\u987b\u5df2\u5b58\u5728\u4e8einitSalePolicys\u6e05\u5355\u4e2d", (Object[])new Object[0]);
        this.excludedPolicyMapping.put(excludedPolicy.getSalePolicyCode(), message);
    }

    public void excludeMatchedPolicyMapping(String productCode, String policyCode) {
        Validate.isTrue((this.policyStepResults.size() == 1 ? 1 : 0) != 0, (String)"\u56e0\u4e3a\u4f18\u60e0\u653f\u7b56\u5df2\u7ecf\u5f00\u59cb\u6267\u884c\u6b65\u8fdb\uff0c\u6240\u4ee5\u4e0d\u80fd\u5728\u4fee\u6b63\u672c\u54c1\u548c\u4f18\u60e0\u653f\u7b56\u7684\u5339\u914d\u5173\u7cfb\uff0c\u5982\u679c\u8981\u8fdb\u884c\u4fee\u6539\u8bf7\u8c03\u7528resetExcludedPolicy\u65b9\u6cd5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productCode, (String)"\u8fdb\u884c\u672c\u54c1\u548c\u5df2\u5339\u914d\u4f18\u60e0\u653f\u7b56\u7684\u89e3\u7ed1\u65f6\uff0c\u672c\u54c1\u4e1a\u52a1\u7f16\u7801\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)policyCode, (String)"\u8fdb\u884c\u672c\u54c1\u548c\u5df2\u5339\u914d\u4f18\u60e0\u653f\u7b56\u7684\u89e3\u7ed1\u65f6\uff0c\u4f18\u60e0\u653f\u7b56\u7f16\u7801\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)this.productPolicyStepResultMapping.get(productCode)) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u672c\u54c1\u548c\u5df2\u5339\u914d\u4f18\u60e0\u653f\u7b56\u7684\u89e3\u7ed1\u65f6\uff0c\u672c\u54c1\u4fe1\u606f\u5e94\u8be5\u662f\u53c2\u4e0e\u672c\u6b21\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7684\u672c\u54c1!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.matchedPolicyInfos.contains(policyCode), (String)"\u8fdb\u884c\u672c\u54c1\u548c\u5df2\u5339\u914d\u4f18\u60e0\u653f\u7b56\u7684\u89e3\u7ed1\u65f6\uff0c\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u5e94\u8be5\u662f\u4ee5\u6b63\u786e\u5339\u914d\u7684\u4f18\u60e0\u653f\u7b56!!", (Object[])new Object[0]);
        Set<String> matchedPolicies = this.matchedProductInfoMapping.get(productCode);
        Validate.isTrue((!CollectionUtils.isEmpty(matchedPolicies) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u672c\u54c1\u548c\u5df2\u5339\u914d\u4f18\u60e0\u653f\u7b56\u7684\u89e3\u7ed1\u65f6\uff0c\u6307\u5b9a\u7684\u672c\u54c1\u5e94\u8be5\u5b58\u5728\u5df2\u5339\u914d\u7684\u4f18\u60e0\u653f\u7b56", (Object[])new Object[0]);
        Validate.isTrue((boolean)matchedPolicies.contains(policyCode), (String)"\u8fdb\u884c\u672c\u54c1\u548c\u5df2\u5339\u914d\u4f18\u60e0\u653f\u7b56\u7684\u89e3\u7ed1\u65f6\uff0c\u6307\u5b9a\u7684\u672c\u54c1\u548c\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\uff0c\u5e94\u8be5\u5b58\u5728\u5339\u914d\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        matchedPolicies.remove(policyCode);
        for (Map.Entry<String, Set<String>> matchedProductItem : this.matchedProductInfoMapping.entrySet()) {
            Set<String> matchedPolicyItems = matchedProductItem.getValue();
            if (!matchedPolicyItems.contains(policyCode)) continue;
            return;
        }
        this.excludedPolicyMapping.put(policyCode, "\u4f18\u60e0\u653f\u7b56\u88ab\u64cd\u4f5c\u8005\u6307\u5b9a\u6392\u9664");
    }

    public void resetExcludedPolicy(String policyCode, Set<String> requestRollbackProductCodes, String erroeMsg) {
        Validate.notBlank((CharSequence)policyCode, (String)"\u56de\u9000\u4f18\u60e0\u653f\u7b56\u7684\u6267\u884c\u7ed3\u679c\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{policyCode});
        Validate.isTrue((this.initSalePolicys.stream().filter(item -> StringUtils.equals((CharSequence)policyCode, (CharSequence)item.getSalePolicyCode())).count() != 0L ? 1 : 0) != 0, (String)"\u56de\u9000\u4f18\u60e0\u653f\u7b56\u7684\u6267\u884c\u7ed3\u679c\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{policyCode});
        Validate.notBlank((CharSequence)erroeMsg, (String)"\u56de\u9000\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7ed3\u679c\u65f6\uff0c\u5fc5\u987b\u8bf4\u660e\u4f18\u60e0\u653f\u7b56\u56de\u9000\u7684\u539f\u56e0", (Object[])new Object[0]);
        Set<Map.Entry<String, Set<String>>> matchedProductInfoEntrys = this.matchedProductInfoMapping.entrySet();
        LinkedHashSet mustRollbackProductCodes = Sets.newLinkedHashSet();
        for (Map.Entry<String, Set<String>> matchedProductInfoMappingItem : matchedProductInfoEntrys) {
            Set<String> matchedPolicyCodes = matchedProductInfoMappingItem.getValue();
            if (!matchedPolicyCodes.contains(policyCode)) continue;
            mustRollbackProductCodes.add(matchedProductInfoMappingItem.getKey());
        }
        if (!CollectionUtils.isEmpty(requestRollbackProductCodes)) {
            mustRollbackProductCodes = Sets.intersection(requestRollbackProductCodes, (Set)mustRollbackProductCodes);
        }
        for (String mustRollbackProductCode : mustRollbackProductCodes) {
            Deque<ProductPolicyStepResult> productPolicyStepResults = this.productPolicyStepResultMapping.get(mustRollbackProductCode);
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)productPolicyStepResults.peek().getSalePolicyCode(), (CharSequence)policyCode), (String)"\u65e0\u6cd5\u56de\u9000\u672c\u54c1(%s)\u9488\u5bf9\u4f18\u60e0\u653f\u7b56\u7684\u6267\u884c\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{mustRollbackProductCode});
        }
        PolicyStepResult lastPolicyStepResult = this.policyStepResults.peek();
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)lastPolicyStepResult.getSalePolicyCode(), (CharSequence)policyCode), (String)"\u65e0\u6cd5\u56de\u9000\u6574\u4f53\u4f18\u60e0\u6b65\u8fdb\u7684\u6267\u884c\u60c5\u51b5\uff0c\u56e0\u4e3a\u5b83\u4e0d\u662f\u6700\u540e\u4e00\u4e2a\u6267\u884c\u7684\u4f18\u60e0\u653f\u7b56\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        this.excludedPolicyMapping.put(policyCode, erroeMsg);
        Map<String, Deque<ProductPolicyStepResult>> productPolicyStepResultMappingEntrys = this.productPolicyStepResultMapping;
        for (String mustRollbackProductCode : mustRollbackProductCodes) {
            Deque<ProductPolicyStepResult> productPolicyStepResults = productPolicyStepResultMappingEntrys.get(mustRollbackProductCode);
            productPolicyStepResults.poll();
        }
        this.policyStepResults.poll();
        BigDecimal preSubtotal = lastPolicyStepResult.getPreSubtotal();
        BigDecimal lastSubtotal = lastPolicyStepResult.getLastSubtotal();
        BigDecimal discountAmount = lastSubtotal.subtract(preSubtotal);
        this.totalDiscountAmount = this.totalDiscountAmount.subtract(discountAmount);
        this.totalGiftResultInfos = lastPolicyStepResult.getPreGifts();
    }

    public Integer sizeOfExcludedPolices() {
        return this.excludedPolicyMapping.size();
    }

    public void addNewMathedPolicy(SalePolicyVo matchedPolicy) {
        Validate.notNull((Object)matchedPolicy, (String)"\u6dfb\u52a0\u5339\u914d\u7684\u6574\u5355\u4f18\u60e0\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u4fe1\u606f\u5bf9\u8c61\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)matchedPolicy.getWholePolicy(), (String)"\u6dfb\u52a0\u5339\u914d\u7684\u6574\u5355\u4f18\u60e0\u65f6\uff0c\u4f20\u5165\u7684\u4f18\u60e0\u4fe1\u606f\u5fc5\u987b\u662f\u6574\u5355\u4f18\u60e0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.initSalePolicys.contains(matchedPolicy), (String)"\u6dfb\u52a0\u5339\u914d\u7684\u6574\u5355\u4f18\u60e0\u65f6\uff0c\u4f20\u5165\u7684\u4f18\u60e0\u4fe1\u606f\u5fc5\u987b\u5b58\u5728\u4e8e\u4e0a\u4e0b\u6587\u521d\u59cb\u5316\u65f6\u7684\u96c6\u5408\u4e2d(%s)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{matchedPolicy.getSalePolicyCode()});
        if (!CollectionUtils.isEmpty(this.excludedPolicyMapping)) {
            Validate.isTrue((this.excludedPolicyMapping.get(matchedPolicy.getSalePolicyCode()) == null ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u5339\u914d\u7684\u6574\u5355\u4f18\u60e0\u65f6\uff0c\u4f18\u60e0\u653f\u7b56\u4e0d\u80fd\u5b58\u5728\u4e8e\u5df2\u7ecf\u88ab\u914d\u51fa\u7684\u8bb0\u5f55\u4fe1\u606f\u4e2d", (Object[])new Object[0]);
        }
        this.matchedPolicyInfos.add(matchedPolicy.getSalePolicyCode());
        if (!CollectionUtils.isEmpty(this.initPolicyProducts)) {
            for (SalePolicyConProduct policyConProduct : this.initPolicyProducts) {
                this.setMatchedProductInfoMapping(policyConProduct.getProductCode(), matchedPolicy.getSalePolicyCode());
            }
        }
    }

    public void addNewMathedPolicy(SalePolicyVo matchedPolicy, String[] matchedProductCodes) {
        Validate.notNull((Object)matchedPolicy, (String)"\u6dfb\u52a0\u5339\u914d\u7684\u6574\u5355\u4f18\u60e0\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u4fe1\u606f\u5bf9\u8c61\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.initSalePolicys.contains(matchedPolicy), (String)"\u6dfb\u52a0\u5339\u914d\u7684\u5546\u54c1\u4f18\u60e0\u65f6\uff0c\u4f20\u5165\u7684\u4f18\u60e0\u4fe1\u606f\u5fc5\u987b\u5b58\u5728\u4e8e\u4e0a\u4e0b\u6587\u521d\u59cb\u5316\u65f6\u7684\u96c6\u5408\u4e2d(%s)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{matchedPolicy.getSalePolicyCode()});
        if (!CollectionUtils.isEmpty(this.excludedPolicyMapping)) {
            Validate.isTrue((this.excludedPolicyMapping.get(matchedPolicy.getSalePolicyCode()) == null ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u5339\u914d\u7684\u6574\u5355\u4f18\u60e0\u65f6\uff0c\u4f18\u60e0\u653f\u7b56\u4e0d\u80fd\u5b58\u5728\u4e8e\u5df2\u7ecf\u88ab\u6392\u9664\u7684\u8bb0\u5f55\u4fe1\u606f\u4e2d", (Object[])new Object[0]);
        }
        Validate.isTrue((matchedProductCodes != null && matchedProductCodes.length > 0 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u5339\u914d\u7684\u5546\u54c1\u4f18\u60e0\u65f6\uff0c\u81f3\u5c11\u9700\u8981\u4f20\u5165\u4e00\u6761\u5546\u54c1\u4e1a\u52a1\u7f16\u7801\u4fe1\u606f", (Object[])new Object[0]);
        int disCount = (int)Arrays.stream(matchedProductCodes).distinct().count();
        Validate.isTrue((disCount == matchedProductCodes.length ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u5339\u914d\u7684\u5546\u54c1\u4f18\u60e0\u65f6\uff0c\u5546\u54c1\u4e1a\u52a1\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.matchedPolicyInfos.add(matchedPolicy.getSalePolicyCode());
        for (String matchedProductCode : matchedProductCodes) {
            this.setMatchedProductInfoMapping(matchedProductCode, matchedPolicy.getSalePolicyCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setMatchedProductInfoMapping(String productCode, String policyCode) {
        LinkedHashSet matchedPolicyCodes = this.matchedProductInfoMapping.get(productCode);
        if (!CollectionUtils.isEmpty(matchedPolicyCodes)) {
            matchedPolicyCodes.add((String)policyCode);
            return;
        }
        Class<AbstractPolicyExecuteContext> clazz = AbstractPolicyExecuteContext.class;
        synchronized (AbstractPolicyExecuteContext.class) {
            while (this.matchedProductInfoMapping.get(productCode) == null) {
                matchedPolicyCodes = Sets.newLinkedHashSet();
                this.matchedProductInfoMapping.put(productCode, matchedPolicyCodes);
                matchedPolicyCodes.add(policyCode);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public void addPolicyStepResult(Set<ProductPolicyStepResult> productStepResults) {
        Integer newPreSurplusTotalNumber;
        if (CollectionUtils.isEmpty(productStepResults)) {
            return;
        }
        long salePolicyCodeCount = productStepResults.stream().map(ProductPolicyStepResult::getSalePolicyCode).filter(item -> Objects.nonNull(item)).distinct().count();
        Validate.isTrue((salePolicyCodeCount == 1L ? 1 : 0) != 0, (String)"\u8fd9\u4e9b\u4ea7\u54c1\u6b65\u8fdb\u660e\u7ec6\uff0c\u53ea\u80fd\u8bbe\u5b9a\u4e00\u81f4\u7684\u4f18\u60e0\u653f\u7b56\u4fe1\u606fsalePolicyCode\uff0c\u8bf7\u68c0\u67e5\u503c\u7684\u4f20\u9012!!", (Object[])new Object[0]);
        long executorCodeCount = productStepResults.stream().map(ProductPolicyStepResult::getExecuteCode).filter(item -> Objects.nonNull(item)).distinct().count();
        Validate.isTrue((executorCodeCount == 1L ? 1 : 0) != 0, (String)"\u8fd9\u4e9b\u4ea7\u54c1\u6b65\u8fdb\u660e\u7ec6\uff0c\u53ea\u80fd\u8bbe\u5b9a\u4e00\u81f4\u7684\u4f18\u60e0\u653f\u7b56\u6267\u884c\u5668executorCode\uff0c\u8bf7\u68c0\u67e5\u503c\u7684\u4f20\u9012!!", (Object[])new Object[0]);
        String currentSalePolicyCode = null;
        String currentExecutorCode = null;
        for (ProductPolicyStepResult newProductPolicyStepResult : productStepResults) {
            String salePolicyCode = newProductPolicyStepResult.getSalePolicyCode();
            Validate.notBlank((CharSequence)salePolicyCode, (String)"\u8fd9\u6279\u4f18\u60e0\u6b65\u8fdb\u8bbe\u8ba1\u7684\u672c\u54c1\u4fe1\u606f\uff0c\u5bf9\u5e94\u7684\u4f18\u60e0\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7salePolicyCode\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            currentSalePolicyCode = salePolicyCode;
            String executorCode = newProductPolicyStepResult.getExecuteCode();
            Validate.notBlank((CharSequence)executorCode, (String)"\u8fd9\u6279\u4f18\u60e0\u6b65\u8fdb\u8bbe\u8ba1\u7684\u672c\u54c1\u4fe1\u606f\uff0c\u5bf9\u5e94\u7684\u4f18\u60e0\u653f\u7b56\u6267\u884c\u5668\u7f16\u53f7executorCode\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            currentExecutorCode = executorCode;
            String productCode = newProductPolicyStepResult.getProductCode();
            Validate.notBlank((CharSequence)productCode, (String)"\u5fc5\u987b\u4f20\u5165\u672c\u54c1\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
            Set<String> matchedSalePolicyCodes = this.matchedProductInfoMapping.get(productCode);
            Validate.isTrue((!CollectionUtils.isEmpty(matchedSalePolicyCodes) ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u4f18\u60e0\u653f\u7b56\u6b65\u8fdb\u672c\u54c1\u4fe1\u606f\u5e76\u4e0d\u5b58\u5728\u4e8e\u6700\u521d\u7684\u4f18\u60e0\u5339\u914d\u96c6\u5408\uff08matchedProductInfoMapping\uff09\u4e2d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)matchedSalePolicyCodes.contains(salePolicyCode), (String)"\u4f20\u5165\u7684\u4f18\u60e0\u653f\u7b56\u6b65\u8fdb\u672c\u54c1\u4fe1\u606f\u5e76\u6ca1\u6709\u5728\u6700\u521d\u9884\u5224\u5b9a\u4e2d\u5339\u914d\u5f53\u524d\u7684\u4f18\u60e0\u653f\u7b56[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{salePolicyCode});
            StepType stepType = newProductPolicyStepResult.getStepType();
            Validate.isTrue((stepType != null && stepType != StepType.INIT ? 1 : 0) != 0, (String)"\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u672c\u54c1\u6b65\u8fdb\u7684\u6027\u8d28(StepType)", (Object[])new Object[0]);
            Deque<ProductPolicyStepResult> productPolicyStepResultQueue = this.productPolicyStepResultMapping.get(productCode);
            ProductPolicyStepResult lastProductPolicyStepResult = productPolicyStepResultQueue.peek();
            List giftResultInfos = lastProductPolicyStepResult.getLastGifts();
            BigDecimal lastPrices = lastProductPolicyStepResult.getLastPrices();
            BigDecimal lastSubtotal = lastProductPolicyStepResult.getLastSubtotal();
            BigDecimal lastSurplusTotalAmount = lastProductPolicyStepResult.getLastSurplusTotalAmount();
            Integer lastSurplusTotalNumber = lastProductPolicyStepResult.getLastSurplusTotalNumber();
            List newPreGiftResultInfos = newProductPolicyStepResult.getPreGifts();
            BigDecimal newPrePrices = newProductPolicyStepResult.getPrePrices();
            BigDecimal bigDecimal = newProductPolicyStepResult.getPreSubtotal();
            BigDecimal bigDecimal2 = newProductPolicyStepResult.getPreSurplusTotalAmount();
            newPreSurplusTotalNumber = newProductPolicyStepResult.getPreSurplusTotalNumber();
            Validate.isTrue((boolean)this.validateGiftMatch(giftResultInfos, newPreGiftResultInfos, newProductPolicyStepResult.getLastGifts()), (String)"\u5728\u8fdb\u884c\u672c\u54c1\u4f18\u60e0\u60c5\u51b5\u6b65\u8fdb\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u4e24\u6b21\u6b65\u8fdb\u7684\u8d60\u54c1\u521d\u59cb\u60c5\u51b5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((lastPrices.compareTo(newPrePrices) == 0 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u672c\u54c1\u4f18\u60e0\u60c5\u51b5\u6b65\u8fdb\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u4e24\u6b21\u6b65\u8fdb\u7684\u5355\u4ef7\u521d\u59cb\u60c5\u51b5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((lastSubtotal.compareTo(bigDecimal) == 0 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u672c\u54c1\u4f18\u60e0\u60c5\u51b5\u6b65\u8fdb\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u4e24\u6b21\u6b65\u8fdb\u7684\u5c0f\u8ba1\u4ef7\u683c\u521d\u59cb\u60c5\u51b5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((lastSurplusTotalAmount.compareTo(bigDecimal2) == 0 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u672c\u54c1\u4f18\u60e0\u60c5\u51b5\u6b65\u8fdb\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u4e24\u6b21\u6b65\u8fdb\u7684\u672a\u4f18\u60e0\u91d1\u989d\u521d\u59cb\u60c5\u51b5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((lastSurplusTotalNumber.compareTo(newPreSurplusTotalNumber) == 0 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u672c\u54c1\u4f18\u60e0\u60c5\u51b5\u6b65\u8fdb\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u4e24\u6b21\u6b65\u8fdb\u7684\u672a\u4f18\u60e0\u6570\u91cf\u521d\u59cb\u60c5\u51b5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            newProductPolicyStepResult.setInitNumbers(lastProductPolicyStepResult.getInitNumbers());
            newProductPolicyStepResult.setInitPrices(lastProductPolicyStepResult.getInitPrices());
            newProductPolicyStepResult.setInitSubtotal(lastProductPolicyStepResult.getInitSubtotal());
            productPolicyStepResultQueue.push(newProductPolicyStepResult);
        }
        Validate.isTrue((boolean)this.matchedPolicyInfos.contains(currentSalePolicyCode), (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u6b65\u8fdb\u6dfb\u52a0\u65f6\uff0c\u4f20\u5165\u7684\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\u5e76\u6ca1\u6709\u5728\u6700\u521d\u9884\u5224\u5b9a\u4e2d\u5339\u914d\u5f53\u524d\u7684\u4f18\u60e0\u653f\u7b56\uff08%\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{currentSalePolicyCode});
        Map<String, SalePolicyVo> initSalePolicyMapping = this.initSalePolicys.stream().collect(Collectors.toMap(SalePolicyVo::getSalePolicyCode, item -> item));
        SalePolicyVo currentSalePolicy = initSalePolicyMapping.get(currentSalePolicyCode);
        Validate.notNull((Object)currentSalePolicy, (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u6b65\u8fdb\u6dfb\u52a0\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        StepType stepType = currentSalePolicy.getWholePolicy() != false ? StepType.POLICY : StepType.PRODUCT;
        PolicyStepResult lastPolicyStepResult = this.policyStepResults.peek();
        List lastGiftResultInfos = lastPolicyStepResult.getLastGifts();
        BigDecimal lastSubtotal = lastPolicyStepResult.getLastSubtotal();
        BigDecimal lastSurplusTotalAmount = lastPolicyStepResult.getLastSurplusTotalAmount();
        Integer lastSurplusTotalNumber = lastPolicyStepResult.getLastSurplusTotalNumber();
        PolicyStepResult newPolicyStepResult = new PolicyStepResult();
        newPolicyStepResult.setInitNumbers(lastPolicyStepResult.getInitNumbers());
        newPolicyStepResult.setInitSubtotal(lastPolicyStepResult.getInitSubtotal());
        newPolicyStepResult.setSalePolicyCode(currentSalePolicyCode);
        newPolicyStepResult.setExecutorCode(currentExecutorCode);
        newPolicyStepResult.setStepType(stepType);
        newPolicyStepResult.setPreGifts(lastPolicyStepResult.getLastGifts());
        newPolicyStepResult.setPreSubtotal(lastPolicyStepResult.getLastSubtotal());
        newPolicyStepResult.setPreSurplusTotalAmount(lastPolicyStepResult.getLastSurplusTotalAmount());
        newPolicyStepResult.setPreSurplusTotalNumber(lastPolicyStepResult.getLastSurplusTotalNumber());
        newPolicyStepResult.setPreGiftEnjoyedTotalNumber(lastPolicyStepResult.getLastGiftEnjoyedTotalNumber());
        newPolicyStepResult.setPreGiftEnjoyedTotalAmount(lastPolicyStepResult.getLastGiftEnjoyedTotalAmount());
        LinkedHashMap summaryGiftStatuMapping = Maps.newLinkedHashMap();
        BigDecimal summarySurplusTotalAmount = BigDecimal.ZERO;
        Integer summarySurplusTotalNumber = 0;
        BigDecimal summarySubTotalAmount = BigDecimal.ZERO;
        Integer summaryGiftEnjoyedTotalNumber = 0;
        BigDecimal summaryGiftsEnjoyedTotalAmount = BigDecimal.ZERO;
        for (Map.Entry entry : this.productPolicyStepResultMapping.entrySet()) {
            ProductPolicyStepResult productPolicyStepResult = (ProductPolicyStepResult)((Deque)entry.getValue()).peek();
            List giftResultInfos = productPolicyStepResult.getLastGifts();
            if (!CollectionUtils.isEmpty((Collection)giftResultInfos)) {
                for (GiftResultInfo lastGiftResultInfo : giftResultInfos) {
                    String giftProductCode = lastGiftResultInfo.getProductCode();
                    Triple exsitTriple = null;
                    Triple newTriple = null;
                    exsitTriple = (Triple)summaryGiftStatuMapping.get(giftProductCode);
                    if (exsitTriple == null) {
                        newTriple = Triple.of((Object)lastGiftResultInfo.getProductName(), (Object)lastGiftResultInfo.getQuantity(), (Object)lastGiftResultInfo.getSubtotalAmount());
                    } else {
                        Integer newQuantity = (Integer)exsitTriple.getMiddle() + lastGiftResultInfo.getQuantity();
                        BigDecimal newSubtotalAmount = ((BigDecimal)exsitTriple.getRight()).add(lastGiftResultInfo.getSubtotalAmount());
                        newTriple = Triple.of((Object)lastGiftResultInfo.getProductName(), (Object)newQuantity, (Object)newSubtotalAmount);
                    }
                    summaryGiftStatuMapping.put(giftProductCode, newTriple);
                }
            }
            summarySurplusTotalAmount = summarySurplusTotalAmount.add(productPolicyStepResult.getLastSurplusTotalAmount());
            summarySurplusTotalNumber = summarySurplusTotalNumber + productPolicyStepResult.getLastSurplusTotalNumber();
            summarySubTotalAmount = summarySubTotalAmount.add(productPolicyStepResult.getLastSubtotal());
            summaryGiftEnjoyedTotalNumber = summaryGiftEnjoyedTotalNumber + (productPolicyStepResult.getLastGiftEnjoyedTotalNumber() == null ? 0 : productPolicyStepResult.getLastGiftEnjoyedTotalNumber());
            summaryGiftsEnjoyedTotalAmount = summaryGiftsEnjoyedTotalAmount.add(productPolicyStepResult.getLastGiftEnjoyedTotalAmount() == null ? BigDecimal.ZERO : productPolicyStepResult.getLastGiftEnjoyedTotalAmount());
        }
        if (!CollectionUtils.isEmpty((Map)summaryGiftStatuMapping)) {
            ArrayList newGiftResultInfos = Lists.newArrayList();
            for (Map.Entry entry : summaryGiftStatuMapping.entrySet()) {
                Triple giftItem = (Triple)entry.getValue();
                GiftResultInfo newGiftResultInfo = new GiftResultInfo();
                newGiftResultInfo.setProductCode((String)entry.getKey());
                newGiftResultInfo.setProductName((String)giftItem.getLeft());
                newGiftResultInfo.setQuantity((Integer)giftItem.getMiddle());
                newGiftResultInfo.setSubtotalAmount((BigDecimal)giftItem.getRight());
                newGiftResultInfos.add(newGiftResultInfo);
            }
            newPolicyStepResult.setLastGifts((List)newGiftResultInfos);
        } else {
            newPolicyStepResult.setLastGifts((List)Lists.newArrayList());
        }
        newPolicyStepResult.setLastSubtotal(summarySubTotalAmount);
        newPolicyStepResult.setLastSurplusTotalAmount(summarySurplusTotalAmount);
        newPolicyStepResult.setLastSurplusTotalNumber(summarySurplusTotalNumber);
        newPolicyStepResult.setLastGiftEnjoyedTotalNumber(summaryGiftEnjoyedTotalNumber);
        newPolicyStepResult.setLastGiftEnjoyedTotalAmount(summaryGiftsEnjoyedTotalAmount);
        List newPreGiftResultInfos = newPolicyStepResult.getPreGifts();
        BigDecimal bigDecimal = newPolicyStepResult.getPreSubtotal();
        BigDecimal bigDecimal3 = newPolicyStepResult.getPreSurplusTotalAmount();
        newPreSurplusTotalNumber = newPolicyStepResult.getPreSurplusTotalNumber();
        Validate.isTrue((boolean)this.validateGiftMatch(lastGiftResultInfos, newPreGiftResultInfos, newPolicyStepResult.getLastGifts()), (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u6b65\u8fdb\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u4e24\u6b21\u6b65\u8fdb\u7684\u8d60\u54c1\u521d\u59cb\u60c5\u51b5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((lastSubtotal.compareTo(bigDecimal) == 0 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u6b65\u8fdb\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u4e24\u6b21\u6b65\u8fdb\u7684\u5c0f\u8ba1\u4ef7\u683c\u521d\u59cb\u60c5\u51b5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((lastSurplusTotalAmount.compareTo(bigDecimal3) == 0 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u6b65\u8fdb\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u4e24\u6b21\u6b65\u8fdb\u7684\u672a\u4f18\u60e0\u91d1\u989d\u521d\u59cb\u60c5\u51b5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((lastSurplusTotalNumber.compareTo(newPreSurplusTotalNumber) == 0 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u6b65\u8fdb\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u4e24\u6b21\u6b65\u8fdb\u7684\u672a\u4f18\u60e0\u6570\u91cf\u521d\u59cb\u60c5\u51b5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        newPolicyStepResult.setInitNumbers(lastPolicyStepResult.getInitNumbers());
        newPolicyStepResult.setInitSubtotal(lastPolicyStepResult.getInitSubtotal());
        this.policyStepResults.push(newPolicyStepResult);
    }

    private boolean validateGiftMatch(List<GiftResultInfo> lastGiftResultInfos, List<GiftResultInfo> newPreGiftResultInfos, List<GiftResultInfo> newLastGiftResultInfos) {
        if (CollectionUtils.isEmpty(lastGiftResultInfos) && CollectionUtils.isEmpty(newPreGiftResultInfos)) {
            return true;
        }
        if (!CollectionUtils.isEmpty(lastGiftResultInfos) && !CollectionUtils.isEmpty(newPreGiftResultInfos) && lastGiftResultInfos.size() == newPreGiftResultInfos.size()) {
            return true;
        }
        if (CollectionUtils.isEmpty(newLastGiftResultInfos)) {
            newLastGiftResultInfos = Lists.newArrayList();
        }
        if (CollectionUtils.isEmpty(newPreGiftResultInfos)) {
            newPreGiftResultInfos = Lists.newArrayList();
        }
        Map<String, GiftResultInfo> newLastGiftResultInfoMappings = newLastGiftResultInfos.stream().collect(Collectors.toMap(GiftResultInfo::getProductCode, item -> item));
        Map<String, GiftResultInfo> newPreGiftResultInfoMappings = newPreGiftResultInfos.stream().collect(Collectors.toMap(GiftResultInfo::getProductCode, item -> item));
        Set<String> newLastGiftResultInfoCodes = newLastGiftResultInfoMappings.keySet();
        Set<String> newPreGiftResultInfoCodes = newPreGiftResultInfoMappings.keySet();
        Sets.SetView intersectionGiftProductCodes = Sets.intersection(newPreGiftResultInfoCodes, newLastGiftResultInfoCodes);
        if (!CollectionUtils.isEmpty((Collection)intersectionGiftProductCodes) && intersectionGiftProductCodes.size() == newPreGiftResultInfoCodes.size()) {
            return true;
        }
        return newLastGiftResultInfoCodes.size() == newPreGiftResultInfoCodes.size();
    }

    public ProductPolicyStepResult findLastProductStepResultByProductCode(String productCode) {
        if (StringUtils.isBlank((CharSequence)productCode)) {
            return null;
        }
        Deque<ProductPolicyStepResult> productPolicyStepResults = this.productPolicyStepResultMapping.get(productCode);
        if (CollectionUtils.isEmpty(productPolicyStepResults)) {
            return null;
        }
        return productPolicyStepResults.peek();
    }

    public PolicyStepResult findLastStepResult() {
        return this.policyStepResults.peek();
    }

    public Deque<ProductPolicyStepResult> findPolicyStepResultsByProductCode(String productCode) {
        if (StringUtils.isBlank((CharSequence)productCode)) {
            return null;
        }
        Deque<ProductPolicyStepResult> productPolicyStepResults = this.productPolicyStepResultMapping.get(productCode);
        return productPolicyStepResults;
    }

    public Set<String> findProductCodesByPolicyCode(String policyCode) {
        if (StringUtils.isBlank((CharSequence)policyCode)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.excludedPolicyMapping.get(policyCode))) {
            return null;
        }
        LinkedHashSet productCodes = Sets.newLinkedHashSet();
        for (Map.Entry<String, Set<String>> matchedProductInfoMappingItem : this.matchedProductInfoMapping.entrySet()) {
            String productCode = matchedProductInfoMappingItem.getKey();
            Set<String> salepolicyCodes = matchedProductInfoMappingItem.getValue();
            if (!salepolicyCodes.contains(policyCode)) continue;
            productCodes.add(productCode);
        }
        return productCodes;
    }

    public Set<String> findPolicyCodesByProductCode(String productCode) {
        if (StringUtils.isBlank((CharSequence)productCode)) {
            return null;
        }
        return this.matchedProductInfoMapping.get(productCode);
    }

    public Map<String, String> findExcludedPolicyByProductCode(String productCode) {
        Set<String> matchedPolicyCodes = this.matchedProductInfoMapping.get(productCode);
        if (CollectionUtils.isEmpty(matchedPolicyCodes)) {
            return Maps.newLinkedHashMap();
        }
        Deque<ProductPolicyStepResult> productPolicyStepResults = this.productPolicyStepResultMapping.get(productCode);
        Set<Object> productStepPolicyCodes = Sets.newLinkedHashSet();
        if (!CollectionUtils.isEmpty(productPolicyStepResults)) {
            productStepPolicyCodes = productPolicyStepResults.stream().filter(item -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item.getSalePolicyCode()})).map(ProductPolicyStepResult::getSalePolicyCode).collect(Collectors.toSet());
        }
        Sets.SetView differences = Sets.difference(matchedPolicyCodes, (Set)productStepPolicyCodes);
        LinkedHashMap excludedPolicyByProductCodeMapping = Maps.newLinkedHashMap();
        if (CollectionUtils.isEmpty((Collection)differences)) {
            return excludedPolicyByProductCodeMapping;
        }
        for (String difference : differences) {
            String errorMsg = this.excludedPolicyMapping.get(difference);
            if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
            excludedPolicyByProductCodeMapping.put(difference, errorMsg);
        }
        return excludedPolicyByProductCodeMapping;
    }

    public DefaultPolicyExecuteContext streamlining() {
        DefaultPolicyExecuteContext clonePolicyExecuteContext = (DefaultPolicyExecuteContext)ObjectUtils.clone((Object)this);
        Set<SalePolicyVo> initSalePolicys = clonePolicyExecuteContext.getInitSalePolicys();
        if (!CollectionUtils.isEmpty(initSalePolicys)) {
            for (SalePolicyVo cloneSalePolicys : initSalePolicys) {
                cloneSalePolicys.setCustomerScopeMapping(null);
                cloneSalePolicys.setSalePolicyExecutorInfos(null);
                cloneSalePolicys.setSalePolicyLimitInfos(null);
                cloneSalePolicys.setSalePolicyProductInfos(null);
                cloneSalePolicys.setSalePolicyProductThreshold(null);
            }
        }
        return clonePolicyExecuteContext;
    }

    public Object clone() throws CloneNotSupportedException {
        byte[] contextBytes = null;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(byteStream);){
            out.writeObject(this);
            contextBytes = byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        DefaultPolicyExecuteContext clonePolicyExecuteContext = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(contextBytes));){
            clonePolicyExecuteContext = (DefaultPolicyExecuteContext)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return clonePolicyExecuteContext;
    }

    public BigDecimal findEnjoyedTotalAmount(String salePolicyCode) {
        BigDecimal enjoyedTotalAmount = BigDecimal.ZERO;
        Iterator<PolicyStepResult> policyStepResultIterator = this.policyStepResults.descendingIterator();
        while (policyStepResultIterator.hasNext()) {
            PolicyStepResult policyStepResult = policyStepResultIterator.next();
            String currentSalePolicyCode = policyStepResult.getSalePolicyCode();
            if (!StringUtils.equals((CharSequence)currentSalePolicyCode, (CharSequence)salePolicyCode)) continue;
            BigDecimal preSubtotal = policyStepResult.getPreSubtotal();
            BigDecimal lastSubtotal = policyStepResult.getLastSubtotal();
            enjoyedTotalAmount = enjoyedTotalAmount.add(preSubtotal.subtract(lastSubtotal));
        }
        return enjoyedTotalAmount;
    }

    public Integer findEnjoyedTotalNumber(String salePolicyCode) {
        Integer enjoyedTotalNumber = 0;
        Iterator<PolicyStepResult> policyStepResultIterator = this.policyStepResults.descendingIterator();
        while (policyStepResultIterator.hasNext()) {
            PolicyStepResult policyStepResult = policyStepResultIterator.next();
            String currentSalePolicyCode = policyStepResult.getSalePolicyCode();
            if (!StringUtils.equals((CharSequence)currentSalePolicyCode, (CharSequence)salePolicyCode)) continue;
            Integer preSurplusTotalNumber = policyStepResult.getPreSurplusTotalNumber();
            preSurplusTotalNumber = preSurplusTotalNumber == null ? 0 : preSurplusTotalNumber;
            Integer lastSurplusTotalNumber = policyStepResult.getLastSurplusTotalNumber();
            lastSurplusTotalNumber = lastSurplusTotalNumber == null ? 0 : lastSurplusTotalNumber;
            enjoyedTotalNumber = enjoyedTotalNumber + (preSurplusTotalNumber - lastSurplusTotalNumber);
        }
        return enjoyedTotalNumber;
    }

    public BigDecimal findGiftEnjoyedTotalAmount(String salePolicyCode) {
        BigDecimal enjoyedTotalAmount = BigDecimal.ZERO;
        Iterator<PolicyStepResult> policyStepResultIterator = this.policyStepResults.descendingIterator();
        while (policyStepResultIterator.hasNext()) {
            PolicyStepResult policyStepResult = policyStepResultIterator.next();
            String currentSalePolicyCode = policyStepResult.getSalePolicyCode();
            if (!StringUtils.equals((CharSequence)currentSalePolicyCode, (CharSequence)salePolicyCode)) continue;
            BigDecimal preEnjoyedTotalAmount = policyStepResult.getPreGiftEnjoyedTotalAmount();
            preEnjoyedTotalAmount = preEnjoyedTotalAmount == null ? BigDecimal.ZERO : preEnjoyedTotalAmount;
            BigDecimal lastEnjoyedTotalAmount = policyStepResult.getLastGiftEnjoyedTotalAmount();
            lastEnjoyedTotalAmount = lastEnjoyedTotalAmount == null ? BigDecimal.ZERO : lastEnjoyedTotalAmount;
            enjoyedTotalAmount = enjoyedTotalAmount.add(lastEnjoyedTotalAmount.subtract(preEnjoyedTotalAmount));
        }
        return enjoyedTotalAmount;
    }

    public Integer findGiftEnjoyedTotalNumber(String salePolicyCode) {
        Integer enjoyedTotalNumber = 0;
        Iterator<PolicyStepResult> policyStepResultIterator = this.policyStepResults.descendingIterator();
        while (policyStepResultIterator.hasNext()) {
            PolicyStepResult policyStepResult = policyStepResultIterator.next();
            String currentSalePolicyCode = policyStepResult.getSalePolicyCode();
            if (!StringUtils.equals((CharSequence)currentSalePolicyCode, (CharSequence)salePolicyCode)) continue;
            Integer preEnjoyedTotalNumber = policyStepResult.getPreGiftEnjoyedTotalNumber();
            preEnjoyedTotalNumber = preEnjoyedTotalNumber == null ? 0 : preEnjoyedTotalNumber;
            Integer lastEnjoyedTotalNumber = policyStepResult.getLastGiftEnjoyedTotalNumber();
            lastEnjoyedTotalNumber = lastEnjoyedTotalNumber == null ? 0 : lastEnjoyedTotalNumber;
            enjoyedTotalNumber = enjoyedTotalNumber + (lastEnjoyedTotalNumber - preEnjoyedTotalNumber);
        }
        return enjoyedTotalNumber;
    }

    public Set<SalePolicyConProduct> getInitPolicyProducts() {
        return this.initPolicyProducts;
    }

    public Set<SalePolicyVo> getInitSalePolicys() {
        return this.initSalePolicys;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public boolean isKneading() {
        return this.kneading;
    }

    public boolean isFormal() {
        return this.formal;
    }

    public String getRelevanceCode() {
        return this.relevanceCode;
    }

    public BigDecimal getTotalDiscountAmount() {
        return this.totalDiscountAmount;
    }

    public List<GiftResultInfo> getTotalGiftResultInfos() {
        return this.totalGiftResultInfos;
    }

    public BigDecimal getInitTotalAmount() {
        return this.initTotalAmount;
    }

    public Integer getInitTotalNumber() {
        return this.initTotalNumber;
    }

    public Map<String, Set<String>> getMatchedProductInfoMapping() {
        return this.matchedProductInfoMapping;
    }

    public Map<String, Deque<ProductPolicyStepResult>> getProductPolicyStepResultMapping() {
        return this.productPolicyStepResultMapping;
    }

    public Map<String, String> getExcludedPolicyMapping() {
        return this.excludedPolicyMapping;
    }

    public Set<String> getMatchedPolicyInfos() {
        return this.matchedPolicyInfos;
    }

    public Deque<PolicyStepResult> getPolicyStepResults() {
        return this.policyStepResults;
    }
}

