/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8be5\u8def\u5f84\u4e0b\u7684http restful\u5730\u5740\u7528\u6765\u67e5\u8be2\u5f53\u524d\u7cfb\u7edf\u5df2\u7ecf\u652f\u6301\u7684\u5728\u4f18\u60e0\u653f\u7b56\u7ba1\u7406\u4e2d\uff0c\u53ef\u652f\u6301\u3001\u53ef\u9009\u5b9a\u7684\u9650\u91cf\u653f\u7b56\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/salepolicies/limitstrategies"})
public class LimitStrategyController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LimitStrategyController.class);
    @Autowired(required=false)
    private Set<SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>> salePolicyLimitStrategies;

    @ApiOperation(value="")
    @GetMapping(value={"/findByLimitStrategyCodes"})
    public Result<?> findByLimitStrategyCodes(@RequestParam(value="limitStrategyCode") @ApiParam(name="limitStrategyCode", required=true, value="\u6307\u5b9a\u7684\u9650\u91cf\u653f\u7b56\u7684\u4e1a\u52a1\u7f16\u53f7\uff08\u53ef\u4ee5\u4f20\u5165\u4e00\u4e2a\u6216\u8005\u591a\u4e2a\uff09") String[] limitStrategyCodes) {
        try {
            JSONArray resutls = new JSONArray();
            for (SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo> salePolicyLimitStrategy : this.salePolicyLimitStrategies) {
                String limitStrategyCode = salePolicyLimitStrategy.getLimitStrategyCode();
                if (!ArrayUtils.contains((Object[])limitStrategyCodes, (Object)limitStrategyCode)) continue;
                String limitStrategyDesc = salePolicyLimitStrategy.getLimitStrategyDesc();
                String expression = salePolicyLimitStrategy.getExpression();
                JSONObject item = new JSONObject();
                item.put("limitStrategyCode", (Object)limitStrategyCode);
                item.put("limitStrategyDesc", (Object)limitStrategyDesc);
                item.put("expression", (Object)expression);
                resutls.add((Object)item);
            }
            return Result.ok((Object)resutls);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

