/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8be5http\u5c42\u529f\u80fd\u63d0\u4f9b\u7684\u63a5\u53e3\uff0c\u90fd\u4e0e\u4f18\u60e0\u653f\u7b56\u7684\u9636\u68af\u6267\u884c\u65b9\u5f0f\u4fe1\u606f\u6709\u5173"})
@RestController
@RequestMapping(value={"/v1/salepolicies/cyclerulestrategy"})
public class SalePolicyCycleRuleStrategyController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyCycleRuleStrategyController.class);
    @Autowired(required=false)
    private Set<SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>> salePolicyExecuteStrategies;
    @Autowired(required=false)
    private Set<SalePolicyCycleRuleStrategy> salePolicyCycleRuleStrategies;
    @Autowired(required=false)
    private ApplicationContext applicationContext;

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7b56\u7565\u54ea\u4e9b\u4f18\u60e0\u653f\u7b56\u9636\u68af\u5faa\u73af\u7b56\u7565\u53ef\u4ee5\u4f7f\u7528(\u6ce8\u610f\u662f\u53ef\u4ee5\u4f7f\u7528\uff0c\u800c\u4e0d\u662f\u6b63\u5728\u4f7f\u7528)")
    @GetMapping(value={"/findByExecuteStrategyCode"})
    public Result<?> findByExecuteStrategyCode(@RequestParam(value="executeStrategyCode") @ApiParam(name="executeStrategyCode", required=true, value="\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7b56\u7565\u5728\u7cfb\u7edf\u4e2d\u552f\u4e00\u7684\u6ce8\u518c\u7f16\u7801") String executeStrategyCode) {
        try {
            SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> matchedSalePolicyExecuteStrategy = null;
            for (SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy : this.salePolicyExecuteStrategies) {
                if (!StringUtils.equals((CharSequence)salePolicyExecuteStrategy.getExecuteStrategyCode(), (CharSequence)executeStrategyCode)) continue;
                matchedSalePolicyExecuteStrategy = salePolicyExecuteStrategy;
            }
            Validate.notNull(matchedSalePolicyExecuteStrategy, (String)"\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7b56\u7565\u6ce8\u518c\u4fe1\u606f\u5b58\u5728\u8bbe\u5b9a\u95ee\u9898(%s)\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (Object[])new Object[]{executeStrategyCode});
            Collection cycleRuleStrategyClasses = matchedSalePolicyExecuteStrategy.getCycleRuleStrategyClasses();
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)cycleRuleStrategyClasses) ? 1 : 0) != 0, (String)"\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7b56\u7565\u6ce8\u518c\u4fe1\u606f\u5b58\u5728\u8bbe\u5b9a\u95ee\u9898(%s)\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (Object[])new Object[]{executeStrategyCode});
            JSONArray resutls = new JSONArray();
            for (Class cycleRuleStrategyClass : cycleRuleStrategyClasses) {
                SalePolicyCycleRuleStrategy salePolicyCycleRuleStrategy = (SalePolicyCycleRuleStrategy)this.applicationContext.getBean(cycleRuleStrategyClass);
                String cycleRuleCode = salePolicyCycleRuleStrategy.getCycleRuleCode();
                String cycleRuleDesc = salePolicyCycleRuleStrategy.getCycleRuleDesc();
                String cycleRuleExample = matchedSalePolicyExecuteStrategy.getCycleRuleExample(cycleRuleCode);
                JSONObject item = new JSONObject();
                item.put("cycleRuleCode", (Object)cycleRuleCode);
                item.put("cycleRuleDesc", (Object)cycleRuleDesc);
                item.put("cycleRuleExample", (Object)cycleRuleExample);
                resutls.add((Object)item);
            }
            return Result.ok((Object)resutls);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="")
    @GetMapping(value={"/findByCycleRuleCodes"})
    public Result<?> findByCycleRuleCodes(@RequestParam(value="cycleRuleCode") @ApiParam(name="cycleRuleCode", required=true, value="\u6307\u5b9a\u7684\u9636\u68af\u5faa\u73af\u89c4\u5219\u4e1a\u52a1\u7f16\u53f7\uff08\u53ef\u4ee5\u4f20\u5165\u4e00\u4e2a\u6216\u8005\u591a\u4e2a\uff09") String[] cycleRuleCodes) {
        try {
            JSONArray resutls = new JSONArray();
            for (SalePolicyCycleRuleStrategy salePolicyCycleRuleStrategy : this.salePolicyCycleRuleStrategies) {
                String cycleRuleCode = salePolicyCycleRuleStrategy.getCycleRuleCode();
                if (!ArrayUtils.contains((Object[])cycleRuleCodes, (Object)cycleRuleCode)) continue;
                String cycleRuleDesc = salePolicyCycleRuleStrategy.getCycleRuleDesc();
                JSONObject item = new JSONObject();
                item.put("cycleRuleCode", (Object)cycleRuleCode);
                item.put("cycleRuleDesc", (Object)cycleRuleDesc);
            }
            return Result.ok((Object)resutls);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

