/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.enums.ProductSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8be5\u8def\u5f84\u4e0b\u7684http restful\u5730\u5740\u7528\u6765\u67e5\u8be2\u5f53\u524d\u7cfb\u7edf\u5df2\u7ecf\u652f\u6301\u7684\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u6ce8\u518c\u5668\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/salepolicies/templeteregisters"})
public class SalePolicyTempleteRegisterController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyTempleteRegisterController.class);
    @Autowired(required=false)
    private List<SalePolicyTempleteRegister> salePolicyTempleteRegisters;
    @Autowired(required=false)
    private ApplicationContext applicationContext;

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u7cfb\u7edf\u4e2d\u6240\u6709\u5df2\u6ce8\u518c\u7684\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u4fe1\u606f")
    @GetMapping(value={"/findAll"})
    public Result<?> findAll() {
        try {
            JSONArray resutls = new JSONArray();
            for (SalePolicyTempleteRegister salePolicyTempleteRegister : this.salePolicyTempleteRegisters) {
                String type = salePolicyTempleteRegister.getType();
                String typeDesc = salePolicyTempleteRegister.getTypeDesc();
                Boolean supportProduct = salePolicyTempleteRegister.supportProduct();
                JSONObject item = new JSONObject();
                item.put("type", (Object)type);
                item.put("typeDesc", (Object)typeDesc);
                item.put("supportProduct", (Object)supportProduct);
                JSONArray productSelectionMethodJson = this.findProductSelectionMethods(salePolicyTempleteRegister);
                item.put("productSelectionMethods", (Object)productSelectionMethodJson);
                JSONArray characteristicStratiesJson = this.findCharacteristicStraties(salePolicyTempleteRegister);
                item.put("characteristicStraties", (Object)characteristicStratiesJson);
                JSONArray customerScopeStratiesJson = this.findCustomerScopeStraties(salePolicyTempleteRegister);
                item.put("customerScopeStraties", (Object)customerScopeStratiesJson);
                JSONArray limitStratiesJson = this.findLimitStraties(salePolicyTempleteRegister);
                item.put("limitStraties", (Object)limitStratiesJson);
                JSONArray executeStratiesJson = this.findExecuteStraties(salePolicyTempleteRegister);
                item.put("executeStraties", (Object)executeStratiesJson);
                resutls.add((Object)item);
            }
            return Result.ok((Object)resutls);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u7cfb\u7edf\u4e2d\u67d0\u4e2a\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u4fe1\u606f")
    @GetMapping(value={"/findByType"})
    public Result<?> findByType(@RequestParam(value="type") @ApiParam(name="type", required=true, value="\u4f18\u60e0\u653f\u7b56\u7c7b\u578b") String type) {
        try {
            SalePolicyTempleteRegister matchedSalePolicyTempleteRegister = null;
            for (SalePolicyTempleteRegister salePolicyTempleteRegister : this.salePolicyTempleteRegisters) {
                if (!StringUtils.equals((CharSequence)salePolicyTempleteRegister.getType(), (CharSequence)type)) continue;
                matchedSalePolicyTempleteRegister = salePolicyTempleteRegister;
                break;
            }
            Validate.notNull(matchedSalePolicyTempleteRegister, (String)"\u6ce8\u518c\u4fe1\u606f\u5b58\u5728\u8bbe\u5b9a\u95ee\u9898(%s)\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (Object[])new Object[]{type});
            String typeDesc = matchedSalePolicyTempleteRegister.getTypeDesc();
            Boolean supportProduct = matchedSalePolicyTempleteRegister.supportProduct();
            JSONObject item = new JSONObject();
            item.put("type", (Object)type);
            item.put("typeDesc", (Object)typeDesc);
            item.put("supportProduct", (Object)supportProduct);
            JSONArray productSelectionMethodJson = this.findProductSelectionMethods(matchedSalePolicyTempleteRegister);
            item.put("productSelectionMethods", (Object)productSelectionMethodJson);
            JSONArray characteristicStratiesJson = this.findCharacteristicStraties(matchedSalePolicyTempleteRegister);
            item.put("characteristicStraties", (Object)characteristicStratiesJson);
            JSONArray customerScopeStratiesJson = this.findCustomerScopeStraties(matchedSalePolicyTempleteRegister);
            item.put("customerScopeStraties", (Object)customerScopeStratiesJson);
            JSONArray limitStratiesJson = this.findLimitStraties(matchedSalePolicyTempleteRegister);
            item.put("limitStraties", (Object)limitStratiesJson);
            JSONArray executeStratiesJson = this.findExecuteStraties(matchedSalePolicyTempleteRegister);
            item.put("executeStraties", (Object)executeStratiesJson);
            return Result.ok((Object)item);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    private JSONArray findCharacteristicStraties(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        Collection characteristicStrategyClasses = salePolicyTempleteRegister.getCharacteristicStrategyClasses();
        if (CollectionUtils.isEmpty((Collection)characteristicStrategyClasses)) {
            return new JSONArray();
        }
        JSONArray resutls = new JSONArray();
        for (Class characteristicStrategyClass : characteristicStrategyClasses) {
            CharacteristicStrategy characteristicStrategy = (CharacteristicStrategy)this.applicationContext.getBean(characteristicStrategyClass);
            JSONObject item = new JSONObject();
            String characteristicCode = characteristicStrategy.characteristicCode();
            String characteristicName = characteristicStrategy.characteristicName();
            String expression = characteristicStrategy.getExpression();
            item.put("characteristicCode", (Object)characteristicCode);
            item.put("characteristicName", (Object)characteristicName);
            item.put("expression", (Object)expression);
            resutls.add((Object)item);
        }
        return resutls;
    }

    private JSONArray findProductSelectionMethods(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        ProductSelectionMethod[] productSelectionMethods = salePolicyTempleteRegister.getProductSelectionMethods();
        if (productSelectionMethods == null || productSelectionMethods.length == 0) {
            return new JSONArray();
        }
        JSONArray resutls = new JSONArray();
        for (ProductSelectionMethod productSelectionMethod : productSelectionMethods) {
            JSONObject itemObject = new JSONObject();
            String code = productSelectionMethod.getCode();
            String desc = productSelectionMethod.getDesc();
            itemObject.put("code", (Object)code);
            itemObject.put("desc", (Object)desc);
            resutls.add((Object)itemObject);
        }
        return resutls;
    }

    private JSONArray findCustomerScopeStraties(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        Collection customerScopeStrategyClasses = salePolicyTempleteRegister.getCustomerScopeStrategyClasses();
        if (CollectionUtils.isEmpty((Collection)customerScopeStrategyClasses)) {
            return new JSONArray();
        }
        JSONArray resutls = new JSONArray();
        for (Class customerScopeStrategyClass : customerScopeStrategyClasses) {
            SalePolicyCustomerScopeStrategy customerScopeStrategy = (SalePolicyCustomerScopeStrategy)this.applicationContext.getBean(customerScopeStrategyClass);
            JSONObject item = new JSONObject();
            String scopeType = customerScopeStrategy.getScopeType();
            String scopeTypeDesc = customerScopeStrategy.getScopeTypeDesc();
            item.put("scopeType", (Object)scopeType);
            item.put("scopeTypeDesc", (Object)scopeTypeDesc);
            resutls.add((Object)item);
        }
        return resutls;
    }

    private JSONArray findLimitStraties(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        Collection bindableLimitStrategyClasses = salePolicyTempleteRegister.getBindableLimitStrategyClasses();
        if (CollectionUtils.isEmpty((Collection)bindableLimitStrategyClasses)) {
            return new JSONArray();
        }
        JSONArray resutls = new JSONArray();
        for (Class bindableLimitStrategyClass : bindableLimitStrategyClasses) {
            SalePolicyLimitStrategy salePolicyLimitStrategy = (SalePolicyLimitStrategy)this.applicationContext.getBean(bindableLimitStrategyClass);
            String limitStrategyCode = salePolicyLimitStrategy.getLimitStrategyCode();
            String limitStrategyDesc = salePolicyLimitStrategy.getLimitStrategyDesc();
            String expression = salePolicyLimitStrategy.getExpression();
            JSONObject item = new JSONObject();
            item.put("limitStrategyCode", (Object)limitStrategyCode);
            item.put("limitStrategyDesc", (Object)limitStrategyDesc);
            item.put("expression", (Object)expression);
            resutls.add((Object)item);
        }
        return resutls;
    }

    private JSONArray findExecuteStraties(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        Collection salePolicyExecuteStrategyClasses = salePolicyTempleteRegister.getExecuteStrategyClasses();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)salePolicyExecuteStrategyClasses) ? 1 : 0) != 0, (String)"\u6ce8\u518c\u4fe1\u606f\u5b58\u5728\u8bbe\u5b9a\u95ee\u9898(%s)\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (Object[])new Object[]{salePolicyTempleteRegister.getType()});
        JSONArray resutls = new JSONArray();
        for (Class salePolicyExecuteStrategyClass : salePolicyExecuteStrategyClasses) {
            SalePolicyExecuteStrategy salePolicyExecuteStrategy = (SalePolicyExecuteStrategy)this.applicationContext.getBean(salePolicyExecuteStrategyClass);
            String executeStrategyCode = salePolicyExecuteStrategy.getExecuteStrategyCode();
            String executeStrategyDesc = salePolicyExecuteStrategy.getExecuteStrategyDesc();
            String expression = salePolicyExecuteStrategy.getExpression();
            JSONObject item = new JSONObject();
            item.put("executeStrategyCode", (Object)executeStrategyCode);
            item.put("executeStrategyDesc", (Object)executeStrategyDesc);
            item.put("expression", (Object)expression);
            resutls.add((Object)item);
        }
        return resutls;
    }
}

