/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.notifier;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyTempleteLogDto;
import com.biz.crm.dms.business.policy.sdk.event.SalePolicyTempleteLogEventListener;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyTempleteVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SalePolicyTempleteLogEventListenerImpl
implements SalePolicyTempleteLogEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onCreate(SalePolicyTempleteLogDto salePolicyTempleteLogDto) {
        this.saveRecord(salePolicyTempleteLogDto, OperationTypeEunm.CREATE);
    }

    public void onUpdate(SalePolicyTempleteLogDto salePolicyTempleteLogDto) {
        this.saveRecord(salePolicyTempleteLogDto, OperationTypeEunm.UPDATE);
    }

    public void OnEnable(SalePolicyTempleteLogDto salePolicyTempleteLogDto) {
        this.saveRecord(salePolicyTempleteLogDto, OperationTypeEunm.UPDATE);
    }

    public void OnDisable(SalePolicyTempleteLogDto salePolicyTempleteLogDto) {
        this.saveRecord(salePolicyTempleteLogDto, OperationTypeEunm.UPDATE);
    }

    public void OnDelete(SalePolicyTempleteLogDto salePolicyTempleteLogDto) {
        this.saveRecord(salePolicyTempleteLogDto, OperationTypeEunm.DELETE);
    }

    private void saveRecord(SalePolicyTempleteLogDto salePolicyTempleteLogDto, OperationTypeEunm operationTypeEunm) {
        SalePolicyTempleteVo original = salePolicyTempleteLogDto.getOriginal();
        SalePolicyTempleteVo newest = salePolicyTempleteLogDto.getNewest();
        String onlyKey = null;
        if (original != null) {
            onlyKey = original.getId();
        } else if (newest != null) {
            onlyKey = newest.getId();
        }
        if (onlyKey == null) {
            return;
        }
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(operationTypeEunm.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}

