/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.dms.business.policy.local.entity.SalePolicy;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyMapper;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyPageDto;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class SalePolicyRepository
extends ServiceImpl<SalePolicyMapper, SalePolicy> {
    public SalePolicy findBySalePolicyCodeAndTenantCode(String salePolicyCode, String tenantCode) {
        SalePolicy salePolicy = (SalePolicy)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(SalePolicy::getSalePolicyCode, (Object)salePolicyCode)).one());
        return salePolicy;
    }

    public SalePolicy findBySalePolicyCodeAndTenantCodeWithoutId(String salePolicyCode, String tenantCode, String id) {
        SalePolicy salePolicy = (SalePolicy)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(SalePolicy::getSalePolicyCode, (Object)salePolicyCode)).notIn(UuidEntity::getId, new Object[]{id})).one());
        return salePolicy;
    }

    public SalePolicy findBySalePolicyId(String id) {
        SalePolicy salePolicy = (SalePolicy)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).one());
        return salePolicy;
    }

    public List<SalePolicy> findByTempleteCodeAndTenantCode(String templeteCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SalePolicy::getTempleteCode, (Object)templeteCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<SalePolicy> findByTenantCode(String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).orderByDesc(SalePolicy::getValidStartTime)).list();
    }

    public Page<SalePolicy> findByConditions(Pageable pageable, SalePolicyPageDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((SalePolicyMapper)this.baseMapper).findByConditions((Page<SalePolicy>)page, dto);
    }

    public void deleteByIds(Set<String> ids) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.in(UuidEntity::getId, ids);
        ((SalePolicyMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
    }
}

