/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.service.task.SalePolicyCustomerScopeMatchedTask;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyMatchedStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalePolicyMatchedStrategyImpl
implements SalePolicyMatchedStrategy {
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    @Qualifier(value="policyLoadingExecutor")
    private ThreadPoolExecutor policyLoadingExecutor;
    private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyMatchedStrategyImpl.class);

    public Set<SalePolicyVo> match(Set<SalePolicyVo> currentSalePolices, String tenantCode, boolean processing, String customerCode, String relevanceCode) {
        Date now = new Date();
        boolean isProcessing = false;
        if (CollectionUtils.isEmpty(currentSalePolices)) {
            return null;
        }
        LinkedHashMap futureResultMapping = Maps.newLinkedHashMap();
        for (SalePolicyVo currentSalePolicy : currentSalePolices) {
            if (now.after(currentSalePolicy.getValidStartTime()) && now.before(currentSalePolicy.getValidEndTime())) {
                isProcessing = true;
            }
            if (isProcessing != processing) continue;
            SalePolicyCustomerScopeMatchedTask task = (SalePolicyCustomerScopeMatchedTask)this.applicationContext.getBean(SalePolicyCustomerScopeMatchedTask.class, new Object[]{currentSalePolicy, tenantCode, customerCode});
            Future<Boolean> future = this.policyLoadingExecutor.submit(task);
            futureResultMapping.put(currentSalePolicy, future);
        }
        LinkedHashSet results = Sets.newLinkedHashSet();
        for (Map.Entry futureEntry : futureResultMapping.entrySet()) {
            try {
                SalePolicyVo currentSalePolicy = (SalePolicyVo)futureEntry.getKey();
                Future currentFutureValue = (Future)futureEntry.getValue();
                Boolean currentFuture = (Boolean)currentFutureValue.get();
                if (currentFuture == null || !currentFuture.booleanValue()) continue;
                results.add(currentSalePolicy);
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return results;
    }

    public Set<SalePolicyVo> match(Set<SalePolicyVo> currentSalePolices, String tenantCode, boolean processing, String customerCode, String relevanceCode, String ... productCodes) {
        Set<SalePolicyVo> salePolicys = this.match(currentSalePolices, tenantCode, processing, customerCode, relevanceCode);
        if (CollectionUtils.isEmpty(salePolicys)) {
            return null;
        }
        LinkedHashSet results = Sets.newLinkedHashSet();
        block0: for (SalePolicyVo currentSalePolicy : salePolicys) {
            if (currentSalePolicy.getWholePolicy().booleanValue()) {
                results.add(currentSalePolicy);
                continue;
            }
            Set salePolicyProductInfos = currentSalePolicy.getSalePolicyProductInfos();
            if (CollectionUtils.isEmpty((Collection)salePolicyProductInfos)) continue;
            for (AbstractSalePolicyProductInfo salePolicyProductInfo : salePolicyProductInfos) {
                if (!StringUtils.containsAny((CharSequence)salePolicyProductInfo.getProductCode(), (CharSequence[])productCodes)) continue;
                results.add(currentSalePolicy);
                continue block0;
            }
        }
        return results;
    }
}

