/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecord;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordExcludePolicy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordGift;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordProduct;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordProductSelectedPolicy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordStepPolicy;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRecordExcludePolicyRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRecordGiftRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRecordProductRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRecordProductSelectedPolicyRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRecordRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRecordStepPolicyRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyRecordService;
import com.biz.crm.dms.business.policy.sdk.context.GiftResultInfo;
import com.biz.crm.dms.business.policy.sdk.context.PolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.ProductPolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.context.StepType;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePolicyRecordServiceImpl
implements SalePolicyRecordService {
    @Autowired(required=false)
    private SalePolicyRecordRepository salePolicyRecordRepository;
    @Autowired(required=false)
    private SalePolicyRecordGiftRepository salePolicyRecordGiftRepository;
    @Autowired(required=false)
    private SalePolicyRecordProductRepository salePolicyRecordProductRepository;
    @Autowired(required=false)
    private SalePolicyRecordStepPolicyRepository salePolicyRecordStepPolicyRepository;
    @Autowired(required=false)
    private SalePolicyRecordExcludePolicyRepository salePolicyRecordExcludePolicyRepository;
    @Autowired(required=false)
    private SalePolicyRecordProductSelectedPolicyRepository salePolicyRecordProductSelectedPolicyRepository;

    @Override
    public void create(String billCode, DefaultPolicyExecuteContext executeContext) {
        Validate.notBlank((CharSequence)billCode, (String)"\u521b\u5efa\u4f18\u60e0\u6d41\u6c34\u660e\u7ec6\u65f6\uff0c\u53d1\u73b0\u672a\u4f20\u5165\u5355\u636e\u4fe1\u606f", (Object[])new Object[0]);
        String tenantCode = executeContext.getTenantCode();
        Validate.notBlank((CharSequence)tenantCode, (String)"\u521b\u5efa\u4f18\u60e0\u6d41\u6c34\u660e\u7ec6\u65f6\uff0c\u672a\u53d1\u73b0\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7684\u79df\u6237\u4fe1\u606f", (Object[])new Object[0]);
        String customerCode = executeContext.getCustomerCode();
        Validate.notBlank((CharSequence)customerCode, (String)"\u521b\u5efa\u4f18\u60e0\u6d41\u6c34\u660e\u7ec6\u65f6\uff0c\u672a\u53d1\u73b0\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7684\u5ba2\u6237\u4fe1\u606f", (Object[])new Object[0]);
        Set<SalePolicyConProduct> initPolicyProducts = executeContext.getInitPolicyProducts();
        Validate.isTrue((!CollectionUtils.isEmpty(initPolicyProducts) ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u6d41\u6c34\u660e\u7ec6\u65f6\uff0c\u672a\u53d1\u73b0\u4f18\u60e0\u6267\u884c\u4e0a\u4e0b\u6587\u7684\u539f\u59cb\u5546\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        long blankCount = initPolicyProducts.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getProductCode())).count();
        Validate.isTrue((blankCount == 0L ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u6d41\u6c34\u660e\u7ec6\u65f6\uff0c\u53d1\u73b0\u6709\u5546\u54c1\u7f16\u7801\u9519\u8bef\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<SalePolicyVo> initSalePolicys = executeContext.getInitSalePolicys();
        Validate.isTrue((!CollectionUtils.isEmpty(initSalePolicys) ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u6d41\u6c34\u660e\u7ec6\u65f6\uff0c\u672a\u53d1\u73b0\u4f18\u60e0\u6267\u884c\u4e0a\u4e0b\u6587\u7684\u539f\u59cb\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        blankCount = initSalePolicys.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getSalePolicyCode())).count();
        Validate.isTrue((blankCount == 0L ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u6d41\u6c34\u660e\u7ec6\u65f6\uff0c\u53d1\u73b0\u6709\u4f18\u60e0\u653f\u7b56\u7f16\u7801\u9519\u8bef\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyRecord salePolicyRecord = new SalePolicyRecord();
        salePolicyRecord.setBillCode(billCode);
        salePolicyRecord.setTenantCode(tenantCode);
        salePolicyRecord.setCustomerCode(customerCode);
        String productCodes = StringUtils.join(initPolicyProducts.stream().map(SalePolicyConProduct::getProductCode).iterator(), (String)",");
        salePolicyRecord.setProductCodes(productCodes);
        String salePolicyCodes = StringUtils.join(initSalePolicys.stream().map(SalePolicyVo::getSalePolicyCode).iterator(), (String)",");
        salePolicyRecord.setSalePolicyCodes(salePolicyCodes);
        BigDecimal initTotalAmount = executeContext.getInitTotalAmount();
        salePolicyRecord.setInitTotalAmount(initTotalAmount);
        Integer initTotalNumber = executeContext.getInitTotalNumber();
        salePolicyRecord.setInitTotalNumber(initTotalNumber);
        boolean kneading = executeContext.isKneading();
        salePolicyRecord.setKneading(kneading);
        this.salePolicyRecordRepository.save((Object)salePolicyRecord);
        for (SalePolicyConProduct salePolicyConProduct : initPolicyProducts) {
            Object[] objectArray = salePolicyConProduct.getSelectedPolicyCodes();
            if (objectArray == null || objectArray.length == 0) continue;
            SalePolicyRecordProductSelectedPolicy salePolicyRecordProductSelectedPolicy = new SalePolicyRecordProductSelectedPolicy();
            salePolicyRecordProductSelectedPolicy.setProductCode(salePolicyConProduct.getProductCode());
            salePolicyRecordProductSelectedPolicy.setRecordId(salePolicyRecord.getId());
            salePolicyRecordProductSelectedPolicy.setSelectedPolicyCodes(StringUtils.join((Object[])objectArray, (String)","));
            this.salePolicyRecordProductSelectedPolicyRepository.save((Object)salePolicyRecordProductSelectedPolicy);
        }
        Map<String, String> excludedPolicyMapping = executeContext.getExcludedPolicyMapping();
        if (!CollectionUtils.isEmpty(excludedPolicyMapping)) {
            for (Map.Entry<String, String> entry : excludedPolicyMapping.entrySet()) {
                String salePolicyCode = entry.getKey();
                String excludedMsg = entry.getValue();
                SalePolicyRecordExcludePolicy salePolicyRecordExcludePolicy = new SalePolicyRecordExcludePolicy();
                salePolicyRecordExcludePolicy.setRecordId(salePolicyRecord.getId());
                salePolicyRecordExcludePolicy.setExcludedMsg(excludedMsg);
                salePolicyRecordExcludePolicy.setPolicyCode(salePolicyCode);
                this.salePolicyRecordExcludePolicyRepository.save((Object)salePolicyRecordExcludePolicy);
            }
        }
        Deque<PolicyStepResult> deque = executeContext.getPolicyStepResults();
        Iterator<PolicyStepResult> iterator = deque.descendingIterator();
        int sortedIndex = 0;
        while (iterator.hasNext()) {
            PolicyStepResult policyStepResultItem = iterator.next();
            SalePolicyRecordStepPolicy salePolicyRecordStepPolicy = new SalePolicyRecordStepPolicy();
            salePolicyRecordStepPolicy.setRecordId(salePolicyRecord.getId());
            salePolicyRecordStepPolicy.setSalePolicyCode(StringUtils.isBlank((CharSequence)policyStepResultItem.getSalePolicyCode()) ? "" : policyStepResultItem.getSalePolicyCode());
            salePolicyRecordStepPolicy.setExecuteCode(StringUtils.isBlank((CharSequence)policyStepResultItem.getExecutorCode()) ? "" : policyStepResultItem.getExecutorCode());
            salePolicyRecordStepPolicy.setSorted(sortedIndex++);
            salePolicyRecordStepPolicy.setStepType(policyStepResultItem.getStepType().toString());
            this.salePolicyRecordStepPolicyRepository.save((Object)salePolicyRecordStepPolicy);
        }
        Map<String, Deque<ProductPolicyStepResult>> productPolicyStepResults = executeContext.getProductPolicyStepResultMapping();
        Map<String, SalePolicyConProduct> initPolicyProductMappings = initPolicyProducts.stream().collect(Collectors.toMap(SalePolicyConProduct::getProductCode, item -> item));
        if (CollectionUtils.isEmpty(productPolicyStepResults)) {
            return;
        }
        Set<Map.Entry<String, Deque<ProductPolicyStepResult>>> productPolicyStepResultItems = productPolicyStepResults.entrySet();
        for (Map.Entry<String, Deque<ProductPolicyStepResult>> productPolicyStepResultItem : productPolicyStepResultItems) {
            String productCode = productPolicyStepResultItem.getKey();
            SalePolicyConProduct defaultPolicyConProduct = initPolicyProductMappings.get(productCode);
            Deque<ProductPolicyStepResult> productPolicyStepDeque = productPolicyStepResultItem.getValue();
            Iterator<ProductPolicyStepResult> descendingIterator = productPolicyStepDeque.descendingIterator();
            for (int sorted = 0; sorted < productPolicyStepDeque.size(); ++sorted) {
                ProductPolicyStepResult productPolicyStepResult = descendingIterator.next();
                StepType stepType = productPolicyStepResult.getStepType();
                String salePolicyCode = productPolicyStepResult.getSalePolicyCode();
                SalePolicyRecordProduct salePolicyRecordProduct = new SalePolicyRecordProduct();
                salePolicyRecordProduct.setRecordId(salePolicyRecord.getId());
                salePolicyRecordProduct.setBillItemCode(defaultPolicyConProduct.getBillItemCode());
                salePolicyRecordProduct.setSalePolicyCode(StringUtils.isBlank((CharSequence)salePolicyCode) ? "" : salePolicyCode);
                salePolicyRecordProduct.setExecuteCode(StringUtils.isBlank((CharSequence)productPolicyStepResult.getExecuteCode()) ? "" : productPolicyStepResult.getExecuteCode());
                salePolicyRecordProduct.setProductCode(defaultPolicyConProduct.getProductCode());
                salePolicyRecordProduct.setProductName(defaultPolicyConProduct.getProductName());
                salePolicyRecordProduct.setSorted(sorted);
                salePolicyRecordProduct.setStepType(stepType.toString());
                BigDecimal initPrices = productPolicyStepResult.getInitPrices();
                Integer initNumbers = productPolicyStepResult.getInitNumbers();
                BigDecimal initSubtotal = productPolicyStepResult.getInitSubtotal();
                salePolicyRecordProduct.setInitPrices(initPrices);
                salePolicyRecordProduct.setInitNumbers(initNumbers);
                salePolicyRecordProduct.setInitSubtotal(initSubtotal);
                BigDecimal lastPrices = productPolicyStepResult.getLastPrices();
                BigDecimal lastSubtotal = productPolicyStepResult.getLastSubtotal();
                BigDecimal lastSurplusTotalAmount = productPolicyStepResult.getLastSurplusTotalAmount();
                Integer lastSurplusTotalNumber = productPolicyStepResult.getLastSurplusTotalNumber();
                List lastGiftResultInfos = productPolicyStepResult.getLastGifts();
                salePolicyRecordProduct.setLastPrices(lastPrices);
                salePolicyRecordProduct.setLastSubtotal(lastSubtotal);
                salePolicyRecordProduct.setLastSurplusTotalAmount(lastSurplusTotalAmount);
                salePolicyRecordProduct.setLastSurplusTotalNumber(lastSurplusTotalNumber);
                BigDecimal preSubtotal = productPolicyStepResult.getPreSubtotal();
                BigDecimal diffLastSubtotal = preSubtotal.subtract(lastSubtotal);
                salePolicyRecordProduct.setDiffLastSubtotal(diffLastSubtotal);
                Integer preSurplusTotalNumber = productPolicyStepResult.getPreSurplusTotalNumber();
                salePolicyRecordProduct.setDiffSurplusTotalNumber(preSurplusTotalNumber - lastSurplusTotalNumber);
                BigDecimal preSurplusTotalAmount = productPolicyStepResult.getPreSurplusTotalAmount();
                salePolicyRecordProduct.setDiffSurplusTotalAmount(preSurplusTotalAmount.subtract(lastSurplusTotalAmount));
                Integer preGiftEnjoyedTotalNumber = productPolicyStepResult.getPreGiftEnjoyedTotalNumber() == null ? 0 : productPolicyStepResult.getPreGiftEnjoyedTotalNumber();
                Integer lastGiftEnjoyedTotalNumber = productPolicyStepResult.getLastGiftEnjoyedTotalNumber() == null ? 0 : productPolicyStepResult.getLastGiftEnjoyedTotalNumber();
                Integer diffGiftEnjoyedTotalNumber = lastGiftEnjoyedTotalNumber - preGiftEnjoyedTotalNumber;
                salePolicyRecordProduct.setLastGiftEnjoyedTotalNumber(lastGiftEnjoyedTotalNumber);
                salePolicyRecordProduct.setDiffGiftEnjoyedTotalNumber(diffGiftEnjoyedTotalNumber);
                BigDecimal preGiftsEnjoyedTotalAmount = productPolicyStepResult.getPreGiftEnjoyedTotalAmount() == null ? BigDecimal.ZERO : productPolicyStepResult.getPreGiftEnjoyedTotalAmount();
                BigDecimal lastGiftsEnjoyedTotalAmount = productPolicyStepResult.getLastGiftEnjoyedTotalAmount() == null ? BigDecimal.ZERO : productPolicyStepResult.getLastGiftEnjoyedTotalAmount();
                BigDecimal diffGiftEnjoyedTotalAmount = lastGiftsEnjoyedTotalAmount.subtract(preGiftsEnjoyedTotalAmount);
                salePolicyRecordProduct.setLastGiftEnjoyedTotalAmount(lastGiftsEnjoyedTotalAmount);
                salePolicyRecordProduct.setDiffGiftEnjoyedTotalAmount(diffGiftEnjoyedTotalAmount);
                this.salePolicyRecordProductRepository.save((Object)salePolicyRecordProduct);
                if (CollectionUtils.isEmpty((Collection)lastGiftResultInfos)) continue;
                for (GiftResultInfo giftResultInfo : lastGiftResultInfos) {
                    String giftProductCode = giftResultInfo.getProductCode();
                    String giftProductName = giftResultInfo.getProductName();
                    Integer giftQuantity = giftResultInfo.getQuantity();
                    BigDecimal giftSubtotalAmount = giftResultInfo.getSubtotalAmount();
                    SalePolicyRecordGift salePolicyRecordGift = new SalePolicyRecordGift();
                    salePolicyRecordGift.setRecordProductId(salePolicyRecordProduct.getId());
                    salePolicyRecordGift.setGiftCode(giftProductCode);
                    salePolicyRecordGift.setGiftName(giftProductName);
                    salePolicyRecordGift.setQuantity(giftQuantity);
                    salePolicyRecordGift.setSubtotalAmount(giftSubtotalAmount);
                    this.salePolicyRecordGiftRepository.save((Object)salePolicyRecordGift);
                }
            }
        }
    }

    @Override
    @Transactional
    public void deleteByBillCode(String billCode, String tenantCode, String customerCode) {
        Validate.notBlank((CharSequence)billCode, (String)"\u5220\u9664/\u56de\u9000\u4f18\u60e0\u653f\u7b56\u6d41\u6c34\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u5355\u636e\u7f16\u53f7!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)"\u5220\u9664/\u56de\u9000\u4f18\u60e0\u653f\u7b56\u6d41\u6c34\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u79df\u6237\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerCode, (String)"\u5220\u9664/\u56de\u9000\u4f18\u60e0\u653f\u7b56\u6d41\u6c34\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u5ba2\u6237\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        SalePolicyRecord salePolicyRecord = this.findByBillCode(billCode, tenantCode, customerCode);
        if (salePolicyRecord == null) {
            return;
        }
        String salePolicyRecordId = salePolicyRecord.getId();
        List<SalePolicyRecordProduct> salePolicyRecordProducts = this.salePolicyRecordProductRepository.findByRecordId(salePolicyRecordId);
        if (!CollectionUtils.isEmpty(salePolicyRecordProducts)) {
            for (SalePolicyRecordProduct salePolicyRecordProduct : salePolicyRecordProducts) {
                this.salePolicyRecordGiftRepository.deleteByRecordProductId(salePolicyRecordProduct.getId());
            }
            this.salePolicyRecordProductRepository.deleteByRecordId(salePolicyRecordId);
        }
        this.salePolicyRecordStepPolicyRepository.deleteByRecordId(salePolicyRecordId);
        this.salePolicyRecordExcludePolicyRepository.deleteByRecordId(salePolicyRecordId);
        this.salePolicyRecordProductSelectedPolicyRepository.deleteByIds(Sets.newHashSet((Object[])new String[]{salePolicyRecordId}));
        this.salePolicyRecordRepository.deleteByIds(Sets.newHashSet((Object[])new String[]{salePolicyRecordId}));
    }

    @Override
    public SalePolicyRecord findByBillCode(String billCode, String tenantCode, String customerCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{billCode, tenantCode, customerCode})) {
            return null;
        }
        return this.salePolicyRecordRepository.findByBillCodeAndTenantCodeAndTenantCode(billCode, customerCode, tenantCode);
    }

    @Override
    public Set<SalePolicyRecord> findByTenantCodeAndSalePolicyCode(String tenantCode, String salePolicyCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, salePolicyCode})) {
            return null;
        }
        return this.salePolicyRecordRepository.findByTenantCodeAndSalePolicyCode(tenantCode, salePolicyCode);
    }

    @Override
    public Set<SalePolicyRecord> findByTenantCodeAndSalePolicyCodeAndCustomerCode(String tenantCode, String salePolicyCode, String customerCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, customerCode, salePolicyCode})) {
            return null;
        }
        return this.salePolicyRecordRepository.findByTenantCodeAndSalePolicyCodeAndCustomerCode(tenantCode, salePolicyCode, customerCode);
    }

    @Override
    public Set<SalePolicyRecord> findByTenantCodeAndSalePolicyCodeAndCustomerCodeAndBillCode(String tenantCode, String salePolicyCode, String customerCode, String billCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, customerCode, billCode, salePolicyCode})) {
            return null;
        }
        return this.salePolicyRecordRepository.findByTenantCodeAndSalePolicyCodeAndCustomerCodeAndBillCode(tenantCode, salePolicyCode, customerCode, billCode);
    }
}

