/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.policy.local.entity.SalePolicy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecord;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyTemplete;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRecordRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyTempleteRepository;
import com.biz.crm.dms.business.policy.local.service.task.SalePolicyCacheLoadingService;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyLogDto;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyPageDto;
import com.biz.crm.dms.business.policy.sdk.event.SalePolicyEventListener;
import com.biz.crm.dms.business.policy.sdk.event.SalePolicyLogEventListener;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.service.SalePolicyVoService;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyMatchedStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractCharacteristicInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePolicyVoServiceImpl
implements SalePolicyVoService {
    @Autowired(required=false)
    private List<SalePolicyTempleteRegister> salePolicyTempleteRegisters;
    @Autowired(required=false)
    private List<SalePolicyEventListener> salePolicyEventListeners;
    @Autowired(required=false)
    private SalePolicyMatchedStrategy salePolicyMatchedStrategy;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private SalePolicyRepository salePolicyRepository;
    @Autowired(required=false)
    private SalePolicyTempleteRepository salePolicyTempleteRepository;
    @Autowired(required=false)
    private SalePolicyRecordRepository salePolicyRecordRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private SalePolicyCacheLoadingService salePolicyCacheLoadingService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyVoServiceImpl.class);
    private static final String SALE_POLICY_GEN_PREFIX = "SALE_POLICY_GEN_PREFIX";

    public String preSave() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode(SALE_POLICY_GEN_PREFIX, prefix, prefix, TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS));
        return prefix;
    }

    @Transactional
    public SalePolicyVo create(JSONObject salePolicyJson) {
        Validate.notNull((Object)salePolicyJson, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff08JSON\u5f62\u5f0f\uff09\u3002", (Object[])new Object[0]);
        SalePolicyVo currentSalePolicyVo = this.convertSalePolicyVo(salePolicyJson, "\u521b\u5efa\u65f6");
        this.createHandle(currentSalePolicyVo);
        String tenantCode = TenantUtils.getTenantCode();
        this.salePolicyCacheLoadingService.notifyCacheRefresh(tenantCode);
        return currentSalePolicyVo;
    }

    @Transactional
    public SalePolicyVo create(SalePolicyVo salePolicy) {
        Validate.notNull((Object)salePolicy, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff08\u5bf9\u8c61\u5f62\u5f0f\uff09\u3002", (Object[])new Object[0]);
        SalePolicyVo currentSalePolicyVo = this.createHandle(salePolicy);
        String tenantCode = TenantUtils.getTenantCode();
        this.salePolicyCacheLoadingService.notifyCacheRefresh(tenantCode);
        return currentSalePolicyVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SalePolicyVo createHandle(SalePolicyVo salePolicy) {
        block7: {
            Validate.notNull((Object)salePolicy, (String)"\u521b\u5efa\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8981\u6dfb\u52a0\u7684\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09\uff0c\u8bf7\u53c2\u89c1\u6587\u6863!!", (Object[])new Object[0]);
            String prefix = salePolicy.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u4f18\u60e0\u653f\u7b56\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode(SALE_POLICY_GEN_PREFIX, prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u4f18\u60e0\u653f\u7b56\u7684\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0\uff0c\u8bf7\u4f7f\u7528preSave\u529f\u80fd\u8fdb\u884c\u6dfb\u52a0!!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode(SALE_POLICY_GEN_PREFIX, prefix, prefix, 1L);
                    break block7;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u6dfb\u52a0!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
        String type = salePolicy.getType();
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notBlank((CharSequence)type, (String)"\u521b\u5efa\u65f6\uff0c\u9519\u8bef\u7684\u4f18\u60e0\u653f\u7b56\u7c7b\u578b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyTempleteRegister matchedSalePolicyTempleteRegister = this.findSalePolicyTempleteRegister(type);
        String templeteCode = salePolicy.getTempleteCode();
        Validate.notBlank((CharSequence)templeteCode, (String)"\u521b\u5efa\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyTemplete existSalePolicyTemplete = this.salePolicyTempleteRepository.findByTempleteCode(templeteCode, tenantCode);
        Validate.notNull((Object)((Object)existSalePolicyTemplete), (String)"\u521b\u5efa\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u4fe1\u606f(%s)\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{templeteCode});
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)existSalePolicyTemplete.getType(), (CharSequence)type), (String)"\u521b\u5efa\u65f6\uff0c\u4f18\u60e0\u653f\u7b56\u8bbe\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u7c7b\u578b\u548c\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u7684\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Boolean supportProduct = matchedSalePolicyTempleteRegister.supportProduct();
        Validate.notNull((Object)supportProduct, (String)"\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u5339\u914d\u7684\u6ce8\u518c\u5668(%s)\uff0c\u5e76\u672a\u6307\u5b9a\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u662f\u9488\u5bf9\u6574\u5355\u7684\u8fd8\u662f\u9488\u5bf9\u5546\u54c1\u7684\uff0c\u8bf7\u68c0\u67e5\u5e76\u5b8c\u5584!!", (Object[])new Object[]{type});
        salePolicy.setWholePolicy(Boolean.valueOf(supportProduct == false));
        salePolicy.setTenantCode(tenantCode);
        salePolicy.setId(null);
        this.saveValidation(salePolicy, false);
        SalePolicy salePolicyEntity = (SalePolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicy, SalePolicy.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.salePolicyRepository.save((Object)salePolicyEntity);
        salePolicy.setId(salePolicyEntity.getId());
        this.handleExtendsInfos(false, matchedSalePolicyTempleteRegister, salePolicy, null, supportProduct);
        if (!CollectionUtils.isEmpty(this.salePolicyEventListeners)) {
            for (SalePolicyEventListener salePolicyEventListener : this.salePolicyEventListeners) {
                salePolicyEventListener.onCreated(salePolicy);
            }
        }
        this.recordLogOnCreate(salePolicy);
        return salePolicy;
    }

    private void recordLogOnCreate(SalePolicyVo salePolicyVo) {
        SalePolicyLogDto logDto = new SalePolicyLogDto();
        logDto.setOriginal(null);
        logDto.setNewest(salePolicyVo);
        SerializableBiConsumer & Serializable onCreate = SalePolicyLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logDto, SalePolicyLogEventListener.class, (SerializableBiConsumer)onCreate);
    }

    private <T extends AbstractSalePolicyThreshold, P extends AbstractSalePolicyProductInfo, R extends AbstractSalePolicyExecutorInfo> void handleExtendsInfos(boolean update, SalePolicyTempleteRegister salePolicyTempleteRegister, SalePolicyVo salePolicy, SalePolicyVo oldSalePolicy, boolean supportProduct) {
        String salePolicyCode = salePolicy.getSalePolicyCode();
        String tenantCode = salePolicy.getTenantCode();
        SalePolicyStickupListener salePolicyStickupListener = salePolicyTempleteRegister.getStickupListener();
        Collection characteristicStrategyClasses = salePolicyTempleteRegister.getCharacteristicStrategyClasses();
        if (!CollectionUtils.isEmpty((Collection)characteristicStrategyClasses)) {
            Set<CharacteristicStrategy<? extends AbstractCharacteristicInfo>> characteristicStraties = this.findAllBindingCharacteristicStrategy(salePolicyTempleteRegister);
            for (CharacteristicStrategy<? extends AbstractCharacteristicInfo> characteristicStrategy : characteristicStraties) {
                characteristicStrategy.onSaveCharacteristicInfo(update, salePolicy, oldSalePolicy);
            }
        }
        AbstractSalePolicyThreshold salePolicyProductThreshold = salePolicy.getSalePolicyProductThreshold();
        Validate.notNull((Object)salePolicyProductThreshold, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u65f6\uff0c\u672a\u53d1\u73b0\u4efb\u4f55\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u4fe1\u606f\uff0c\u5982\u679c\u5f53\u524d\u6dfb\u52a0\u7684\u4f18\u60e0\u653f\u7b56\u6ca1\u6709\u4efb\u4f55\u95e8\u69db\uff0c\u4e5f\u5e94\u8be5\u8bbe\u5b9a\u4e00\u4e2a\u95e8\u69db\u503c\u4e3a0\u7684\u95e8\u69db\uff08\u8bf7\u53c2\u89c1SalePolicyThresholdVo\u6a21\u578b\uff09", (Object[])new Object[0]);
        salePolicyProductThreshold.setSalePolicyCode(salePolicyCode);
        salePolicyStickupListener.onSaveSalePolicyProductThreshold(update, salePolicy, oldSalePolicy, salePolicyProductThreshold);
        Set salePolicyExecutorInfos = salePolicy.getSalePolicyExecutorInfos();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)salePolicyExecutorInfos) ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u65f6\uff0c\u81f3\u5c11\u9700\u8981\u4e00\u7ec4\u4f18\u60e0\u653f\u7b56\u89c4\u5219\u6267\u884c\u8be6\u60c5\uff08executorInfo\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        salePolicyExecutorInfos.stream().forEach(item -> {
            item.setSalePolicyCode(salePolicyCode);
            item.setTenantCode(tenantCode);
        });
        Set<SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>> salePolicyExecuteStrategies = this.findAllBindingExecuteStrategy(salePolicyTempleteRegister);
        for (SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy : salePolicyExecuteStrategies) {
            salePolicyExecuteStrategy.onSaveSalePolicyExecutorInfo(update, salePolicy, oldSalePolicy);
        }
        Set salePolicyProductInfos = salePolicy.getSalePolicyProductInfos();
        if (!supportProduct) {
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)salePolicyProductInfos), (String)"\u7531\u4e8e\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u4e0d\u662f\u9488\u5bf9\u5546\u54c1\u672c\u54c1\u7684\uff0c\u6240\u4ee5\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u4e0d\u80fd\u4f20\u5165\u5546\u54c1\u4fe1\u606f!!", (Object[])new Object[0]);
        } else {
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)salePolicyProductInfos) ? 1 : 0) != 0, (String)"\u7531\u4e8e\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u662f\u9488\u5bf9\u5546\u54c1\u672c\u54c1\u8fdb\u884c\u7684\uff0c\u6240\u4ee5\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u5fc5\u987b\u4f20\u5165\u5546\u54c1\u4fe1\u606f!!", (Object[])new Object[0]);
            salePolicyProductInfos.stream().forEach(item -> {
                item.setSalePolicyCode(salePolicyCode);
                item.setTenantCode(tenantCode);
            });
            salePolicyStickupListener.onSaveSalePolicyProductInfo(update, salePolicy, oldSalePolicy, salePolicyProductInfos);
        }
        Collection bindableLimitStrategyClasses = salePolicyTempleteRegister.getBindableLimitStrategyClasses();
        if (!CollectionUtils.isEmpty((Collection)bindableLimitStrategyClasses)) {
            Set<SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>> salePolicyLimitStrategies = this.findAllBindingLimitStrategy(salePolicyTempleteRegister);
            for (SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo> salePolicyLimitStrategy : salePolicyLimitStrategies) {
                salePolicyLimitStrategy.onSaveSalePolicyLimitInfos(update, salePolicy, oldSalePolicy);
            }
        }
        Set<SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>> currentCustomerScopeStrategies = this.findAllBindCustomerScopeStrategy(salePolicyTempleteRegister);
        for (SalePolicyCustomerScopeStrategy salePolicyCustomerScopeStrategy : currentCustomerScopeStrategies) {
            salePolicyCustomerScopeStrategy.onSaveSalePolicyCustomerInfo(update, salePolicy, oldSalePolicy);
        }
    }

    private void saveValidation(SalePolicyVo salePolicy, boolean update) {
        Boolean effective;
        SalePolicy exsitSalePolicy;
        String salePolicyCode;
        String onTimeValue;
        Date now = new Date();
        String tenantCode = TenantUtils.getTenantCode();
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        Validate.notNull((Object)authentication, (String)"\u672a\u53d1\u73b0\u767b\u5f55\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String currentAccount = authentication.getName();
        if (!update) {
            onTimeValue = "\u6dfb\u52a0\u4f18\u60e0\u653f\u7b56\u65f6";
            salePolicy.setId(null);
            salePolicy.setCreateAccount(currentAccount);
            salePolicy.setCreateTime(now);
            salePolicy.setModifyAccount(currentAccount);
            salePolicy.setModifyTime(now);
            salePolicy.setTenantCode(tenantCode);
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)salePolicy.getId()), (String)(onTimeValue + "\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01"), (Object[])new Object[0]);
            salePolicyCode = salePolicy.getSalePolicyCode();
            if (StringUtils.isBlank((CharSequence)salePolicyCode)) {
                salePolicyCode = StringUtils.join((Object[])new String[]{tenantCode, new SimpleDateFormat("yyyyMMddHHmmssS").format(now)});
                salePolicy.setSalePolicyCode(salePolicyCode);
            }
            Validate.notBlank((CharSequence)salePolicyCode, (String)(onTimeValue + "\uff0c\u5fc5\u987b\u4f20\u5165/\u8bbe\u7f6e\u4f18\u60e0\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01\uff01"), (Object[])new Object[0]);
            exsitSalePolicy = this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
            Validate.isTrue((exsitSalePolicy == null ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u5f53\u524d\u4f7f\u7528\u7684\u4f18\u60e0\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            effective = salePolicy.getEffective();
            if (effective == null) {
                salePolicy.setEffective(Boolean.valueOf(true));
            }
        } else {
            onTimeValue = "\u4fee\u6539\u4f18\u60e0\u653f\u7b56\u65f6";
            salePolicy.setModifyAccount(currentAccount);
            salePolicy.setModifyTime(now);
            salePolicyCode = salePolicy.getSalePolicyCode();
            Validate.notBlank((CharSequence)salePolicyCode, (String)(onTimeValue + "\uff0c\u539f\u59cb\u4f18\u60e0\u653f\u7b56\u7684\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            Validate.isTrue((!StringUtils.isBlank((CharSequence)salePolicy.getId()) ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01"), (Object[])new Object[0]);
            exsitSalePolicy = this.salePolicyRepository.findBySalePolicyCodeAndTenantCodeWithoutId(salePolicyCode, tenantCode, salePolicy.getId());
            Validate.isTrue((exsitSalePolicy == null ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u4f20\u5165\u7684\u4f18\u60e0\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5\u66f4\u6362!!"), (Object[])new Object[0]);
            effective = salePolicy.getEffective();
            Validate.notNull((Object)effective, (String)(onTimeValue + "\uff0c\u4f18\u60e0\u653f\u7b56\u7684\u6709\u6548\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        }
        Validate.notNull((Object)salePolicy, (String)(onTimeValue + "\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)salePolicy.getSalePolicyName(), (String)(onTimeValue + "\uff0c\u4f18\u60e0\u653f\u7b56\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Date validStartTime = salePolicy.getValidStartTime();
        Validate.notNull((Object)validStartTime, (String)(onTimeValue + "\uff0c\u4f18\u60e0\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Date validEndTime = salePolicy.getValidEndTime();
        Validate.notNull((Object)validEndTime, (String)(onTimeValue + "\uff0c\u4f18\u60e0\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        long validStartTimeValue = validStartTime.getTime();
        long validEndTimeValue = validEndTime.getTime();
        Validate.isTrue((validStartTimeValue < validEndTimeValue ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u4f18\u60e0\u8d77\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u4f18\u60e0\u622a\u6b62\u65f6\u95f4\uff01"), (Object[])new Object[0]);
        Validate.isTrue((now.getTime() < validStartTimeValue ? 1 : 0) != 0, (String)(onTimeValue + "\uff0c\u4f18\u60e0\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5728\u5f53\u524d\u65f6\u95f4\u4e4b\u540e"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)salePolicy.getDescription(), (String)(onTimeValue + "\uff0c\u4f18\u60e0\u653f\u7b56\u63cf\u8ff0\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        salePolicy.setEffective(Boolean.valueOf(true));
        Validate.notNull((Object)salePolicy.getOverlap(), (String)(onTimeValue + "\uff0c\u662f\u5426\u5141\u8bb8\u653f\u7b56\u53e0\u52a0\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        String label = salePolicy.getLabel();
        Validate.notBlank((CharSequence)label, (String)(onTimeValue + "\uff0c\u4f18\u60e0\u653f\u7b56\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        Validate.isTrue((salePolicy.getDescription() == null || salePolicy.getDescription().length() < 400 ? 1 : 0) != 0, (String)(onTimeValue + "\u4f18\u60e0\u653f\u7b56\u4e2d\u6587\u63cf\u8ff0\u4fe1\u606f,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(200\u4e2a\u5b57\u7b26)\uff0c\u8bf7\u68c0\u67e5!"), (Object[])new Object[0]);
        Validate.isTrue((salePolicy.getSalePolicyCode() == null || salePolicy.getSalePolicyCode().length() < 128 ? 1 : 0) != 0, (String)(onTimeValue + "\u4fc3\u9500\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!"), (Object[])new Object[0]);
        Validate.isTrue((salePolicy.getSalePolicyName() == null || salePolicy.getSalePolicyName().length() < 128 ? 1 : 0) != 0, (String)(onTimeValue + "\u4fc3\u9500\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!"), (Object[])new Object[0]);
        Validate.isTrue((salePolicy.getDescription() == null || salePolicy.getDescription().length() < 512 ? 1 : 0) != 0, (String)(onTimeValue + "\u4e2d\u6587\u63cf\u8ff0\u4fe1\u606f,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!"), (Object[])new Object[0]);
    }

    @Transactional
    public SalePolicyVo update(JSONObject salePolicyJson) {
        Validate.notNull((Object)salePolicyJson, (String)"\u4fee\u6539\u4f18\u60e0\u653f\u7b56\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff08JSON\u5f62\u5f0f\uff09\u3002", (Object[])new Object[0]);
        SalePolicyVo currentSalePolicyVo = this.convertSalePolicyVo(salePolicyJson, "\u4fee\u6539\u65f6");
        this.updateHandle(currentSalePolicyVo);
        String tenantCode = TenantUtils.getTenantCode();
        this.salePolicyCacheLoadingService.notifyCacheRefresh(tenantCode);
        return currentSalePolicyVo;
    }

    @Transactional
    public SalePolicyVo update(SalePolicyVo salePolicy) {
        Validate.notNull((Object)salePolicy, (String)"\u4fee\u6539\u4f18\u60e0\u653f\u7b56\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff08\u5bf9\u8c61\u5f62\u5f0f\uff09\u3002", (Object[])new Object[0]);
        this.updateHandle(salePolicy);
        String tenantCode = TenantUtils.getTenantCode();
        this.salePolicyCacheLoadingService.notifyCacheRefresh(tenantCode);
        return salePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SalePolicyVo updateHandle(SalePolicyVo salePolicy) {
        block8: {
            String prefix = salePolicy.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u4f18\u60e0\u653f\u7b56\u9884\u4fee\u6539\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode(SALE_POLICY_GEN_PREFIX, prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u4f18\u60e0\u653f\u7b56\u7684\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0\uff0c\u8bf7\u4f7f\u7528preSave\u529f\u80fd\u8fdb\u884c\u6dfb\u52a0!!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode(SALE_POLICY_GEN_PREFIX, prefix, prefix, 1L);
                    break block8;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u6dfb\u52a0!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
        Date now = new Date();
        Validate.notNull((Object)salePolicy, (String)"\u4fee\u6539\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8981\u4fee\u6539\u7684\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09\uff0c\u8bf7\u53c2\u89c1\u6587\u6863!!", (Object[])new Object[0]);
        String salePolicyCode = salePolicy.getSalePolicyCode();
        Validate.notBlank((CharSequence)salePolicyCode, (String)"\u4fee\u6539\u65f6\uff0c\u672a\u53d1\u73b0\u5c06\u8981\u4fee\u6539\u7684\u4f18\u60e0\u653f\u7b56\u6709\u6b63\u786e\u7684\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String salePolicyId = salePolicy.getId();
        Validate.notBlank((CharSequence)salePolicyId, (String)"\u4fee\u6539\u65f6\uff0c\u672a\u53d1\u73b0\u5c06\u8981\u4fee\u6539\u7684\u4f18\u60e0\u653f\u7b56\u6709\u6b63\u786e\u7684id\u6280\u672f\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicy currentSalePolicy = this.salePolicyRepository.findBySalePolicyId(salePolicyId);
        Validate.notNull((Object)((Object)currentSalePolicy), (String)"\u4fee\u6539\u65f6\uff0c\u672a\u53d1\u73b0\u5c06\u8981\u4fee\u6539\u7684\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyVo currentSalePolicyVo = (SalePolicyVo)this.nebulaToolkitService.copyObjectByBlankList((Object)currentSalePolicy, SalePolicyVo.class, HashSet.class, LinkedList.class, new String[0]);
        String oldSalePolicyCode = currentSalePolicy.getSalePolicyCode();
        SalePolicyVo oldSalePolicyVo = this.findDetailsByCode(oldSalePolicyCode);
        Validate.notNull((Object)oldSalePolicyVo, (String)"\u4fee\u6539\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u4f18\u60e0\u653f\u7b56\u7684\u5386\u53f2\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        boolean effective = currentSalePolicy.getEffective();
        Date validStartTime = currentSalePolicy.getValidStartTime();
        if (!effective || now.getTime() > validStartTime.getTime()) {
            throw new IllegalArgumentException("\u4fee\u6539\u65f6\uff0c\u5df2\u5931\u6548/\u5df2\u7ed3\u675f\u7684\u4f18\u60e0\u653f\u7b56 , \u4e0d\u5141\u8bb8\u8fdb\u884c\u4fee\u6539;  \u8bf7\u68c0\u67e5!!");
        }
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)currentSalePolicy.getTempleteCode(), (CharSequence)oldSalePolicyVo.getTempleteCode()), (String)"\u4fee\u6539\u65f6\uff0c\u4f20\u5165\u4e86\u9519\u8bef\u7684\u4f18\u60e0\u653f\u7b56\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String policyType = salePolicy.getType();
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notNull((Object)policyType, (String)"\u4f18\u60e0\u7b56\u7565\u7c7b\u578b\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)policyType, (CharSequence)currentSalePolicy.getType()), (String)"\u4fee\u6539\u65f6\uff0c\u4f18\u60e0\u653f\u7b56\u7c7b\u578b\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyTempleteRegister matchedSalePolicyTempleteRegister = this.findSalePolicyTempleteRegister(policyType);
        Validate.notNull((Object)salePolicy, (String)"\u4fee\u6539\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8981\u6dfb\u52a0\u7684\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09\uff0c\u8bf7\u53c2\u89c1\u6587\u6863!!", (Object[])new Object[0]);
        Boolean supportProduct = matchedSalePolicyTempleteRegister.supportProduct();
        salePolicy.setWholePolicy(Boolean.valueOf(supportProduct == false));
        salePolicy.setTenantCode(tenantCode);
        currentSalePolicy.setSalePolicyCode(salePolicyCode);
        currentSalePolicy.setDescription(salePolicy.getDescription());
        currentSalePolicy.setLabel(salePolicy.getLabel());
        currentSalePolicy.setOverlap(salePolicy.getOverlap());
        currentSalePolicy.setSalePolicyName(salePolicy.getSalePolicyName());
        currentSalePolicy.setValidEndTime(salePolicy.getValidEndTime());
        currentSalePolicy.setValidStartTime(salePolicy.getValidStartTime());
        currentSalePolicy.setPromotionalGoods(salePolicy.getPromotionalGoods());
        this.salePolicyRepository.saveOrUpdate((Object)currentSalePolicy);
        this.handleExtendsInfos(true, matchedSalePolicyTempleteRegister, salePolicy, oldSalePolicyVo, supportProduct);
        if (!CollectionUtils.isEmpty(this.salePolicyEventListeners)) {
            for (SalePolicyEventListener salePolicyEventListener : this.salePolicyEventListeners) {
                salePolicyEventListener.onUpdate(salePolicy);
            }
        }
        this.recordLogOnUpdate(currentSalePolicyVo, salePolicy);
        return oldSalePolicyVo;
    }

    private void recordLogOnUpdate(SalePolicyVo currentSalePolicy, SalePolicyVo salePolicy) {
        SalePolicyLogDto logDto = new SalePolicyLogDto();
        logDto.setOriginal(currentSalePolicy);
        logDto.setNewest(salePolicy);
        SerializableBiConsumer & Serializable onUpdate = SalePolicyLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logDto, SalePolicyLogEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    private SalePolicyVo convertSalePolicyVo(JSONObject json, String onTime) {
        JSONArray salePolicyExecutorInfoArray;
        JSONArray salePolicyLimitInfoArray;
        Validate.notNull((Object)json, (String)(onTime + "\uff0c\u9519\u8bef\u7684json\u683c\u5f0f\u4fe1\u606f"), (Object[])new Object[0]);
        String type = json.getString("type");
        Validate.notBlank((CharSequence)type, (String)(onTime + "\uff0c\u9519\u8bef\u7684\u4f18\u60e0\u653f\u7b56\u7c7b\u578b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        SalePolicyTempleteRegister matchedSalePolicyRegister = this.findSalePolicyTempleteRegister(type);
        Boolean supportProduct = matchedSalePolicyRegister.supportProduct();
        Validate.notNull((Object)supportProduct, (String)(onTime + "\uff0c\u9519\u8bef\u7684\u5546\u54c1\u652f\u6491\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        SalePolicyStickupListener stickupListener = null;
        stickupListener = matchedSalePolicyRegister.getStickupListener();
        Validate.notNull((Object)stickupListener, (String)(onTime + "\uff0c\u672a\u53d1\u73b0\u5339\u914d\u7684\u4f18\u60e0\u653f\u7b56\u5177\u4f53\u6ce8\u518c\u5668\u5b58\u5728\u6570\u636e\u8fd0\u7ef4\u76d1\u542cSalePolicyStickupListener\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        SalePolicyVo salePolicyVo = (SalePolicyVo)JSON.parseObject((String)json.toJSONString(), SalePolicyVo.class);
        JSONArray characteristicInfoArray = json.getJSONArray("characteristicInfos");
        if (!CollectionUtils.isEmpty((Collection)characteristicInfoArray)) {
            LinkedHashSet characteristicInfos = Sets.newLinkedHashSet();
            for (int index = 0; index < characteristicInfoArray.size(); ++index) {
                JSONObject characteristicInfoJsonObject = characteristicInfoArray.getJSONObject(index);
                String characteristicCode = characteristicInfoJsonObject.getString("characteristicCode");
                Validate.notBlank((CharSequence)characteristicCode, (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u8f6c\u6362\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u6709\u4e00\u4e2a\u7279\u6027\u6267\u884c\u4fe1\u606f\uff08characteristicCode\u5c5e\u6027\uff09\u6ca1\u6709\u5bf9\u5e94\u7684\u7279\u6027\u6267\u884c\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                CharacteristicStrategy<? extends AbstractCharacteristicInfo> currentCharacteristicStrategy = this.findCorrectCharacteristicStrategy(matchedSalePolicyRegister, characteristicCode);
                Class currentCharacteristicInfoClass = currentCharacteristicStrategy.getCharacteristicInfoClass();
                AbstractCharacteristicInfo characteristicInfo = (AbstractCharacteristicInfo)JSONObject.toJavaObject((JSON)characteristicInfoJsonObject, (Class)currentCharacteristicInfoClass);
                characteristicInfos.add(characteristicInfo);
            }
            salePolicyVo.setCharacteristicInfos((Set)characteristicInfos);
        }
        if (supportProduct.booleanValue()) {
            Class currentSalePolicyProductInfoClass = stickupListener.getSalePolicyProductInfoClass();
            Validate.notNull((Object)currentSalePolicyProductInfoClass, (String)"\u53d1\u73b0\u7c7b\u578b(%s)\u4e3a\u7684\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u6ce8\u518c\uff0c\u6ca1\u6709\u6307\u5b9a\u5177\u4f53\u7684SalePolicyProductInfo\u7c7b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{type});
            JSONArray salePolicyProductInfoArray = json.getJSONArray("salePolicyProductInfos");
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)salePolicyProductInfoArray) ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u8f6c\u6362\u65f6\uff0c\u672a\u8bbe\u5b9a\u4efb\u4f55\u4e00\u4e2a\u5546\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            List salePolicyProductInfos = JSONArray.parseArray((String)salePolicyProductInfoArray.toJSONString(), (Class)currentSalePolicyProductInfoClass);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)salePolicyProductInfos) ? 1 : 0) != 0, (String)"\u53d1\u73b0\u7c7b\u578b(%s)\u4e3a\u7684\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u6ce8\u518c\uff0c\u6ca1\u6709\u6b63\u786e\u8f6c\u6362\u5546\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{type});
            salePolicyVo.setSalePolicyProductInfos((Set)Sets.newLinkedHashSet((Iterable)salePolicyProductInfos));
        }
        JSONObject salePolicyCustomerInfoMaps = json.getJSONObject("salePolicyCustomerInfos");
        Validate.notNull((Object)salePolicyCustomerInfoMaps, (String)(onTime + "\uff0c\u672a\u53d1\u73b0\u4efb\u4f55\u5ba2\u6237\u8303\u56f4\u9009\u62e9\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        Set scopeTypes = salePolicyCustomerInfoMaps.keySet();
        LinkedHashMap salePolicyCustomerInfoObjectMaps = Maps.newLinkedHashMap();
        for (String customerScopeType : scopeTypes) {
            SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> currentCustomerScopeStrategy = this.findCorrectCustomerScopeStrategy(matchedSalePolicyRegister, customerScopeType);
            Class currentSalePolicyCustomerInfoClass = currentCustomerScopeStrategy.getSalePolicyCustomerInfoClass();
            Validate.notNull((Object)currentSalePolicyCustomerInfoClass, (String)"\u53d1\u73b0\u7c7b\u578b(%s)\u4e3a\u7684\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u6ce8\u518c\uff0c\u6ca1\u6709\u6307\u5b9a\u5177\u4f53\u7684SalePolicyCustomerInfo\u7c7b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{customerScopeType});
            JSONArray customerInfoArray = salePolicyCustomerInfoMaps.getJSONArray(customerScopeType);
            if (CollectionUtils.isEmpty((Collection)customerInfoArray)) continue;
            List salePolicyCustomerInfos = JSONArray.parseArray((String)customerInfoArray.toJSONString(), (Class)currentSalePolicyCustomerInfoClass);
            salePolicyCustomerInfoObjectMaps.put(customerScopeType, Sets.newLinkedHashSet((Iterable)salePolicyCustomerInfos));
        }
        salePolicyVo.setCustomerScopeMapping((Map)salePolicyCustomerInfoObjectMaps);
        Class currentSalePolicyProductThresholdClass = stickupListener.getSalePolicyProductThresholdClass();
        Validate.notNull((Object)currentSalePolicyProductThresholdClass, (String)"\u53d1\u73b0\u7c7b\u578b(%s)\u4e3a\u7684\u4f18\u60e0\u653f\u7b56\u95e8\u69db\uff0c\u6ca1\u6709\u6307\u5b9a\u5177\u4f53\u7684AbstractSalePolicyProductThreshold\u7c7b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{type});
        JSONObject salePolicyProductThresholdObject = json.getJSONObject("salePolicyProductThreshold");
        if (salePolicyProductThresholdObject != null) {
            AbstractSalePolicyThreshold salePolicyThreshold = (AbstractSalePolicyThreshold)JSONObject.toJavaObject((JSON)salePolicyProductThresholdObject, (Class)currentSalePolicyProductThresholdClass);
            salePolicyVo.setSalePolicyProductThreshold(salePolicyThreshold);
        }
        if (!CollectionUtils.isEmpty((Collection)(salePolicyLimitInfoArray = json.getJSONArray("salePolicyLimitInfos")))) {
            LinkedHashSet salePolicyLimitInfos = Sets.newLinkedHashSet();
            for (int index = 0; index < salePolicyLimitInfoArray.size(); ++index) {
                JSONObject limitInfoJsonObject = salePolicyLimitInfoArray.getJSONObject(index);
                String limitStrategyCode = limitInfoJsonObject.getString("limitStrategyCode");
                Validate.notBlank((CharSequence)limitStrategyCode, (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u8f6c\u6362\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u6709\u4e00\u4e2a\u9650\u4ef7\u653f\u7b56\u6ca1\u6709\u8bbe\u7f6e\u7f16\u53f7\u4fe1\u606f\uff08limitStrategyCode\u5c5e\u6027\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo> currentSalePolicyLimitStrategy = this.findCorrectLimitStrategy(matchedSalePolicyRegister, limitStrategyCode);
                Class currentSalePolicyLimitInfoClass = currentSalePolicyLimitStrategy.getSalePolicyLimitInfoClass();
                AbstractSalePolicyLimitInfo salePolicyLimitInfo = (AbstractSalePolicyLimitInfo)JSONObject.toJavaObject((JSON)limitInfoJsonObject, (Class)currentSalePolicyLimitInfoClass);
                salePolicyLimitInfos.add(salePolicyLimitInfo);
            }
            salePolicyVo.setSalePolicyLimitInfos((Set)salePolicyLimitInfos);
        }
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)(salePolicyExecutorInfoArray = json.getJSONArray("salePolicyExecutorInfos"))) ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u8f6c\u6362\u65f6\uff0c\u672a\u8bbe\u5b9a\u4efb\u4f55\u4e00\u79cd\u4f18\u60e0\u6267\u884c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedHashSet salePolicyExecutorInfos = Sets.newLinkedHashSet();
        for (int index = 0; index < salePolicyExecutorInfoArray.size(); ++index) {
            JSONObject salePolicyExecutorInfoObject = salePolicyExecutorInfoArray.getJSONObject(index);
            String executeStrategyCode = salePolicyExecutorInfoObject.getString("executeStrategyCode");
            Validate.notBlank((CharSequence)executeStrategyCode, (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u8f6c\u6362\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7b56\u7565\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy = this.findCorrectExecuteStrategy(matchedSalePolicyRegister, executeStrategyCode);
            Class salePolicyExecutorInfoClass = salePolicyExecuteStrategy.getSalePolicyExecutorInfoClass();
            AbstractSalePolicyExecutorInfo salePolicyExecutorInfo = (AbstractSalePolicyExecutorInfo)JSONObject.toJavaObject((JSON)salePolicyExecutorInfoObject, (Class)salePolicyExecutorInfoClass);
            salePolicyExecutorInfos.add(salePolicyExecutorInfo);
            String cycleRuleCode = salePolicyExecutorInfo.getCycleRuleCode();
            Validate.notBlank((CharSequence)cycleRuleCode, (String)"\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u7ef4\u62a4\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u4f7f\u7528\u7684\u201c\u9636\u68af\u5faa\u73af\u89c4\u5219\u201d(cycleRuleCode)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Collection cycleRuleStrategyClasses = salePolicyExecuteStrategy.getCycleRuleStrategyClasses();
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)cycleRuleStrategyClasses) ? 1 : 0) != 0, (String)"\u53d1\u73b0\u7c7b\u578b(%s)\u4e3a\u7684\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u6ce8\u518c\uff0c\u672a\u8bbe\u5b9a\u4efb\u4f55\u4e00\u4e2a\u201c\u9636\u68af\u5faa\u73af\u89c4\u5219\u201d\uff08SalePolicyCycleRuleStrategy\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{type});
            boolean matchedSalePolicyCycleRuleStrategy = false;
            for (Class cycleRuleStrategyClass : cycleRuleStrategyClasses) {
                SalePolicyCycleRuleStrategy salePolicyCycleRuleStrategy = (SalePolicyCycleRuleStrategy)this.applicationContext.getBean(cycleRuleStrategyClass);
                if (!StringUtils.equals((CharSequence)salePolicyCycleRuleStrategy.getCycleRuleCode(), (CharSequence)cycleRuleCode)) continue;
                matchedSalePolicyCycleRuleStrategy = true;
                break;
            }
            Validate.isTrue((boolean)matchedSalePolicyCycleRuleStrategy, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u201c\u9636\u68af\u5faa\u73af\u89c4\u5219\u201d\uff08%s\uff09 , \u8bf7\u68c0\u67e5!!", (Object[])new Object[]{cycleRuleCode});
        }
        salePolicyVo.setSalePolicyExecutorInfos((Set)salePolicyExecutorInfos);
        return salePolicyVo;
    }

    private Set<CharacteristicStrategy<? extends AbstractCharacteristicInfo>> findAllBindingCharacteristicStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        Collection characteristicStrategyClasses = salePolicyTempleteRegister.getCharacteristicStrategyClasses();
        if (CollectionUtils.isEmpty((Collection)characteristicStrategyClasses)) {
            return null;
        }
        LinkedHashSet bindableCharacteristicStrategySet = Sets.newLinkedHashSet();
        for (Class characteristicStrategyClass : characteristicStrategyClasses) {
            try {
                CharacteristicStrategy currentCharacteristicStrategy = (CharacteristicStrategy)this.applicationContext.getBean(characteristicStrategyClass);
                bindableCharacteristicStrategySet.add(currentCharacteristicStrategy);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return bindableCharacteristicStrategySet;
    }

    private Set<SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>> findAllBindingExecuteStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        Collection bindableExecuteStrategyClasses = salePolicyTempleteRegister.getExecuteStrategyClasses();
        if (CollectionUtils.isEmpty((Collection)bindableExecuteStrategyClasses)) {
            return null;
        }
        LinkedHashSet bindableExecuteStrategySet = Sets.newLinkedHashSet();
        for (Class bindableExecuteStrategyClass : bindableExecuteStrategyClasses) {
            try {
                SalePolicyExecuteStrategy currentSalePolicyExecuteStrategy = (SalePolicyExecuteStrategy)this.applicationContext.getBean(bindableExecuteStrategyClass);
                bindableExecuteStrategySet.add(currentSalePolicyExecuteStrategy);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return bindableExecuteStrategySet;
    }

    private CharacteristicStrategy<? extends AbstractCharacteristicInfo> findCorrectCharacteristicStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister, String characteristicStrategyCode) {
        Collection characteristicStrategyClasses = salePolicyTempleteRegister.getCharacteristicStrategyClasses();
        if (CollectionUtils.isEmpty((Collection)characteristicStrategyClasses)) {
            return null;
        }
        for (Class characteristicStrategyClass : characteristicStrategyClasses) {
            try {
                CharacteristicStrategy characteristicStrategy = (CharacteristicStrategy)this.applicationContext.getBean(characteristicStrategyClass);
                if (!StringUtils.equals((CharSequence)characteristicStrategy.characteristicCode(), (CharSequence)characteristicStrategyCode)) continue;
                return characteristicStrategy;
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> findCorrectExecuteStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister, String executeStrategyCode) {
        Set<SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>> bindableExecuteStrategies = this.findAllBindingExecuteStrategy(salePolicyTempleteRegister);
        Validate.isTrue((!CollectionUtils.isEmpty(bindableExecuteStrategies) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u6709\u81f3\u5c11\u4e00\u4e2a\u80fd\u7ed1\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedHashMap bindableExecuteStrategyMapping = Maps.newLinkedHashMap();
        for (SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy : bindableExecuteStrategies) {
            bindableExecuteStrategyMapping.put(salePolicyExecuteStrategy.getExecuteStrategyCode(), salePolicyExecuteStrategy);
        }
        Validate.notBlank((CharSequence)executeStrategyCode, (String)"\u81f3\u5c11\u4e00\u4e2a\u5c06\u8981\u4fdd\u5b58\u7684\u4f18\u60e0\u6267\u884c\u7b56\u7565\u6ca1\u6709\u6307\u5b9aexecutorCode\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyExecuteStrategy currentSalePolicyExecuteStrategy = (SalePolicyExecuteStrategy)((HashMap)bindableExecuteStrategyMapping).get(executeStrategyCode);
        Validate.notNull((Object)currentSalePolicyExecuteStrategy, (String)"\u672a\u5339\u914d\u5230\u4e1a\u52a1\u7f16\u53f7\u4e3a:%s \u7684\u4f18\u60e0\u6267\u884c\u7b56\u7565\u4fe1\u606f\uff0c\u53ef\u80fd\u662f\u8be5\u653f\u7b56\u4e0d\u5b58\u5728\u6216\u8005\u8be5\u4f18\u60e0\u653f\u7b56\u4e0d\u5141\u8bb8\u5173\u8054\u8fd9\u4e2a\u6267\u884c\u653f\u7b56\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{executeStrategyCode});
        return currentSalePolicyExecuteStrategy;
    }

    private Set<SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>> findAllBindingLimitStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        Collection bindableLimitStrategyClasses = salePolicyTempleteRegister.getBindableLimitStrategyClasses();
        if (CollectionUtils.isEmpty((Collection)bindableLimitStrategyClasses)) {
            return null;
        }
        LinkedHashSet bindableLimitStrategySet = Sets.newLinkedHashSet();
        for (Class bindableLimitStrategyClass : bindableLimitStrategyClasses) {
            try {
                SalePolicyLimitStrategy currentSalePolicyLimitStrategy = (SalePolicyLimitStrategy)this.applicationContext.getBean(bindableLimitStrategyClass);
                bindableLimitStrategySet.add(currentSalePolicyLimitStrategy);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return bindableLimitStrategySet;
    }

    private SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo> findCorrectLimitStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister, String limitStrategyCode) {
        Set<SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>> bindableLimitStrategies = this.findAllBindingLimitStrategy(salePolicyTempleteRegister);
        Validate.isTrue((!CollectionUtils.isEmpty(bindableLimitStrategies) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u6709\u81f3\u5c11\u4e00\u4e2a\u80fd\u7ed1\u5b9a\u7684\u9650\u4ef7\u653f\u7b56\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedHashMap bindableLimitStrategyMapping = Maps.newLinkedHashMap();
        for (SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo> salePolicyLimitStrategy : bindableLimitStrategies) {
            bindableLimitStrategyMapping.put(salePolicyLimitStrategy.getLimitStrategyCode(), salePolicyLimitStrategy);
        }
        Validate.notBlank((CharSequence)limitStrategyCode, (String)"\u81f3\u5c11\u4e00\u4e2a\u5c06\u8981\u4fdd\u5b58\u7684\u73b0\u4ef7\u7b56\u7565\u6ca1\u6709\u6307\u5b9acode\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyLimitStrategy currentSalePolicyLimitStrategy = (SalePolicyLimitStrategy)((HashMap)bindableLimitStrategyMapping).get(limitStrategyCode);
        Validate.notNull((Object)currentSalePolicyLimitStrategy, (String)"\u672a\u5339\u914d\u5230\u4e1a\u52a1\u7f16\u53f7\u4e3a:%s \u7684\u9650\u91cf\u653f\u7b56\u4fe1\u606f\uff0c\u53ef\u80fd\u662f\u8be5\u653f\u7b56\u4e0d\u5b58\u5728\u6216\u8005\u6539\u4f18\u60e0\u653f\u7b56\u4e0d\u5141\u8bb8\u5173\u8054\u8fd9\u4e2a\u9650\u91cf\u653f\u7b56\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{limitStrategyCode});
        return currentSalePolicyLimitStrategy;
    }

    private SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> findCorrectCustomerScopeStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister, String customerScopeType) {
        Set<SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>> salePolicyCustomerScopeStrategies = this.findAllBindCustomerScopeStrategy(salePolicyTempleteRegister);
        LinkedHashMap bindableCustomerScopeStrategyMapping = Maps.newLinkedHashMap();
        for (SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> salePolicyCustomerScopeStrategy : salePolicyCustomerScopeStrategies) {
            bindableCustomerScopeStrategyMapping.put(salePolicyCustomerScopeStrategy.getScopeType(), salePolicyCustomerScopeStrategy);
        }
        Validate.notBlank((CharSequence)customerScopeType, (String)"\u8be5\u4f18\u60e0\u653f\u7b56\u4fdd\u5b58\u65f6\uff0c\u5e76\u6ca1\u6709\u8bbe\u5b9a\u5ba2\u6237\u8303\u56f4\u7684\u9009\u62e9\u7c7b\u578b(\u6216\u8005\u6839\u672c\u6ca1\u6709\u4f20\u5165)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyCustomerScopeStrategy currentCustomerScopeStrategy = (SalePolicyCustomerScopeStrategy)((HashMap)bindableCustomerScopeStrategyMapping).get(customerScopeType);
        Validate.notNull((Object)currentCustomerScopeStrategy, (String)"\u8be5\u4f18\u60e0\u653f\u7b56\u4fdd\u5b58\u65f6\uff0c\u5e76\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7c7b\u578b\u7684\u5ba2\u6237\u8303\u56f4\u9009\u62e9\u7b56\u7565\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return currentCustomerScopeStrategy;
    }

    private Set<SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>> findAllBindCustomerScopeStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        Collection salePolicyCustomerScopeStrategyClasses = salePolicyTempleteRegister.getCustomerScopeStrategyClasses();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)salePolicyCustomerScopeStrategyClasses) ? 1 : 0) != 0, (String)"\u8be5\u4f18\u60e0\u653f\u7b56\u5e76\u6ca1\u6709\u6ce8\u518c\u4efb\u4f55\u5ba2\u6237\u8fd4\u56de\u9009\u62e9\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedHashSet bindableCustomerScopeStrategies = Sets.newLinkedHashSet();
        for (Class salePolicyCustomerScopeStrategyClass : salePolicyCustomerScopeStrategyClasses) {
            try {
                SalePolicyCustomerScopeStrategy currentSalePolicyCustomerScopeStrategy = (SalePolicyCustomerScopeStrategy)this.applicationContext.getBean(salePolicyCustomerScopeStrategyClass);
                String currentScopeType = currentSalePolicyCustomerScopeStrategy.getScopeType();
                Validate.notBlank((CharSequence)currentScopeType, (String)"\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u5ba2\u6237\u8303\u56f4\u7b56\u7565\u6ca1\u6709\u6307\u5b9acode\u4fe1\u606f(%s)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{salePolicyCustomerScopeStrategyClass.getName()});
                bindableCustomerScopeStrategies.add(currentSalePolicyCustomerScopeStrategy);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return bindableCustomerScopeStrategies;
    }

    private SalePolicyTempleteRegister findSalePolicyTempleteRegister(String type) {
        Validate.notBlank((CharSequence)"\u9519\u8bef\u7684\u4f18\u60e0\u653f\u7b56\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u503c");
        Validate.isTrue((!CollectionUtils.isEmpty(this.salePolicyTempleteRegisters) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684SalePolicyTempleteRegister\uff08\u96c6\u5408\uff09\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyTempleteRegister matchedSalePolicyTempleteRegister = null;
        for (SalePolicyTempleteRegister item : this.salePolicyTempleteRegisters) {
            if (!StringUtils.equals((CharSequence)type, (CharSequence)item.getType())) continue;
            matchedSalePolicyTempleteRegister = item;
            break;
        }
        Validate.notNull(matchedSalePolicyTempleteRegister, (String)"\u672a\u5339\u914d\u4efb\u4f55SalePolicyTempleteRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return matchedSalePolicyTempleteRegister;
    }

    @Transactional
    public void invalid(String[] salePolicyCodes) {
        Validate.isTrue((salePolicyCodes != null && salePolicyCodes.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u5931\u6548\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u4e1a\u52a1\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        for (String salePolicyCode : salePolicyCodes) {
            SalePolicy currentSalePolicy = this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
            Validate.notNull((Object)((Object)currentSalePolicy), (String)"\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u5931\u6548\u64cd\u4f5c\u65f6\uff0c\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u5fc5\u987b\u5b58\u5728(%s)", (Object[])new Object[]{salePolicyCode});
            SalePolicyVo currentSalePolicyVo = this.findDetailsByCode(currentSalePolicy.getSalePolicyCode());
            currentSalePolicy.setEffective(false);
            currentSalePolicy.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            this.salePolicyRepository.saveOrUpdate((Object)currentSalePolicy);
            if (!CollectionUtils.isEmpty(this.salePolicyEventListeners)) {
                for (SalePolicyEventListener salePolicyEventListener : this.salePolicyEventListeners) {
                    salePolicyEventListener.onUpdate(currentSalePolicyVo);
                }
            }
            this.recordLogOnDisable(currentSalePolicy);
        }
        this.salePolicyCacheLoadingService.notifyCacheRefresh(tenantCode);
    }

    private void recordLogOnDisable(SalePolicy currentSalePolicy) {
        SalePolicyVo voDb = new SalePolicyVo();
        voDb.setId(currentSalePolicy.getId());
        voDb.setEffective(Boolean.valueOf(true));
        SalePolicyVo vo = new SalePolicyVo();
        vo.setId(currentSalePolicy.getId());
        vo.setEffective(Boolean.valueOf(false));
        SalePolicyLogDto logDto = new SalePolicyLogDto();
        logDto.setOriginal(voDb);
        logDto.setNewest(vo);
        SerializableBiConsumer & Serializable OnDisable = SalePolicyLogEventListener::OnDisable;
        this.nebulaNetEventClient.publish((NebulaEventDto)logDto, SalePolicyLogEventListener.class, (SerializableBiConsumer)OnDisable);
    }

    @Transactional
    public void effective(String[] salePolicyCodes) {
        Validate.isTrue((salePolicyCodes != null && salePolicyCodes.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u542f\u7528\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u4e1a\u52a1\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        for (String salePolicyCode : salePolicyCodes) {
            SalePolicy currentSalePolicy = this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
            Validate.notNull((Object)((Object)currentSalePolicy), (String)"\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u542f\u7528\u64cd\u4f5c\u65f6\uff0c\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u5fc5\u987b\u5b58\u5728\uff08%s\uff09", (Object[])new Object[]{salePolicyCode});
            SalePolicyVo currentSalePolicyVo = this.findDetailsByCode(currentSalePolicy.getSalePolicyCode());
            currentSalePolicy.setEffective(true);
            currentSalePolicy.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            this.salePolicyRepository.saveOrUpdate((Object)currentSalePolicy);
            if (!CollectionUtils.isEmpty(this.salePolicyEventListeners)) {
                for (SalePolicyEventListener salePolicyEventListener : this.salePolicyEventListeners) {
                    salePolicyEventListener.onUpdate(currentSalePolicyVo);
                }
            }
            this.recordLogOnEnable(currentSalePolicy);
        }
        this.salePolicyCacheLoadingService.notifyCacheRefresh(tenantCode);
    }

    private void recordLogOnEnable(SalePolicy currentSalePolicy) {
        SalePolicyVo voDb = new SalePolicyVo();
        voDb.setId(currentSalePolicy.getId());
        voDb.setEffective(Boolean.valueOf(false));
        SalePolicyVo vo = new SalePolicyVo();
        vo.setId(currentSalePolicy.getId());
        vo.setEffective(Boolean.valueOf(true));
        SalePolicyLogDto logDto = new SalePolicyLogDto();
        logDto.setOriginal(voDb);
        logDto.setNewest(vo);
        SerializableBiConsumer & Serializable OnEnable = SalePolicyLogEventListener::OnEnable;
        this.nebulaNetEventClient.publish((NebulaEventDto)logDto, SalePolicyLogEventListener.class, (SerializableBiConsumer)OnEnable);
    }

    @Transactional
    public void deleteBySalePolicyCode(String salePolicyCode) {
        Validate.notBlank((CharSequence)salePolicyCode, (String)"\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u4e1a\u52a1\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyVo currntSalePolicy = this.findDetailsByCode(salePolicyCode);
        Validate.notNull((Object)currntSalePolicy, (String)"\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u5220\u9664\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Set<SalePolicyRecord> salePolicyRecords = this.salePolicyRecordRepository.findByTenantCodeAndSalePolicyCode(tenantCode, salePolicyCode);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(salePolicyRecords), (String)"\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u5220\u9664\u65f6\uff0c\u53d1\u73b0\u8be5\u4f18\u60e0\u653f\u7b56\u5df2\u7ecf\u4ea7\u751f\u4e86\u6267\u884c\u6d41\u6c34\uff0c\u4e0d\u80fd\u4e0d\u5220\u9664\uff01", (Object[])new Object[0]);
        this.salePolicyRepository.deleteByIds(Sets.newHashSet((Object[])new String[]{currntSalePolicy.getId()}));
        this.recordLogOnDelete(currntSalePolicy);
        this.salePolicyCacheLoadingService.notifyCacheRefresh(tenantCode);
    }

    private void recordLogOnDelete(SalePolicyVo currntSalePolicy) {
        SalePolicyVo voDb = new SalePolicyVo();
        voDb.setId(currntSalePolicy.getId());
        SalePolicyLogDto logDto = new SalePolicyLogDto();
        logDto.setOriginal(voDb);
        logDto.setNewest(null);
        SerializableBiConsumer & Serializable OnDelete = SalePolicyLogEventListener::OnDelete;
        this.nebulaNetEventClient.publish((NebulaEventDto)logDto, SalePolicyLogEventListener.class, (SerializableBiConsumer)OnDelete);
    }

    public SalePolicyVo findDetailsByCode(String salePolicyCode) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)salePolicyCode)) {
            return null;
        }
        Set<SalePolicyVo> results = this.salePolicyCacheLoadingService.findByTenantCode(tenantCode, Sets.newHashSet((Object[])new String[]{salePolicyCode}));
        if (CollectionUtils.isEmpty(results)) {
            SalePolicy repositorySalePolicy = this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
            if (repositorySalePolicy != null) {
                this.salePolicyCacheLoadingService.reloadingCache(tenantCode);
                return this.findDetailsByCode(salePolicyCode);
            }
            return null;
        }
        SalePolicyVo result = results.iterator().next();
        try {
            return this.single(result);
        }
        catch (CloneNotSupportedException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Set<SalePolicyVo> findDetailsByProcessing(boolean processing) {
        String tenantCode = TenantUtils.getTenantCode();
        LinkedHashSet resultSalePolicyVos = Sets.newLinkedHashSet();
        Date now = new Date();
        Set<SalePolicyVo> salePolicies = this.salePolicyCacheLoadingService.findByTenantCode(tenantCode, null);
        if (CollectionUtils.isEmpty(salePolicies)) {
            return resultSalePolicyVos;
        }
        for (SalePolicyVo salePolicyVoItem : salePolicies) {
            boolean isProcessing = false;
            if (salePolicyVoItem.getEffective().booleanValue() && now.after(salePolicyVoItem.getValidStartTime()) && now.before(salePolicyVoItem.getValidEndTime())) {
                isProcessing = true;
            }
            if (processing != isProcessing) continue;
            resultSalePolicyVos.add(salePolicyVoItem);
        }
        try {
            return (Set)this.multiple(resultSalePolicyVos);
        }
        catch (CloneNotSupportedException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Set<SalePolicyVo> findDetailsByProcessingAndCustomerCode(String tenantCode, boolean processing, String customerCode, String relevanceCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, customerCode})) {
            return null;
        }
        Set<SalePolicyVo> salePolicies = this.salePolicyCacheLoadingService.findByTenantCode(tenantCode, null);
        if (CollectionUtils.isEmpty(salePolicies)) {
            return null;
        }
        LinkedHashSet filterResultSalePolicyVos = Sets.newLinkedHashSet();
        for (SalePolicyVo salePolicyVoItem : salePolicies) {
            if (!salePolicyVoItem.getEffective().booleanValue()) continue;
            filterResultSalePolicyVos.add(salePolicyVoItem);
        }
        Set resultSalePolicyVos = this.salePolicyMatchedStrategy.match((Set)filterResultSalePolicyVos, tenantCode, processing, customerCode, relevanceCode);
        try {
            return (Set)this.multiple(resultSalePolicyVos);
        }
        catch (CloneNotSupportedException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Set<SalePolicyVo> findDetailsByProcessingAndCustomerCodesAndProductCodes(String tenantCode, boolean processing, String customerCode, String relevanceCode, String ... productCodes) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, customerCode}) || productCodes == null || productCodes.length == 0) {
            return null;
        }
        Set<SalePolicyVo> salePolicies = this.salePolicyCacheLoadingService.findByTenantCode(tenantCode, null);
        if (CollectionUtils.isEmpty(salePolicies)) {
            return null;
        }
        LinkedHashSet filterResultSalePolicyVos = Sets.newLinkedHashSet();
        for (SalePolicyVo salePolicyVoItem : salePolicies) {
            if (!salePolicyVoItem.getEffective().booleanValue()) continue;
            filterResultSalePolicyVos.add(salePolicyVoItem);
        }
        Set resultSalePolicyVos = this.salePolicyMatchedStrategy.match((Set)filterResultSalePolicyVos, tenantCode, processing, customerCode, relevanceCode, productCodes);
        try {
            return (Set)this.multiple(resultSalePolicyVos);
        }
        catch (CloneNotSupportedException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Page<SalePolicyVo> findByConditions(Pageable pageable, SalePolicyPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (SalePolicyPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new SalePolicyPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<SalePolicy> entityPage = this.salePolicyRepository.findByConditions(pageable, dto);
        List entities = entityPage.getRecords();
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        pageResult.setRecords(this.covertEntityToVo(entities));
        return pageResult;
    }

    private List<SalePolicyVo> covertEntityToVo(List<SalePolicy> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        List<String> templeteCodes = entities.stream().map(SalePolicy::getTempleteCode).distinct().collect(Collectors.toList());
        List<SalePolicyTemplete> salePolicyTempletes = this.salePolicyTempleteRepository.findByTempleteCodes(templeteCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(salePolicyTempletes)) {
            LOGGER.warn("\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u4fe1\u606f\u586b\u5145\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u6570\u636e\uff0c\u5904\u7406\u8fc7\u7a0b\u7ec8\u6b62!!");
            return Lists.newArrayList();
        }
        Map<String, SalePolicyTemplete> salePolicyTempleteCodeMapping = salePolicyTempletes.stream().collect(Collectors.toMap(SalePolicyTemplete::getTempleteCode, item -> item));
        ArrayList salePolicyVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, SalePolicy.class, SalePolicyVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        if (CollectionUtils.isEmpty((Collection)salePolicyVos)) {
            return Lists.newArrayList();
        }
        for (SalePolicyVo salePolicyItem : salePolicyVos) {
            String currentSalePolicyTempleteCode = salePolicyItem.getTempleteCode();
            SalePolicyTemplete currentSalePolicyTemplete = salePolicyTempleteCodeMapping.get(currentSalePolicyTempleteCode);
            if (currentSalePolicyTemplete == null) continue;
            String templeteRegisterType = currentSalePolicyTemplete.getType();
            salePolicyItem.setTempleteName(currentSalePolicyTemplete.getTempleteName());
            SalePolicyTempleteRegister salePolicyTempleteRegister = this.findSalePolicyTempleteRegister(templeteRegisterType);
            if (salePolicyTempleteRegister == null) continue;
            salePolicyItem.setTempleteRegisterType(templeteRegisterType);
            salePolicyItem.setTempleteRegisterTypeDesc(salePolicyTempleteRegister.getTypeDesc());
        }
        try {
            return (List)this.multiple(salePolicyVos);
        }
        catch (CloneNotSupportedException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private SalePolicyVo single(SalePolicyVo targetSalePolicyVo) throws CloneNotSupportedException {
        byte[] contextBytes = null;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(byteStream);){
            out.writeObject(targetSalePolicyVo);
            contextBytes = byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        SalePolicyVo cloneSalePolicyVo = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(contextBytes));){
            cloneSalePolicyVo = (SalePolicyVo)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return cloneSalePolicyVo;
    }

    private <T extends Collection<SalePolicyVo>> T multiple(Collection<SalePolicyVo> targetSalePolicyVos) throws CloneNotSupportedException {
        byte[] contextBytes = null;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(byteStream);){
            out.writeObject(targetSalePolicyVos);
            contextBytes = byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        Collection resultsCollection = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(contextBytes));){
            resultsCollection = (Collection)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return (T)resultsCollection;
    }
}

