/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.task;

import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeMergeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.vo.DefaultLoginDetails;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;

public class SalePolicyCustomerScopeMatchedTask
implements Callable<Boolean> {
    @Autowired(required=false)
    private Set<SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>> salePolicyCustomerScopeStrategies;
    @Autowired(required=false)
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired(required=false)
    private SalePolicyCustomerScopeMergeStrategy salePolicyCustomerScopeMergeStrategy;
    private SalePolicyVo salePolicyVo;
    private String tenantCode;
    private String customerCode;

    public SalePolicyCustomerScopeMatchedTask(SalePolicyVo salePolicyVo, String tenantCode, String customerCode) {
        this.salePolicyVo = salePolicyVo;
        this.tenantCode = tenantCode;
        this.customerCode = customerCode;
        Validate.notNull((Object)salePolicyVo, (String)"salePolicyCustomerScopeMatchedTask: salePolicy null !!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)"salePolicyCustomerScopeMatchedTask: tenantCode blank !!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerCode, (String)"salePolicyCustomerScopeMatchedTask: customerCode blank !!", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        String account = this.simpleSecurityProperties.getIndependencyUser();
        String[] independencyRoles = this.simpleSecurityProperties.getIndependencyRoles();
        Integer type = this.simpleSecurityProperties.getDefaultLoginType();
        for (String independencyRole : independencyRoles) {
            SimpleGrantedAuthority authoritie = new SimpleGrantedAuthority(StringUtils.upperCase((String)independencyRole));
            authorities.add(authoritie);
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)account, (Object)"123455", authorities);
        DefaultLoginDetails loginDetails = new DefaultLoginDetails(type, this.tenantCode, account, null, null, null);
        authentication.setDetails((Object)loginDetails);
        securityContext.setAuthentication((Authentication)authentication);
        try {
            Boolean bl = this.matchedCustomerScopeMerge();
            return bl;
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    private boolean matchedCustomerScopeMerge() {
        Map customerScopeStrategies = this.salePolicyVo.getCustomerScopeMapping();
        if (CollectionUtils.isEmpty((Map)customerScopeStrategies)) {
            return false;
        }
        boolean currentMatched = false;
        ArrayList matchedList = Lists.newArrayList();
        int size = customerScopeStrategies.size();
        for (Map.Entry customerScopeStrategyEntry : customerScopeStrategies.entrySet()) {
            String scopeType = (String)customerScopeStrategyEntry.getKey();
            Set salePolicyCustomerScopeInfos = (Set)customerScopeStrategyEntry.getValue();
            SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> salePolicyCustomerScopeStrategy = this.findCurrentCustomerScopeStrategy(scopeType);
            if (salePolicyCustomerScopeStrategy == null) {
                return false;
            }
            boolean matched = salePolicyCustomerScopeStrategy.matched(this.customerCode, this.tenantCode, this.salePolicyVo.getSalePolicyCode(), salePolicyCustomerScopeInfos);
            matchedList.add(matched);
            SalePolicyCustomerScopeMergeStrategy.MergeResult mergeResult = this.salePolicyCustomerScopeMergeStrategy.merge((List)matchedList, size, this.salePolicyVo, this.customerCode, matched, scopeType);
            if (mergeResult == SalePolicyCustomerScopeMergeStrategy.MergeResult.FAILED) {
                return false;
            }
            if (mergeResult != SalePolicyCustomerScopeMergeStrategy.MergeResult.SUCCEEDED) continue;
            return true;
        }
        return currentMatched;
    }

    private SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> findCurrentCustomerScopeStrategy(String scopeType) {
        if (CollectionUtils.isEmpty(this.salePolicyCustomerScopeStrategies)) {
            return null;
        }
        for (SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> salePolicyCustomerScopeStrategy : this.salePolicyCustomerScopeStrategies) {
            String currentScopeType = salePolicyCustomerScopeStrategy.getScopeType();
            if (!StringUtils.equals((CharSequence)currentScopeType, (CharSequence)scopeType)) continue;
            return salePolicyCustomerScopeStrategy;
        }
        return null;
    }
}

