/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.sharestrategy;

import com.biz.crm.dms.business.policy.local.context.DefaultCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.CycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.GiftResultInfo;
import com.biz.crm.dms.business.policy.sdk.context.ProductPolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.StepType;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubtotalShareStrategyWithAmountAndNumber
implements SalePolicyExecuteShareStrategy {
    public void share(String customer, SalePolicyVo salePolicy, AbstractPolicyExecuteContext abstractPolicyExecuteContext, AbstractCycleExecuteContext abstractCycleExecuteContext, Set<String> productCodes) {
        DefaultPolicyExecuteContext policyExecuteContext = (DefaultPolicyExecuteContext)abstractPolicyExecuteContext;
        DefaultCycleExecuteContext cycleExecuteContext = (DefaultCycleExecuteContext)abstractCycleExecuteContext;
        if (policyExecuteContext.isKneading()) {
            this.shareForKneading(customer, salePolicy, policyExecuteContext, cycleExecuteContext, productCodes);
        } else {
            this.share(customer, salePolicy, policyExecuteContext, cycleExecuteContext, productCodes);
        }
    }

    private void share(String customer, SalePolicyVo salePolicy, DefaultPolicyExecuteContext policyExecuteContext, DefaultCycleExecuteContext cycleExecuteContext, Set<String> productCodes) {
        CycleStepResult cycleLastStepResult = cycleExecuteContext.findLastStepResult();
        BigDecimal cycleLastSubtotalAmount = cycleLastStepResult.getLastSubtotalAmount();
        BigDecimal cycleLastSurplusSubtotalAmount = cycleLastStepResult.getLastSurplusSubtotalAmount();
        BigDecimal sumLastSubtotal = BigDecimal.ZERO;
        LinkedHashSet newProductPolicyStepResults = Sets.newLinkedHashSet();
        for (String productCode : productCodes) {
            ProductPolicyStepResult productPolicyStepResult = policyExecuteContext.findLastProductStepResultByProductCode(productCode);
            if (productPolicyStepResult == null) continue;
            BigDecimal lastSubtotal = productPolicyStepResult.getLastSubtotal();
            sumLastSubtotal = sumLastSubtotal.add(lastSubtotal);
        }
        BigDecimal differenceSubtotalAmount = sumLastSubtotal.subtract(cycleLastSubtotalAmount);
        BigDecimal deductedDifferenceSubtotalAmount = BigDecimal.ZERO;
        String[] productCodesArray = productCodes.toArray(new String[0]);
        int size = productCodesArray.length;
        for (int index = 0; index < size; ++index) {
            BigDecimal lastSubtotal;
            String productCode = productCodesArray[index];
            ProductPolicyStepResult productPolicyStepResult = policyExecuteContext.findLastProductStepResultByProductCode(productCode);
            if (productPolicyStepResult == null || (lastSubtotal = productPolicyStepResult.getLastSubtotal()).compareTo(BigDecimal.ZERO) != 1) continue;
            ProductPolicyStepResult newProductPolicyStepResult = new ProductPolicyStepResult();
            newProductPolicyStepResult.setStepType(salePolicy.getWholePolicy() != false ? StepType.POLICY : StepType.PRODUCT);
            newProductPolicyStepResult.setSalePolicyCode(salePolicy.getSalePolicyCode());
            newProductPolicyStepResult.setExecuteCode(cycleExecuteContext.getExecuteCode());
            newProductPolicyStepResult.setProductCode(productCode);
            newProductPolicyStepResult.setInitNumbers(productPolicyStepResult.getInitNumbers());
            newProductPolicyStepResult.setInitPrices(productPolicyStepResult.getInitPrices());
            newProductPolicyStepResult.setInitSubtotal(productPolicyStepResult.getInitSubtotal());
            newProductPolicyStepResult.setPreGifts(productPolicyStepResult.getLastGifts());
            newProductPolicyStepResult.setPrePrices(productPolicyStepResult.getLastPrices());
            newProductPolicyStepResult.setPreSubtotal(productPolicyStepResult.getLastSubtotal());
            newProductPolicyStepResult.setPreSurplusTotalAmount(productPolicyStepResult.getLastSurplusTotalAmount());
            newProductPolicyStepResult.setPreSurplusTotalNumber(productPolicyStepResult.getLastSurplusTotalNumber());
            newProductPolicyStepResult.setPreGiftEnjoyedTotalNumber(productPolicyStepResult.getLastGiftEnjoyedTotalNumber());
            newProductPolicyStepResult.setPreGiftEnjoyedTotalAmount(productPolicyStepResult.getLastGiftEnjoyedTotalAmount());
            newProductPolicyStepResult.setLastGifts(productPolicyStepResult.getLastGifts());
            newProductPolicyStepResult.setLastGiftEnjoyedTotalNumber(productPolicyStepResult.getLastGiftEnjoyedTotalNumber());
            newProductPolicyStepResult.setLastGiftEnjoyedTotalAmount(productPolicyStepResult.getLastGiftEnjoyedTotalAmount());
            BigDecimal lastRealSubtotalAmount = null;
            lastRealSubtotalAmount = index + 1 < size ? differenceSubtotalAmount.multiply(lastSubtotal.divide(sumLastSubtotal, 20, RoundingMode.HALF_UP)).setScale(4, RoundingMode.HALF_UP) : differenceSubtotalAmount.subtract(deductedDifferenceSubtotalAmount).setScale(4, RoundingMode.DOWN);
            deductedDifferenceSubtotalAmount = deductedDifferenceSubtotalAmount.add(lastRealSubtotalAmount);
            BigDecimal newLastSubtotal = lastSubtotal.subtract(lastRealSubtotalAmount);
            newProductPolicyStepResult.setLastSubtotal(newLastSubtotal);
            BigDecimal newLastPrices = newLastSubtotal.divide(new BigDecimal(productPolicyStepResult.getInitNumbers()), 20, RoundingMode.HALF_UP).setScale(4, RoundingMode.HALF_UP);
            newProductPolicyStepResult.setLastPrices(newLastPrices);
            BigDecimal productCycleLastRealSubtotalAmount = cycleLastSurplusSubtotalAmount.multiply(lastSubtotal.divide(sumLastSubtotal, 20, RoundingMode.HALF_UP)).setScale(4, RoundingMode.HALF_UP);
            newProductPolicyStepResult.setLastSurplusTotalAmount(productCycleLastRealSubtotalAmount);
            newProductPolicyStepResult.setLastSurplusTotalNumber(Integer.valueOf(0));
            newProductPolicyStepResults.add(newProductPolicyStepResult);
        }
        policyExecuteContext.addPolicyStepResult(newProductPolicyStepResults);
    }

    private void shareForKneading(String customer, SalePolicyVo salePolicy, DefaultPolicyExecuteContext policyExecuteContext, DefaultCycleExecuteContext cycleExecuteContext, Set<String> productCodes) {
        CycleStepResult cycleLastStepResult = cycleExecuteContext.findLastStepResult();
        BigDecimal cycleLastSubtotalAmount = cycleLastStepResult.getLastSubtotalAmount();
        BigDecimal cycleLastSurplusSubtotalAmount = cycleLastStepResult.getLastSurplusSubtotalAmount();
        BigDecimal sumLastSubtotal = BigDecimal.ZERO;
        BigDecimal sumProductLastSubtotal = BigDecimal.ZERO;
        LinkedHashSet newProductPolicyStepResults = Sets.newLinkedHashSet();
        for (String productCode : productCodes) {
            ProductPolicyStepResult productPolicyStepResult = policyExecuteContext.findLastProductStepResultByProductCode(productCode);
            BigDecimal lastSubtotal = productPolicyStepResult.getLastSubtotal();
            sumLastSubtotal = sumLastSubtotal.add(lastSubtotal);
            sumProductLastSubtotal = sumProductLastSubtotal.add(lastSubtotal);
            List lastGifts = productPolicyStepResult.getLastGifts();
            if (CollectionUtils.isEmpty((Collection)lastGifts)) continue;
            for (GiftResultInfo giftResultInfo : lastGifts) {
                sumLastSubtotal = sumLastSubtotal.add(giftResultInfo.getSubtotalAmount());
            }
        }
        BigDecimal differenceSubtotalAmount = sumProductLastSubtotal.subtract(cycleLastSubtotalAmount);
        BigDecimal deductedDifferenceSubtotalAmount = BigDecimal.ZERO;
        String[] productCodesArray = productCodes.toArray(new String[0]);
        int size = productCodesArray.length;
        ProductPolicyStepResult lastNewProductPolicyStepResult = null;
        for (int index = 0; index < size; ++index) {
            ProductPolicyStepResult newProductPolicyStepResult;
            String productCode = productCodesArray[index];
            ProductPolicyStepResult productPolicyStepResult = policyExecuteContext.findLastProductStepResultByProductCode(productCode);
            BigDecimal lastSubtotal = productPolicyStepResult.getLastSubtotal();
            if (lastSubtotal.compareTo(BigDecimal.ZERO) != 1) continue;
            lastNewProductPolicyStepResult = newProductPolicyStepResult = new ProductPolicyStepResult();
            newProductPolicyStepResult.setStepType(salePolicy.getWholePolicy() != false ? StepType.POLICY : StepType.PRODUCT);
            newProductPolicyStepResult.setSalePolicyCode(salePolicy.getSalePolicyCode());
            newProductPolicyStepResult.setExecuteCode(cycleExecuteContext.getExecuteCode());
            newProductPolicyStepResult.setProductCode(productCode);
            newProductPolicyStepResult.setInitNumbers(productPolicyStepResult.getInitNumbers());
            newProductPolicyStepResult.setInitPrices(productPolicyStepResult.getInitPrices());
            newProductPolicyStepResult.setInitSubtotal(productPolicyStepResult.getInitSubtotal());
            List lastGifts = productPolicyStepResult.getLastGifts();
            newProductPolicyStepResult.setPreGifts(lastGifts);
            newProductPolicyStepResult.setPrePrices(productPolicyStepResult.getLastPrices());
            newProductPolicyStepResult.setPreSubtotal(productPolicyStepResult.getLastSubtotal());
            newProductPolicyStepResult.setPreSurplusTotalAmount(productPolicyStepResult.getLastSurplusTotalAmount());
            newProductPolicyStepResult.setPreSurplusTotalNumber(productPolicyStepResult.getLastSurplusTotalNumber());
            newProductPolicyStepResult.setPreGiftEnjoyedTotalNumber(productPolicyStepResult.getLastGiftEnjoyedTotalNumber());
            newProductPolicyStepResult.setPreGiftEnjoyedTotalAmount(productPolicyStepResult.getLastGiftEnjoyedTotalAmount());
            newProductPolicyStepResult.setLastGiftEnjoyedTotalNumber(productPolicyStepResult.getLastGiftEnjoyedTotalNumber());
            newProductPolicyStepResult.setLastGiftEnjoyedTotalAmount(productPolicyStepResult.getLastGiftEnjoyedTotalAmount());
            BigDecimal lastRealDifferenceSubtotalAmount = differenceSubtotalAmount.multiply(lastSubtotal.divide(sumLastSubtotal, 20, RoundingMode.HALF_UP)).setScale(4, RoundingMode.HALF_UP);
            deductedDifferenceSubtotalAmount = deductedDifferenceSubtotalAmount.add(lastRealDifferenceSubtotalAmount);
            BigDecimal newLastSubtotal = lastSubtotal.subtract(lastRealDifferenceSubtotalAmount);
            newProductPolicyStepResult.setLastSubtotal(newLastSubtotal);
            BigDecimal newLastPrices = newLastSubtotal.divide(new BigDecimal(productPolicyStepResult.getInitNumbers()), 20, RoundingMode.HALF_UP).setScale(4, RoundingMode.HALF_UP);
            newProductPolicyStepResult.setLastPrices(newLastPrices);
            BigDecimal productCycleLastRealSubtotalAmount = cycleLastSurplusSubtotalAmount.multiply(lastSubtotal.divide(sumProductLastSubtotal, 20, RoundingMode.HALF_UP)).setScale(4, RoundingMode.HALF_UP);
            newProductPolicyStepResult.setLastSurplusTotalAmount(productCycleLastRealSubtotalAmount);
            newProductPolicyStepResult.setLastSurplusTotalNumber(Integer.valueOf(0));
            if (!CollectionUtils.isEmpty((Collection)lastGifts)) {
                ArrayList newGiftResultInfos = Lists.newArrayList();
                for (int giftIndex = 0; giftIndex < lastGifts.size(); ++giftIndex) {
                    GiftResultInfo lastGift = (GiftResultInfo)lastGifts.get(giftIndex);
                    GiftResultInfo newGiftResultInfo = new GiftResultInfo();
                    newGiftResultInfo.setProductCode(lastGift.getProductCode());
                    newGiftResultInfo.setProductName(lastGift.getProductName());
                    newGiftResultInfo.setQuantity(lastGift.getQuantity());
                    BigDecimal lastSubtotalAmount = lastGift.getSubtotalAmount();
                    BigDecimal gift_lastRealSubtotalAmount = differenceSubtotalAmount.multiply(lastSubtotalAmount.divide(sumLastSubtotal, 20, RoundingMode.HALF_UP)).setScale(4, RoundingMode.HALF_UP);
                    deductedDifferenceSubtotalAmount = deductedDifferenceSubtotalAmount.add(gift_lastRealSubtotalAmount);
                    BigDecimal gift_newLastSubtotal = lastSubtotalAmount.subtract(gift_lastRealSubtotalAmount);
                    newGiftResultInfo.setSubtotalAmount(gift_newLastSubtotal);
                    newGiftResultInfos.add(newGiftResultInfo);
                }
                newProductPolicyStepResult.setLastGifts((List)newGiftResultInfos);
            } else {
                newProductPolicyStepResult.setLastGifts(productPolicyStepResult.getLastGifts());
            }
            newProductPolicyStepResults.add(newProductPolicyStepResult);
        }
        this.correctAccuracy(lastNewProductPolicyStepResult, differenceSubtotalAmount, deductedDifferenceSubtotalAmount);
        policyExecuteContext.addPolicyStepResult(newProductPolicyStepResults);
    }

    private void correctAccuracy(ProductPolicyStepResult lastNewProductPolicyStepResult, BigDecimal differenceSubtotalAmount, BigDecimal deductedDifferenceSubtotalAmount) {
        if (lastNewProductPolicyStepResult != null && differenceSubtotalAmount.compareTo(deductedDifferenceSubtotalAmount) == -1) {
            BigDecimal lastSurplusTotalAmount = lastNewProductPolicyStepResult.getLastSurplusTotalAmount();
            BigDecimal lastSubtotal = lastNewProductPolicyStepResult.getLastSubtotal();
            lastNewProductPolicyStepResult.setLastSurplusTotalAmount(lastSurplusTotalAmount.subtract(new BigDecimal(1.0E-4)).setScale(4, RoundingMode.DOWN));
            lastNewProductPolicyStepResult.setLastSubtotal(lastSubtotal.subtract(new BigDecimal(1.0E-4)).setScale(4, RoundingMode.DOWN));
        } else if (lastNewProductPolicyStepResult != null && differenceSubtotalAmount.compareTo(deductedDifferenceSubtotalAmount) == 1) {
            BigDecimal lastSurplusTotalAmount = lastNewProductPolicyStepResult.getLastSurplusTotalAmount();
            BigDecimal lastSubtotal = lastNewProductPolicyStepResult.getLastSubtotal();
            lastNewProductPolicyStepResult.setLastSurplusTotalAmount(lastSurplusTotalAmount.add(new BigDecimal(1.0E-4)).setScale(4, RoundingMode.DOWN));
            lastNewProductPolicyStepResult.setLastSubtotal(lastSubtotal.add(new BigDecimal(1.0E-4)).setScale(4, RoundingMode.DOWN));
        }
    }
}

