/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.sharestrategy;

import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.context.UnitpriceCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.ProductPolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.StepType;
import com.biz.crm.dms.business.policy.sdk.context.UnitpriceCycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.UnitpriceProduct;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class UnitpriceShareStrategyWithAmountAndNumber
implements SalePolicyExecuteShareStrategy {
    public void share(String customer, SalePolicyVo salePolicy, AbstractPolicyExecuteContext abstractPolicyExecuteContext, AbstractCycleExecuteContext abstractCycleExecuteContext, Set<String> productCodes) {
        DefaultPolicyExecuteContext policyExecuteContext = (DefaultPolicyExecuteContext)abstractPolicyExecuteContext;
        UnitpriceCycleExecuteContext cycleExecuteContext = (UnitpriceCycleExecuteContext)abstractCycleExecuteContext;
        UnitpriceCycleStepResult cycleLastStepResult = cycleExecuteContext.findLastStepResult();
        Set lastProducts = cycleLastStepResult.getLastProducts();
        Map<String, UnitpriceProduct> lastProductMapping = lastProducts.stream().collect(Collectors.toMap(UnitpriceProduct::getProductCode, item -> item));
        LinkedHashSet newProductPolicyStepResults = Sets.newLinkedHashSet();
        for (String productCode : productCodes) {
            BigDecimal productCycleLastRealSubtotalAmount;
            ProductPolicyStepResult productPolicyStepResult = policyExecuteContext.findLastProductStepResultByProductCode(productCode);
            UnitpriceProduct fullminusUnitpriceProduct = lastProductMapping.get(productCode);
            ProductPolicyStepResult newProductPolicyStepResult = new ProductPolicyStepResult();
            newProductPolicyStepResult.setStepType(salePolicy.getWholePolicy() != false ? StepType.POLICY : StepType.PRODUCT);
            newProductPolicyStepResult.setSalePolicyCode(salePolicy.getSalePolicyCode());
            newProductPolicyStepResult.setExecuteCode(abstractCycleExecuteContext.getExecuteCode());
            newProductPolicyStepResult.setProductCode(productCode);
            Integer initNumbers = productPolicyStepResult.getInitNumbers();
            newProductPolicyStepResult.setInitNumbers(initNumbers);
            newProductPolicyStepResult.setInitPrices(productPolicyStepResult.getInitPrices());
            newProductPolicyStepResult.setInitSubtotal(productPolicyStepResult.getInitSubtotal());
            newProductPolicyStepResult.setPreGifts(productPolicyStepResult.getLastGifts());
            BigDecimal prePrices = productPolicyStepResult.getLastPrices();
            newProductPolicyStepResult.setPrePrices(productPolicyStepResult.getLastPrices());
            newProductPolicyStepResult.setPreSubtotal(productPolicyStepResult.getLastSubtotal());
            BigDecimal preSurplusTotalAmount = productPolicyStepResult.getLastSurplusTotalAmount();
            newProductPolicyStepResult.setPreSurplusTotalAmount(preSurplusTotalAmount);
            newProductPolicyStepResult.setPreSurplusTotalNumber(productPolicyStepResult.getLastSurplusTotalNumber());
            newProductPolicyStepResult.setPreGiftEnjoyedTotalNumber(productPolicyStepResult.getLastGiftEnjoyedTotalNumber());
            newProductPolicyStepResult.setPreGiftEnjoyedTotalAmount(productPolicyStepResult.getLastGiftEnjoyedTotalAmount());
            newProductPolicyStepResult.setLastGifts(productPolicyStepResult.getLastGifts());
            newProductPolicyStepResult.setLastGiftEnjoyedTotalNumber(productPolicyStepResult.getLastGiftEnjoyedTotalNumber());
            newProductPolicyStepResult.setLastGiftEnjoyedTotalAmount(productPolicyStepResult.getLastGiftEnjoyedTotalAmount());
            newProductPolicyStepResult.setLastSurplusTotalNumber(Integer.valueOf(0));
            BigDecimal lastPrices = fullminusUnitpriceProduct.getPrices().setScale(4, RoundingMode.HALF_UP);
            newProductPolicyStepResult.setLastPrices(lastPrices);
            BigDecimal newLastSubtotal = new BigDecimal(fullminusUnitpriceProduct.getNumbers()).multiply(lastPrices);
            newProductPolicyStepResult.setLastSubtotal(newLastSubtotal);
            BigDecimal diffPrices = prePrices.subtract(lastPrices);
            if (diffPrices.compareTo(BigDecimal.ZERO) != 1) {
                diffPrices = BigDecimal.ZERO;
            }
            if ((productCycleLastRealSubtotalAmount = preSurplusTotalAmount.subtract(new BigDecimal(initNumbers).multiply(diffPrices).setScale(4, RoundingMode.HALF_UP))).compareTo(BigDecimal.ZERO) != 1) {
                newProductPolicyStepResult.setLastSurplusTotalAmount(BigDecimal.ZERO);
            } else {
                newProductPolicyStepResult.setLastSurplusTotalAmount(productCycleLastRealSubtotalAmount);
            }
            newProductPolicyStepResults.add(newProductPolicyStepResult);
        }
        policyExecuteContext.addPolicyStepResult(newProductPolicyStepResults);
    }
}

