/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.utils;

import com.biz.crm.dms.business.policy.sdk.context.GiftResultInfo;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GiftBuildUtils {
    private GiftBuildUtils() {
    }

    public static Set<GiftResultInfo> buildGiftResult(Collection<GiftResultInfo> sourceGiftResultInfos, Collection<GiftResultInfo> targetGiftResultInfos) {
        GiftResultInfo resultGiftInfo;
        Map<String, GiftResultInfo> sourceGiftResultInfoMappings = sourceGiftResultInfos.stream().collect(Collectors.toMap(GiftResultInfo::getProductCode, item -> item));
        Map<String, GiftResultInfo> targetGiftResultInfoMappings = targetGiftResultInfos.stream().collect(Collectors.toMap(GiftResultInfo::getProductCode, item -> item));
        LinkedHashSet resultGiftInfos = Sets.newLinkedHashSet();
        for (String giftInfoCode : Sets.difference(targetGiftResultInfoMappings.keySet(), sourceGiftResultInfoMappings.keySet())) {
            resultGiftInfo = targetGiftResultInfoMappings.get(giftInfoCode);
            resultGiftInfos.add(resultGiftInfo);
        }
        for (String giftInfoCode : Sets.difference(sourceGiftResultInfoMappings.keySet(), targetGiftResultInfoMappings.keySet())) {
            resultGiftInfo = sourceGiftResultInfoMappings.get(giftInfoCode);
            resultGiftInfos.add(resultGiftInfo);
        }
        for (String giftInfoCode : Sets.intersection(targetGiftResultInfoMappings.keySet(), sourceGiftResultInfoMappings.keySet())) {
            GiftResultInfo lastGiftInfo = sourceGiftResultInfoMappings.get(giftInfoCode);
            GiftResultInfo newGiftInfo = targetGiftResultInfoMappings.get(giftInfoCode);
            Integer resultGiftNumber = lastGiftInfo.getQuantity() + newGiftInfo.getQuantity();
            BigDecimal resultSubtotalAmount = lastGiftInfo.getSubtotalAmount().add(newGiftInfo.getSubtotalAmount());
            GiftResultInfo resultGiftInfo2 = new GiftResultInfo();
            resultGiftInfo2.setProductCode(newGiftInfo.getProductCode());
            resultGiftInfo2.setProductName(newGiftInfo.getProductName());
            resultGiftInfo2.setQuantity(resultGiftNumber);
            resultGiftInfo2.setSubtotalAmount(resultSubtotalAmount);
            resultGiftInfos.add(resultGiftInfo2);
        }
        return resultGiftInfos;
    }
}

