package com.biz.crm.dms.business.policy.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.lang.String;
import java.util.List;

import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 该路径下的http restful地址用来查询当前系统已经支持的在优惠政策管理中，确定客户范围的策略信息
 * @author yinwenjie
 */
@Api(tags = "该路径下的http restful地址用来查询当前系统已经支持的在优惠政策管理中，确定客户范围的策略信息")
@RestController
@RequestMapping("/v1/salepolicies/scopestrategies")
public class CustomerScopeStrategyController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CustomerScopeStrategyController.class);
  
  @Autowired(required = false)
  private List<SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>> salePolicyCustomerScopeStrategies;
  
  /**
   * 查询当前系统已经支持的在优惠政策管理中，确定客户范围的策略信息
   * */
  @ApiOperation(value = "查询当前系统已经支持的在优惠政策管理中，确定客户范围的策略信息")
  @GetMapping(value="/findAll")
  public Result<?> findAll() {
    try {
      JSONArray resutls = new JSONArray();
      for (SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> salePolicyCustomerScopeStrategy : salePolicyCustomerScopeStrategies) {
        String scopeType = salePolicyCustomerScopeStrategy.getScopeType();
        String scopeTypeDesc = salePolicyCustomerScopeStrategy.getScopeTypeDesc();
        JSONObject item = new JSONObject();
        item.put("scopeType", scopeType);
        item.put("scopeTypeDesc", scopeTypeDesc);
        resutls.add(item);
      }
      return Result.ok(resutls);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
  
  @ApiOperation(value = "")
  @GetMapping(value="/findByScopeTypes")
  public Result<?> findByScopeTypes(@RequestParam("scopeType") @ApiParam(name = "scopeType" , required = true , value = "指定的客户范围选择方式类型值（可以传入一个或者多个）") String[] scopeTypes) {
    try {
      JSONArray resutls = new JSONArray();
      for (SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> salePolicyCustomerScopeStrategy : salePolicyCustomerScopeStrategies) {
        String scopeType = salePolicyCustomerScopeStrategy.getScopeType();
        if(!ArrayUtils.contains(scopeTypes , scopeType)) {
          continue;
        }
        String scopeTypeDesc = salePolicyCustomerScopeStrategy.getScopeTypeDesc();
        JSONObject item = new JSONObject();
        item.put("scopeType", scopeType);
        item.put("scopeTypeDesc", scopeTypeDesc);
        resutls.add(item);
      }
      return Result.ok(resutls);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
} 
