package com.biz.crm.dms.business.policy.local.controller;

import java.util.Set;

import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 该路径下的http restful地址用来查询当前系统已经支持的在优惠政策管理中，可支持、可选定的限量政策信息
 * @author yinwenjie
 */
@Api(tags = "该路径下的http restful地址用来查询当前系统已经支持的在优惠政策管理中，可支持、可选定的限量政策信息")
@RestController
@RequestMapping("/v1/salepolicies/limitstrategies")
public class LimitStrategyController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(LimitStrategyController.class);
  @Autowired(required = false)
  private Set<SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>> salePolicyLimitStrategies;
  
  @ApiOperation(value = "")
  @GetMapping(value="/findByLimitStrategyCodes")
  public Result<?> findByLimitStrategyCodes(@RequestParam("limitStrategyCode") @ApiParam(name = "limitStrategyCode" , required = true , value = "指定的限量政策的业务编号（可以传入一个或者多个）") String[] limitStrategyCodes) {
    try {
      JSONArray resutls = new JSONArray();
      for (SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo> salePolicyLimitStrategy : salePolicyLimitStrategies) {
        // 组装那些满足要求的优惠政策执行策略
        String limitStrategyCode = salePolicyLimitStrategy.getLimitStrategyCode();
        if(!ArrayUtils.contains(limitStrategyCodes , limitStrategyCode)) {
          continue;
        }
        String limitStrategyDesc = salePolicyLimitStrategy.getLimitStrategyDesc();
        String expression = salePolicyLimitStrategy.getExpression();
        JSONObject item = new JSONObject();
        item.put("limitStrategyCode", limitStrategyCode);
        item.put("limitStrategyDesc", limitStrategyDesc);
        item.put("expression", expression);
        resutls.add(item);
      }
      return Result.ok(resutls);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}
