package com.biz.crm.dms.business.policy.local.controller;

import java.util.Collection;
import java.util.Set;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 该http层功能提供的接口，都与优惠政策的阶梯执行方式信息有关
 * @author yinwenjie
 */
@Api(tags = "该http层功能提供的接口，都与优惠政策的阶梯执行方式信息有关")
@RestController
@RequestMapping("/v1/salepolicies/cyclerulestrategy")
public class SalePolicyCycleRuleStrategyController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyCycleRuleStrategyController.class);
  /**
   * 现在系统中支持的所有优惠政策注册信息
   */
  @Autowired(required = false)
  private Set<SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>> salePolicyExecuteStrategies;
  @Autowired(required = false)
  private Set<SalePolicyCycleRuleStrategy> salePolicyCycleRuleStrategies;
  @Autowired(required = false)
  private ApplicationContext applicationContext;
  
  @ApiOperation(value = "查询指定的优惠政策执行策略哪些优惠政策阶梯循环策略可以使用(注意是可以使用，而不是正在使用)")
  @GetMapping(value="/findByExecuteStrategyCode")
  public Result<?> findByExecuteStrategyCode(@RequestParam("executeStrategyCode") @ApiParam(name = "executeStrategyCode" , required = true , value = "优惠政策执行策略在系统中唯一的注册编码") String executeStrategyCode) {
    try {
      SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> matchedSalePolicyExecuteStrategy = null;
      for (SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy : salePolicyExecuteStrategies) {
        if(StringUtils.equals(salePolicyExecuteStrategy.getExecuteStrategyCode(), executeStrategyCode)) {
          matchedSalePolicyExecuteStrategy = salePolicyExecuteStrategy;
        }
      }
      Validate.notNull(matchedSalePolicyExecuteStrategy , "优惠政策执行策略注册信息存在设定问题(%s)，请联系技术人员。" , executeStrategyCode);
      // 开始查询这里匹配了executeStrategyCode的优惠政策执行阶梯信息
      Collection<Class<? extends SalePolicyCycleRuleStrategy>> cycleRuleStrategyClasses =  matchedSalePolicyExecuteStrategy.getCycleRuleStrategyClasses();
      Validate.isTrue(!CollectionUtils.isEmpty(cycleRuleStrategyClasses) , "优惠政策执行策略注册信息存在设定问题(%s)，请联系技术人员。" , executeStrategyCode);
      
      JSONArray resutls = new JSONArray();
      for (Class<? extends SalePolicyCycleRuleStrategy> cycleRuleStrategyClass : cycleRuleStrategyClasses) {
        SalePolicyCycleRuleStrategy salePolicyCycleRuleStrategy = applicationContext.getBean(cycleRuleStrategyClass);
        // 组装那些满足要求的优惠政策执行策略
        String cycleRuleCode = salePolicyCycleRuleStrategy.getCycleRuleCode();
        String cycleRuleDesc = salePolicyCycleRuleStrategy.getCycleRuleDesc();
        String cycleRuleExample = matchedSalePolicyExecuteStrategy.getCycleRuleExample(cycleRuleCode);
        JSONObject item = new JSONObject();
        item.put("cycleRuleCode", cycleRuleCode);
        item.put("cycleRuleDesc", cycleRuleDesc);
        item.put("cycleRuleExample", cycleRuleExample);
        resutls.add(item);
      }
      return Result.ok(resutls);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
  
  @ApiOperation(value = "")
  @GetMapping(value="/findByCycleRuleCodes")
  public Result<?> findByCycleRuleCodes(@RequestParam("cycleRuleCode") @ApiParam(name = "cycleRuleCode" , required = true , value = "指定的阶梯循环规则业务编号（可以传入一个或者多个）") String[] cycleRuleCodes) {
    try {
      JSONArray resutls = new JSONArray();
      for (SalePolicyCycleRuleStrategy salePolicyCycleRuleStrategy : salePolicyCycleRuleStrategies) {
        // 组装那些满足要求的优惠政策执行策略
        String cycleRuleCode = salePolicyCycleRuleStrategy.getCycleRuleCode();
        if(!ArrayUtils.contains(cycleRuleCodes , cycleRuleCode)) {
          continue;
        }
        String cycleRuleDesc = salePolicyCycleRuleStrategy.getCycleRuleDesc();
        JSONObject item = new JSONObject();
        item.put("cycleRuleCode", cycleRuleCode);
        item.put("cycleRuleDesc", cycleRuleDesc);
      }
      return Result.ok(resutls);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}
