package com.biz.crm.dms.business.policy.local.cyclestrategy;

import java.util.Set;

import org.springframework.stereotype.Component;

import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 标品默认提供的阶梯循环规则：多阶梯
 * @author yinwenjie
 */
@Component
public class AccumulationCycleRuleStrategy implements SalePolicyCycleRuleStrategy {

  public final static String ACCUMULATION = "accumulation";
  
  @Override
  public String getCycleRuleCode() {
    return AccumulationCycleRuleStrategy.ACCUMULATION;
  }

  @Override
  public String getCycleRuleDesc() {
    return "阶梯叠加循环计算";
  }

  @Override
  public void cycle(AbstractCycleExecuteContext abstractCycleExecuteContext , SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy , SalePolicyVo currentSalePolicy , AbstractSalePolicyExecutorInfo correctAbstractExecutorInfo) {
    /*
     * 循环阶梯处理过程:
     * 从第一个阶梯开始，带入具体的执行策略salePolicyExecuteStrategy进行判定
     *  1、如果当前阶梯一直执行成功，则让这个阶梯一直执行下去，直到这个阶梯不再能够成功
     *  2、如果当前阶梯不再能执行成功，则重置当前阶梯执行上下文中最后一个步进的状态，让其多个属性恢复到初始状态（参加代码中的详细注释）
     *  继续执行下一个阶梯，如此重复，直到最后一个阶梯也不再执行成功
     * */
    
    SalePolicyExecutorVo correctExecutorInfo = (SalePolicyExecutorVo)correctAbstractExecutorInfo;
    Set<SalePolicyExecutorLadderVo> salePolicyExecutorLadders = correctExecutorInfo.getSalePolicyExecutorLadders();
    int maxSize = salePolicyExecutorLadders.size();
    
    int index = 0;
    int times = 1;
    while(true) {
      // 1、=======
      while(salePolicyExecuteStrategy.execute(abstractCycleExecuteContext , index, times, correctExecutorInfo)) {
        times++;
      }
      
      // 2、====== 
      // 如果条件成立，说明还可以继续执行下一个阶梯
      if(index + 1 < maxSize) {
        index++;
        continue;
      } 
      // 其它情况就可以退出了
      return;
    }
  }
}
