package com.biz.crm.dms.business.policy.local.cyclestrategy;

import java.util.Set;

import org.springframework.stereotype.Component;

import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 标品默认提供的阶梯循环规则：多阶梯
 * @author yinwenjie
 */
@Component
public class MultipleCycleRuleStrategy implements SalePolicyCycleRuleStrategy {

  public final static String MULTIPLE = "multiple";
  
  @Override
  public String getCycleRuleCode() {
    return "multiple";
  }

  @Override
  public String getCycleRuleDesc() {
    return "阶梯叠加计算";
  }

  @Override
  public void cycle(AbstractCycleExecuteContext cycleExecuteContext , SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy , SalePolicyVo currentSalePolicy , AbstractSalePolicyExecutorInfo correctAbstractExecutorInfo) {
    /*
     * 循环阶梯处理过程:
     * 从第一个阶梯开始，带入具体的执行策略salePolicyExecuteStrategy进行判定
     * 无论执行判定判定是否成功，都要继续向后执行
     * 只不过执行成功后，times的数值要增加
     * */
    
    SalePolicyExecutorVo correctExecutorInfo = (SalePolicyExecutorVo)correctAbstractExecutorInfo;
    Set<SalePolicyExecutorLadderVo> salePolicyExecutorLadders = correctExecutorInfo.getSalePolicyExecutorLadders();
    for(int index = 0 , times = 1 ; index < salePolicyExecutorLadders.size() ; index++) {
      if(salePolicyExecuteStrategy.execute(cycleExecuteContext , index, times, correctAbstractExecutorInfo)) {
        times++;
      }
    }
  }
}
