package com.biz.crm.dms.business.policy.local.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;

import io.swagger.annotations.ApiModelProperty;

/**
 * 该数据表记录那些已经设定了“不允许叠加”的优惠政策信息
 * TODO 今天不搞了，明天从这里开始
 * @author yinwenjie
 */
@TableName("dms_sale_policy_not_stacking_characteristic")
@Entity
@Table(name = "dms_sale_policy_not_stacking_characteristic" , indexes = @Index(columnList = "tenant_code , sale_policy_code , characteristic_code" , unique = true))
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_not_stacking_characteristic", comment = "该数据表记录那些已经设定了“不允许叠加”的优惠政策信息")
public class NotStackingCharacteristicInfo extends TenantEntity {
  
  private static final long serialVersionUID = 1333843936103039354L;
  
  /**
   * 优惠政策业务编号
   */
  @Column(name = "sale_policy_code" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '优惠政策业务编号'")
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  /**
   * 特性执行编号（对应某个CharacteristicStrategy接口的具体实现类，characteristicCode()方法所返回的值）
   */
  @Column(name = "characteristic_code" , length = 256 , nullable = false, columnDefinition = "VARCHAR(256) COMMENT '特性执行编号'")
  @ApiModelProperty("特性执行编号（对应某个CharacteristicStrategy接口的具体实现类，characteristicCode()方法所返回的值）")
  private String characteristicCode;
  public String getSalePolicyCode() {
    return salePolicyCode;
  }
  public void setSalePolicyCode(String salePolicyCode) {
    this.salePolicyCode = salePolicyCode;
  }
  public String getCharacteristicCode() {
    return characteristicCode;
  }
  public void setCharacteristicCode(String characteristicCode) {
    this.characteristicCode = characteristicCode;
  }  
}
