package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;

import java.util.Date;

/**
 * 促销政策/销售策略 模型，按照租户进行隔离，每个经销商都可以单独进行设置，且跨经销商不可见
 * @author yinwenjie
 */
@Getter
@Setter
@TableName("dms_sale_policy")
@Entity
@Table(name = "dms_sale_policy" , indexes = {@Index(columnList = "tenant_code , sale_policy_code" , unique = true),
                                         @Index(columnList = "tenant_code , effective , valid_end_time , valid_start_time"),
                                         @Index(columnList = "type , templete_code")})
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy", comment = "促销政策，按照租户进行隔离")
public class SalePolicy extends TenantFlagOpEntity {
  private static final long serialVersionUID = -4092545401943050193L;
  /**
   * 营销活动实时状态：1：已完成；2：已失效；3：进行中；4：未开始
   */
  @Transient
  @ApiModelProperty("营销活动实时状态：1：已完成；2：已失效；3：进行中；4：未开始")
  @TableField(exist = false)
  private Integer validType;
  /**
   * 关键的优惠政策类型，匹配不同的SalePolicyRegister接口实现中getType()方法返回的值。在行为层的定义中，type是全系统唯一的
   * @return
   */
  @Column(name = "type" , length = 64 , nullable = false, columnDefinition = "VARCHAR(64) COMMENT '关键的优惠政策类型，匹配不同的SalePolicyRegister接口实现中getType()方法返回的值。在行为层的定义中，type是全系统唯一的'")
  @ApiModelProperty("关键的优惠政策类型，匹配不同的SalePolicyRegister接口实现中getType()方法返回的值。在行为层的定义中，type是全系统唯一的")
  public String type;
  /**
   * 优惠政策使用的促销模板编码，必须有，并且促销模板的type必须和该优惠政策的type一致
   */
  @Column(name = "templete_code" , length = 225 , nullable = false, columnDefinition = "VARCHAR(225) COMMENT '优惠政策使用的促销模板编码，必须有，并且促销模板的type必须和该优惠政策的type一致'")
  @ApiModelProperty("优惠政策使用的促销模板编码，必须有，并且促销模板的type必须和该优惠政策的type一致")
  private String templeteCode;
  /**
   * 促销编码（一旦创建，不允许修改），不输入就是系统生成(按照租户生成)
   */
  @Column(name = "sale_policy_code" , length = 225 , nullable = false, columnDefinition = "VARCHAR(225) COMMENT '促销编码'")
  @ApiModelProperty("促销编码")
  private String salePolicyCode;
  /**
   * 促销名称
   */
  @Column(name = "sale_policy_name" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '促销名称'")
  @ApiModelProperty("促销名称")
  private String salePolicyName;
  /**
   * 可能的有效期起（包括）
   */
  @Column(name = "valid_start_time" , nullable = false, columnDefinition = "Datetime COMMENT '可能的有效期起（包括）'")
  @ApiModelProperty("可能的有效期起（包括）")
  private Date validStartTime;
  /**
   * 可能的有效期止（包括）
   */
  @Column(name = "valid_end_time" , nullable = false, columnDefinition = "Datetime COMMENT '可能的有效期止（包括）'")
  @ApiModelProperty("可能的有效期止（包括）")
  private Date validEndTime;
  /**
   * 优惠政策中文描述信息（允许最大200字）
   */
  @Column(name = "description" , length = 512 , nullable = false, columnDefinition = "VARCHAR(512) COMMENT '优惠政策中文描述信息（允许最大200字）'")
  @ApiModelProperty("优惠政策中文描述信息（允许最大200字）")
  private String description;
  /**
   * 是否有效（ture有效，其他值无效）
   */
  @Column(name = "effective" , nullable = false, columnDefinition = "tinyint(1) COMMENT '是否有效（ture有效，其他值无效）'")
  @ApiModelProperty("是否有效（ture有效，其他值无效）")
  private Boolean effective;
  /**
   * 是否允许政策叠加（默认为false）
   */
  @Column(name = "overlap" , nullable = false, columnDefinition = "tinyint(1) COMMENT '是否允许政策叠加（默认为false）'")
  @ApiModelProperty("是否允许政策叠加（默认为false）")
  private Boolean overlap = false;
  /**
   * 整单优惠还是商品优惠：true：整单优惠；false：商品优惠</br>
   * 该属性也不是创建或修改时传入的，而是通过优惠政策匹配的注册机中的supportProduct返回值决定的
   */
  @Column(name = "whole_policy" , nullable = false, columnDefinition = "tinyint(1) COMMENT '整单优惠还是商品优惠：true：整单优惠；false：商品优惠'")
  @ApiModelProperty("整单优惠还是商品优惠：true：整单优惠；false：商品优惠")
  private Boolean wholePolicy = false;
  /**
   * 由前端页面使用的 本品-优惠规格 信息，对于业务逻辑来说无意义，也不是必须传入的
   */
  @Column(name = "promotional_goods" , nullable = true, length = 64 , columnDefinition = "VARCHAR(64) COMMENT '由前端页面使用的 本品-优惠规格 信息，对于业务逻辑来说无意义，也不是必须传入的'")
  @ApiModelProperty("由前端页面使用的 本品-优惠规格 信息，对于业务逻辑来说无意义，也不是必须传入的")
  private String promotionalGoods;
  
  /**
   * 展示信息信息
   */
  @Column(name = "label" , length = 255 , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '展示信息信息'")
  @ApiModelProperty("展示信息信息")
  private String label;
}