package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import java.util.Set;

/**
 * 促销政策/销售策略 政策明细阶梯映射，如果当前销售政策不允许阶梯，则阶梯映射和销售政策只有一条对应关系信息
 * @author yinwenjie
 */
@TableName("dms_sale_policy_executor_ladder")
@Entity
@Table(name = "dms_sale_policy_executor_ladder")
@Getter
@Setter
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_executor_ladder", comment = "促销政策/销售策略 政策明细阶梯映射")
public class SalePolicyExecutorLadder extends UuidEntity {
  private static final long serialVersionUID = -3941772683050842091L;
  
  /**
   * 关联的执行规则基本信息
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "sale_policy_executor_id" , nullable = false)
  @TableField(exist = false)
  private SalePolicyExecutor salePolicyExecutor;
  
  @Column(name = "sale_policy_executor_id" , length = 255 , nullable = false, insertable =false , updatable =false , columnDefinition = "VARCHAR(255) COMMENT '关联的执行规则基本信息的技术编号'")
  @ApiModelProperty("关联的执行规则基本信息的技术编号(注意，通过JPA时，只能只读)")
  private String salePolicyExecutorId;
  
  /**
   * 优惠政策业务编号
   */
  @Column(name = "sale_policy_code" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '优惠政策业务编号'")
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  /**
   * 阶梯编号，阶梯编号越小，执行优先级越高
   */
  @Column(name = "indexs" , nullable = false , columnDefinition = "INT(11) COMMENT '阶梯编号，阶梯编号越小，执行优先级越高'")
  @ApiModelProperty("阶梯编号，阶梯编号越小，执行优先级越高")
  private Integer indexs;
  /**
   * 促销政策/销售策略对应的促销规则执行变量-设定的K-V值
   */
  @OneToMany(fetch = FetchType.LAZY , mappedBy = "executorLadder")
  @ApiModelProperty("对应设定的各个脚本变量值")
  @TableField(exist = false)
  private Set<SalePolicyExecutorLadderVar> executorLadderVars;
  /**
   * 对应设定的赠品信息
   */
  @OneToMany(fetch = FetchType.LAZY , mappedBy = "executorLadder")
  @ApiModelProperty("对应设定的赠品信息")
  @TableField(exist = false)
  private Set<SalePolicyExecutorLadderGift> executorLadderGifts;
}