package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 促销政策/销售策略 使用的促销类型中 所设定的 政策类型执行器 的各种变量值
 * @author yinwenjie
 */
@TableName("dms_sale_policy_executor_ladder_var")
@Entity
@Table(name = "dms_sale_policy_executor_ladder_var" , indexes = @Index(columnList = "executor_ladder_id , variable_name" , unique = true))
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_executor_ladder_var", comment = "政策类型执行器下的变量信息")
public class SalePolicyExecutorLadderVar extends UuidEntity {
  private static final long serialVersionUID = -3941772683050842091L;
  /**
   * 关联的优惠政策阶梯信息
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "executor_ladder_id" , nullable = false)
  @TableField(exist = false)
  @ApiModelProperty("关联的优惠政策阶梯信息")
  private SalePolicyExecutorLadder executorLadder;
  
  @Column(name = "executor_ladder_id" , length = 255 , nullable = false , insertable = false , updatable = false , columnDefinition = "VARCHAR(255) COMMENT '关联的优惠政策阶梯信息的技术编号'")
  @ApiModelProperty("关联的优惠政策阶梯信息的技术编号(注意，通过JPA时，只能只读)")
  private String executorLadderId;
  /**
   * 变量名（满足一般的变量命名规则）
   */
  @Column(name = "variable_name" , nullable = false , length = 32, columnDefinition = "VARCHAR(32) COMMENT '变量名'")
  @ApiModelProperty("变量名")
  private String variableName;
  /**
   * 变量类型，1：boolean、2：小数；3：整数；4：字符串；
   */
  @Column(name = "variable_type" , nullable = false, columnDefinition = "INT(11) COMMENT '1：boolean、2：小数；3：整数；4：字符串；'")
  @ApiModelProperty("变量类型")
  private Integer variableType;
  /**
   * 变量值
   */
  @Column(name = "variable_value" , nullable = false , length = 64, columnDefinition = "VARCHAR(64) COMMENT '变量值'")
  @ApiModelProperty("变量值")
  private String variableValue;
  public SalePolicyExecutorLadder getExecutorLadder() {
    return executorLadder;
  }
  public void setExecutorLadder(SalePolicyExecutorLadder executorLadder) {
    this.executorLadder = executorLadder;
  }
  public String getExecutorLadderId() {
    return executorLadderId;
  }
  public void setExecutorLadderId(String executorLadderId) {
    this.executorLadderId = executorLadderId;
  }
  public String getVariableName() {
    return variableName;
  }
  public void setVariableName(String variableName) {
    this.variableName = variableName;
  }
  public Integer getVariableType() {
    return variableType;
  }
  public void setVariableType(Integer variableType) {
    this.variableType = variableType;
  }
  public String getVariableValue() {
    return variableValue;
  }
  public void setVariableValue(String variableValue) {
    this.variableValue = variableValue;
  }
  public static long getSerialversionuid() {
    return serialVersionUID;
  }
}