package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 优惠政策-促销商品-本品详情，不包括本品可能一对一的赠品信息（后者以其它方式存储）</br>
 * 另外需要注意，在某个优惠政策下（优惠政策业务编号），根据某个门槛（门槛业务编号），基于某个计算策略（执行策略业务编号），
 * 记录的一个本品或者多个本品信息（本品商品编号），一定是唯一的
 * @author yinwenjie
 */
@TableName("dms_sale_policy_product")
@Entity
@Table(name = "dms_sale_policy_product" , indexes = {@Index(columnList = "tenant_code, sale_policy_code , executor_code , product_code" , unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_product", comment = "优惠政策-促销商品-本品详情")
public class SalePolicyProduct extends TenantEntity {
  private static final long serialVersionUID = 4992957146373602228L;
  /**
   * 优惠政策业务编号
   */
  @Column(name = "sale_policy_code" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '优惠政策业务编号'")
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  /**
   * 关联到优惠政策执行策略业务编码（来自于SalePolicyExecutor实体中的executorCode属性值）
   */
  @Column(name = "executor_code", nullable = false , length = 128 , columnDefinition = "VARCHAR(128) COMMENT '关联到优惠政策执行策略业务编码（来自于SalePolicyExecutor实体中的executorCode属性值）'")
  @ApiModelProperty("关联到优惠政策执行策略业务编码（来自于SalePolicyExecutor实体中的executorCode属性值）")
  private String executorCode;

  /** 商品编码 */
  @Column(name = "product_code", nullable = false , length = 128, columnDefinition = "VARCHAR(128) COMMENT '商品编码'")
  @ApiModelProperty("商品编码")
  private String productCode;
  
  /** 商品名称 */
  @Column(name = "product_name", nullable = false , length = 128, columnDefinition = "VARCHAR(128) COMMENT '商品名称'")
  @ApiModelProperty("商品名称")
  private String productName;

  public String getSalePolicyCode() {
    return salePolicyCode;
  }

  public void setSalePolicyCode(String salePolicyCode) {
    this.salePolicyCode = salePolicyCode;
  }

  public String getExecutorCode() {
    return executorCode;
  }

  public void setExecutorCode(String executorCode) {
    this.executorCode = executorCode;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }
}