package com.biz.crm.dms.business.policy.local.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 优惠政策执行流水中的记录的那些被排除优惠执行过程的优惠信息，以及被排除的原因。</br>
 * @author yinwenjie
 */
@Getter
@Setter
@TableName("dms_sale_policy_record_exclude_policy")
@Entity
@Table(name = "dms_sale_policy_record_exclude_policy" , indexes = @Index(columnList = "record_id , policy_code" , unique = true))
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_record_exclude_policy", comment = "优惠政策执行流水中的初始化商品可能被人为指定的优惠政策信息。")
public class SalePolicyRecordExcludePolicy extends UuidEntity {
  private static final long serialVersionUID = 8311354749762741003L;
  /**
   * 对应的促销政策/优惠政策优惠流水
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "record_id", nullable = false)
  @TableField(exist = false)
  @ApiModelProperty("对应的促销政策/优惠政策优惠流水")
  @JsonIgnore
  private SalePolicyRecord salePolicyRecord;
  /**
   * 在JPA中只读性质的“促销政策/优惠政策使用记录ID”技术编码
   */
  @Column(name = "record_id", length = 255, nullable = false, insertable = false, updatable = false)
  @ApiModelProperty("对应的促销政策/优惠政策优惠流水")
  private String recordId;
  /**
   * 进行优惠政策执行/预执行时，可以为某个本品指定他要参加的优惠政策（的业务编码）
   */
  @Column(name = "policy_code", length = 225, nullable = false, columnDefinition = "VARCHAR(225) COMMENT '进行优惠政策执行/预执行时，可以为某个本品指定他要参加的优惠政策（的业务编码）'")
  @ApiModelProperty("进行优惠政策执行/预执行时，可以为某个本品指定他要参加的优惠政策（的业务编码）")
  private String policyCode;
  /**
   * 该优惠政策被排除到优惠执行过程的原因
   */
  @Column(name = "excluded_msg", length = 512, nullable = false, columnDefinition = "VARCHAR(512) COMMENT '该优惠政策被排除到优惠执行过程的原因'")
  @ApiModelProperty("该优惠政策被排除到优惠执行过程的原因")
  private String excludedMsg;
}
