package com.biz.crm.dms.business.policy.local.entity;

import java.math.BigDecimal;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 优惠政策执行流水中的商品明细
 * @author yinwenjie
 */
@Getter
@Setter
@TableName("dms_sale_policy_record_product")
@Entity
@Table(name = "dms_sale_policy_record_product")
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_record_product", comment = "优惠政策执行流水中的商品明细")
public class SalePolicyRecordProduct extends UuidEntity {
  private static final long serialVersionUID = -4207833793610083131L;
  /**
   * 对应的促销政策/优惠政策优惠流水
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "record_id", nullable = false)
  @TableField(exist = false)
  @ApiModelProperty("对应的促销政策/优惠政策优惠流水")
  @JsonIgnore
  private SalePolicyRecord salePolicyRecord;
  /**
   * 在JPA中只读性质的“促销政策/优惠政策使用记录ID”技术编码
   */
  @Column(name = "record_id", length = 255, nullable = false, insertable = false, updatable = false)
  @ApiModelProperty("对应的促销政策/优惠政策优惠流水")
  private String recordId;
  /**
   * 票据行项目号（由外部单据传入，可以是行数号，也可以是单据明细项的id，只要能说明是单据上的哪一行具体商品就行）
   */
  @Column(name = "bill_item_code", length = 255, nullable = false, columnDefinition = "VARCHAR(255) COMMENT '票据行项目号（由外部单据传入，可以是行数号，也可以是单据明细项的id，只要能说明是单据上的哪一行具体商品就行）'")
  @ApiModelProperty("票据行项目号")
  private String billItemCode;
  /**
   * 促销编码（一旦创建，不允许修改），不输入就是系统生成(按照租户生成)</br>
   * 注意，促销/优惠编码可以为null，因为可能为INIT性质的流水,这是填入空字符串就行
   */
  @Column(name = "sale_policy_code" , length = 225 , nullable = false, columnDefinition = "VARCHAR(225) COMMENT '促销编码'")
  @ApiModelProperty("促销编码")
  private String salePolicyCode;
  /**
   * 该优惠政策涉及的具体优惠政策执行器
   */
  @Column(name = "execute_code", length = 255, nullable = false, columnDefinition = "VARCHAR(255) COMMENT '该优惠政策涉及的具体优惠政策执行器'")
  @ApiModelProperty("该优惠政策涉及的具体优惠政策执行器")
  private String executeCode;
  /**
   * 商品编码
   */
  @Column(name = "product_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '商品编码'")
  @ApiModelProperty("商品编码")
  private String productCode;
  /**
   * 商品名称
   */
  @Column(name = "product_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT '商品名称'")
  @ApiModelProperty("商品名称")
  private String productName;
  /**
   * 促销流水排序，越先进行的优惠政策，排序号越小，排序号从0开始(排位为0的一般是INIT性质的流水)
   */
  @Column(name = "sorted" , length = 11 , nullable = false, columnDefinition = "INT(11) COMMENT '促销流水排序，越先进行的优惠政策，排序号越小，排序号从0开始'")
  @ApiModelProperty("促销流水排序，越先进行的优惠政策，排序号越小，排序号从0开始")
  private Integer sorted;
  /**
   * 优惠步进类型(即这次步进是因为什么原因产生的);INIT:初始化；PRODUCT：商品优惠；POLICY：整体优惠
   */
  @Column(name = "step_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) COMMENT '优惠步进类型(即这次步进是因为什么原因产生的)'")
  @ApiModelProperty("优惠步进类型(即这次步进是因为什么原因产生的);INIT:初始化；PRODUCT：商品优惠；POLICY：整体优惠")
  private String stepType;
  
  // ====== 以下是商品的初始化维度的信息
  /**
   * 商品初始化的单价信息
   */
  @Column(name = "init_prices" , nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT '商品初始化的单价信息'")
  @ApiModelProperty("商品初始化的单价信息")
  private BigDecimal initPrices;
  /**
   * 商品初始化的数量信息
   */
  @Column(name = "init_numbers" , nullable = false , length = 11, columnDefinition = "INT(11) COMMENT '商品初始化的数量信息'")
  @ApiModelProperty("商品初始化的数量信息")
  private Integer initNumbers;
  /**
   * 商品初始化的小计价格信息
   */
  @Column(name = "init_subtotal" , nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT '商品初始化的小计价格信息'")
  @ApiModelProperty("商品初始化的小计价格信息")
  private BigDecimal initSubtotal;

  // ====== 以下是商品优惠政策执行后的信息
  /**
   * 商品在执行本次优惠政策后，商品的单价
   */
  @Column(name = "last_prices" , nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT '商品在执行本次优惠政策后，商品的单价'")
  @ApiModelProperty("商品在执行本次优惠政策后，商品的单价")
  private BigDecimal lastPrices;
  /**
   * 商品在执行本次优惠政策后，商品的小计价格
   */
  @Column(name = "last_subtotal" , nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT '商品在执行本次优惠政策后，商品的小计价格'")
  @ApiModelProperty("商品在执行本次优惠政策后，商品的小计价格")
  private BigDecimal lastSubtotal;
  /**
   * 商品在执行本次优惠政策后，还有多少商品数量没有享受优惠
   */
  @ApiModelProperty("商品在执行本次优惠政策后，还有多少商品数量没有享受优惠")
  @Column(name = "last_surplus_total_number" , nullable = false, columnDefinition = "INT(11) COMMENT '商品在执行本次优惠政策后，还有多少小计价格没有享受优惠'")
  private Integer lastSurplusTotalNumber;
  /**
   * 商品在执行本次优惠政策后，还有多少小计价格没有享受优惠
   */
  @ApiModelProperty("商品在执行本次优惠政策后，还有多少小计价格没有享受优惠")
  @Column(name = "last_surplus_total_amount" , nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT '商品在执行本次优惠政策后，还有多少小计价格没有享受优惠'")
  private BigDecimal lastSurplusTotalAmount;
  /**
   * 商品在执行本次优惠政策后，已享受的赠品数量优惠</p>
   * 一定要看清楚，这里是已享受的，而不是Surplus那种还没有享受的
   */
  @ApiModelProperty("商品在执行本次优惠政策后，已享受的赠品数量优惠。一定要看清楚，这里是已享受的，而不是Surplus那种还没有享受的")
  @Column(name = "last_gift_enjoyed_total_number" , nullable = false, columnDefinition = "INT(11) COMMENT '商品在执行本次优惠政策后，已享受的赠品数量优惠'")
  private Integer lastGiftEnjoyedTotalNumber;
  /**
   * 商品在执行本次优惠政策后，已享受的赠品金额优惠</p>
   * 一定要看清楚，这里是已享受的，而不是Surplus那种还没有享受的
   */
  @ApiModelProperty("商品在执行本次优惠政策后，已享受的赠品金额优惠。一定要看清楚，这里是已享受的，而不是Surplus那种还没有享受的")
  @Column(name = "last_gift_enjoyed_total_amount" , nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT '商品在执行本次优惠政策后，已享受的赠品金额优惠'")
  private BigDecimal lastGiftEnjoyedTotalAmount;
  /**
   * 本次商品优惠步进中，相对于上一个步进该本品的小计金额减少小计价格
   */
  @ApiModelProperty("本次商品优惠步进中，相对于上一个步进该本品的小计金额减少小计价格")
  @Column(name = "diff_last_subtotal" , nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT '本次商品优惠步进中，相对于上一个步进该本品的小计金额减少小计价格'")
  private BigDecimal diffLastSubtotal;
  /**
   * 本次商品优惠步进中，相对于上一个步进，该本品有多少数量参与了优惠
   */
  @ApiModelProperty("本次商品优惠步进中，相对于上一个步进，该本品有多少数量参与了优惠")
  @Column(name = "diff_surplus_total_number" , nullable = false, columnDefinition = "INT(11) COMMENT '本次商品优惠步进中，相对于上一个步进，该本品有多少数量参与了优惠'")
  private Integer diffSurplusTotalNumber;
  /**
   * 本次商品优惠步进中，相对于上一个步进，该本品有多少小计金额参与了优惠
   */
  @ApiModelProperty("本次商品优惠步进中，相对于上一个步进，该本品有多少小计金额参与了优惠")
  @Column(name = "diff_surplus_total_amount" , nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT '本次商品优惠步进中，相对于上一个步进，该本品有多少小计金额参与了优惠'")
  private BigDecimal diffSurplusTotalAmount;
  
  @ApiModelProperty("本次商品优惠步进中，相对于上一个步进，该本品享受了多少赠品数量的优惠")
  @Column(name = "diff_gift_enjoyed_total_number" , nullable = false, columnDefinition = "INT(11) COMMENT '本次商品优惠步进中，相对于上一个步进，该本品享受了多少赠品数量的优惠'")
  private Integer diffGiftEnjoyedTotalNumber;
  
  @ApiModelProperty("本次商品优惠步进中，相对于上一个步进，该本品享受了多少赠品金额的优惠")
  @Column(name = "diff_gift_enjoyed_total_amount" , nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT '本次商品优惠步进中，相对于上一个步进，该本品享受了多少赠品金额的优惠'")
  private BigDecimal diffGiftEnjoyedTotalAmount;
  /**
   * 促销政策/优惠政策中赠品流水记录
   */
  @TableField(exist = false)
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "salePolicyRecordProduct")
  @ApiModelProperty("促销政策/优惠政策中赠品流水记录")
  private Set<SalePolicyRecordGift> salePolicyRecordGifts;
}
