package com.biz.crm.dms.business.policy.local.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 优惠政策执行流水中的初始化商品可能被人为指定的优惠政策信息。</br>
 * 这种场景一般发生在认为指定了某个商品只能参与某个或某几个优惠政策
 * @author yinwenjie
 */
@Getter
@Setter
@TableName("dms_sale_policy_record_product_selected_policy")
@Entity
@Table(name = "dms_sale_policy_record_product_selected_policy" , indexes = @Index(columnList = "record_id , product_code" , unique = true))
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_record_product_selected_policy", comment = "优惠政策执行流水中的初始化商品可能被人为指定的优惠政策信息。")
public class SalePolicyRecordProductSelectedPolicy extends UuidEntity {
  private static final long serialVersionUID = 8311354749762741003L;
  /**
   * 对应的促销政策/优惠政策优惠流水
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "record_id", nullable = false)
  @TableField(exist = false)
  @ApiModelProperty("对应的促销政策/优惠政策优惠流水")
  @JsonIgnore
  private SalePolicyRecord salePolicyRecord;
  /**
   * 在JPA中只读性质的“促销政策/优惠政策使用记录ID”技术编码
   */
  @Column(name = "record_id", length = 255, nullable = false, insertable = false, updatable = false)
  @ApiModelProperty("对应的促销政策/优惠政策优惠流水")
  private String recordId;
  /**
   * 商品编码
   */
  @Column(name = "product_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '商品编码'")
  @ApiModelProperty("商品编码")
  private String productCode;
  /**
   * 进行优惠政策执行/预执行时，可以为某个本品指定他要参加的优惠政策（的业务编码）,多个以“,”进行分割
   */
  @Column(name = "selected_policy_codes", length = 512, nullable = false, columnDefinition = "VARCHAR(512) COMMENT '进行优惠政策执行/预执行时，可以为某个本品指定他要参加的优惠政策（的业务编码）,多个以“,”进行分割'")
  @ApiModelProperty("进行优惠政策执行/预执行时，可以为某个本品指定他要参加的优惠政策（的业务编码）,多个以“,”进行分割")
  private String selectedPolicyCodes;
}
