package com.biz.crm.dms.business.policy.local.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 优惠政策执行流水中的记录的那些优惠政策以及优惠执行器执行的先后顺序。</br>
 * @author yinwenjie
 */
@Getter
@Setter
@TableName("dms_sale_policy_record_step_policy")
@Entity
@Table(name = "dms_sale_policy_record_step_policy" , indexes = @Index(columnList = "record_id , sale_policy_code , execute_code " , unique = true))
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_record_step_policy", comment = "优惠政策执行流水中的初始化商品可能被人为指定的优惠政策信息。")
public class SalePolicyRecordStepPolicy extends UuidEntity {
  private static final long serialVersionUID = 8311354749762741003L;
  /**
   * 对应的促销政策/优惠政策优惠流水
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "record_id", nullable = false)
  @TableField(exist = false)
  @ApiModelProperty("对应的促销政策/优惠政策优惠流水")
  @JsonIgnore
  private SalePolicyRecord salePolicyRecord;
  /**
   * 在JPA中只读性质的“促销政策/优惠政策使用记录ID”技术编码
   */
  @Column(name = "record_id", length = 255, nullable = false, insertable = false, updatable = false)
  @ApiModelProperty("对应的促销政策/优惠政策优惠流水")
  private String recordId;
  /**
   * 执行顺序，数值越小说明这个优惠政策越先执行
   */
  @Column(name = "sorted", nullable = false, columnDefinition = "INT(11) COMMENT '执行顺序，数值越小说明这个优惠政策越先执行'")
  @ApiModelProperty("执行顺序，数值越小说明这个优惠政策越先执行")
  private Integer sorted;
  /**
   * 促销编码（一旦创建，不允许修改），不输入就是系统生成(按照租户生成)</br>
   * 注意，促销/优惠编码可以为null，因为可能为INIT性质的流水，这是填入空字符串就行
   */
  @Column(name = "sale_policy_code", length = 225, nullable = false, columnDefinition = "VARCHAR(225) COMMENT '进行优惠政策执行/预执行时，可以为某个本品指定他要参加的优惠政策（的业务编码）'")
  @ApiModelProperty("促销编码")
  private String salePolicyCode;
  /**
   * 该优惠政策涉及的具体优惠政策执行器
   */
  @Column(name = "execute_code", length = 255, nullable = false, columnDefinition = "VARCHAR(255) COMMENT '该优惠政策涉及的具体优惠政策执行器'")
  @ApiModelProperty("该优惠政策被排除到优惠执行过程的原因")
  private String executeCode;
  /**
   * 优惠步进类型(即这次步进是因为什么原因产生的);INIT:初始化；PRODUCT：商品优惠；POLICY：整体优惠
   */
  @Column(name = "step_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) COMMENT '优惠步进类型(即这次步进是因为什么原因产生的)'")
  @ApiModelProperty("优惠步进类型(即这次步进是因为什么原因产生的);INIT:初始化；PRODUCT：商品优惠；POLICY：整体优惠")
  private String stepType;
}
