package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 以圈定某种范围类型的方式，确认特定优惠政策的适用客户范围（标品中支持经销商、渠道和组织机构三种圈定方式）
 * @author yinwenjie
 */
@TableName("dms_sale_policy_scope_info")
@Entity
@Table(name = "dms_sale_policy_scope_info" , indexes = {@Index(columnList = "sale_policy_code")})
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_scope_info", comment = "以圈定某种范围类型的方式，确认特定优惠政策的适用客户范围（标品中支持经销商、渠道和组织机构三种圈定方式")
public class SalePolicyScopeInfo extends TenantEntity {
  private static final long serialVersionUID = -9161995830090988994L;

  /**
   * 优惠政策业务编号
   */
  @Column(name = "sale_policy_code" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '优惠政策业务编号'")
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  
  @Column(name = "customer_scope_type" , length = 64 , nullable = false, columnDefinition = "VARCHAR(64) COMMENT '这个属性将返回这个具体客户范围控制策略的识别类型号'")
  @ApiModelProperty("这个属性将返回这个具体客户范围控制策略的识别类型号，channelForSalePolicy：按渠道选择；distributorForSalePolicy：按经销商选择；orgForSalePolicyCustomer：按组织机构选择")
  private String customerScopeType;
  
  @Column(name = "selection_method" , length = 64 , nullable = false, columnDefinition = "VARCHAR(64) COMMENT '选定方式：include：包括；exclude：排除'")
  @ApiModelProperty("选定方式：include：包括；exclude：排除")
  private String selectionMethod;
  
  @Column(name = "code" , length = 255 , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '被选定或者被排除的业务编号'")
  @ApiModelProperty("被选定或者被排除的业务编号")
  private String code;
  
  @Column(name = "name" , length = 255 , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '被选定或者被排除的业务名称'")
  @ApiModelProperty("被选定或者被排除的业务名称")
  private String name;

  @ApiModelProperty(name="state" , value = "设定状态：0：禁用/废弃；1：正常")
  @Column(name="state" ,  nullable = false , columnDefinition = "int(11) COMMENT '设定状态：0：禁用/废弃；1：正常'")
  private Integer state = 1;
  
  public String getSalePolicyCode() {
    return salePolicyCode;
  }

  public void setSalePolicyCode(String salePolicyCode) {
    this.salePolicyCode = salePolicyCode;
  }

  public String getCustomerScopeType() {
    return customerScopeType;
  }

  public void setCustomerScopeType(String customerScopeType) {
    this.customerScopeType = customerScopeType;
  }

  public String getSelectionMethod() {
    return selectionMethod;
  }

  public void setSelectionMethod(String selectionMethod) {
    this.selectionMethod = selectionMethod;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }
}
