package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
/**
 * 促销政策/销售策略模板信息，按照租户进行隔离
 * @author yinwenjie
 */
@Getter
@Setter
@TableName("dms_sale_policy_templete")
@Entity
@Table(name = "dms_sale_policy_templete" , indexes = {@Index(columnList = "tenant_code , templete_code" , unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_templete", comment = "促销政策，按照租户进行隔离")
public class SalePolicyTemplete extends TenantFlagOpEntity {
  private static final long serialVersionUID = -4092545401943050193L;
  /**
   * 关键的优惠政策模板类型，关键的优惠政策类型，匹配不同的SalePolicyTempleteRegister接口实现中getType()方法返回的值
   * @return
   */
  @Column(name = "type" , length = 64 , nullable = false, columnDefinition = "VARCHAR(64) COMMENT '关键的优惠政策模板类型，关键的优惠政策类型，匹配不同的SalePolicyTempleteRegister接口实现中getType()方法返回的值'")
  @ApiModelProperty("关键的优惠政策模板类型，关键的优惠政策类型，匹配不同的SalePolicyTempleteRegister接口实现中getType()方法返回的值")
  private String type;
  /**
   * 促销编码（一旦创建，不允许修改），不输入就是系统生成(按照租户生成)
   */
  @Column(name = "templete_code" , length = 225 , nullable = false, columnDefinition = "VARCHAR(225) COMMENT '促销模板编码'")
  @ApiModelProperty("促销编码")
  private String templeteCode;
  /**
   * 促销名称
   */
  @Column(name = "templete_name" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '促销模板名称'")
  @ApiModelProperty("促销名称")
  private String templeteName;
  /**
   * 该优惠政策模板是否支持关联预算信息
   */
  @Column(name = "support_budget" , nullable = false, columnDefinition = "tinyint(1) COMMENT '该优惠政策模板是否支持关联预算信息'")
  @ApiModelProperty("该优惠政策模板是否支持关联预算信息: true:支持；false：不支持")
  private Boolean supportBudget = false;
  
  /**
   * 该优惠政策已经绑定的可使用的执行特性判定信息
   */
  @Column(name = "binding_characteristic_strategy_codes" , length = 1024 , nullable = false, columnDefinition = "VARCHAR(512) COMMENT '该优惠政策已经绑定的可使用的执行特性判定信息，多个以“,”分割'")
  @ApiModelProperty("该优惠政策已经绑定的可使用的执行特性判定信息（业务编码），多个以“,”分割")
  private String bindingCharacteristicStrategyCodes;
  
  /**
   * 该优惠政策模板已绑定的商品选择方式（该值和是否支持商品选择，存在因果关系）
   * 多个以“,”分割
   */
  @Column(name = "binding_product_selection_methods" , length = 1024 , nullable = true, columnDefinition = "VARCHAR(512) COMMENT '该优惠政策模板已绑定的商品选择方式（该值和是否支持商品选择，存在因果关系），多个以“,”分割'")
  @ApiModelProperty("该优惠政策已经绑定的可使用的执行政策信息（业务编码），多个以“,”分割")
  private String bindingProductSelectionMethods;
  /**
   * 该优惠政策已经绑定的可使用的限量执行规则，对应SalePolicyLimitStrategy接口getLimitStrategyCode()方法返回的具体值。
   * 多个以“,”分割
   */
  @Column(name = "binding_limit_strategy_codes" , length = 1024 , nullable = true, columnDefinition = "VARCHAR(512) COMMENT '该优惠政策已经绑定的可使用的限量执行规则，多个以“,”分割'")
  @ApiModelProperty("该优惠政策已经绑定的可使用的限量执行规则，多个以“,”分割")
  private String bindingLimitStrategyCodes;
  /**
   * 该优惠政策已经绑定的可使用的客户选择方式规则，对应SalePolicyCustomerScopeStrategy接口getScopeType()方法返回的具体值.
   * 多个以“,”分割
   */
  @Column(name = "binding_scope_types" , length = 1024 , nullable = true, columnDefinition = "VARCHAR(512) COMMENT '该优惠政策已经绑定的可使用的客户选择方式规则，多个以“,”分割'")
  @ApiModelProperty("该优惠政策已经绑定的可使用的客户选择方式规则，多个以“,”分割")
  private String bindingScopeTypes;
  /**
   * 该优惠政策已经绑定的可使用的执行政策信息（业务编码），和执行政策信息支持的阶梯策略。
   */
  @TableField(exist = false)
  @OneToMany(fetch = FetchType.LAZY , mappedBy = "salePolicyTemplete")
  @ApiModelProperty("该优惠政策已经绑定的可使用的执行政策信息（业务编码），和执行政策信息支持的阶梯策略。")
  private Set<SalePolicyTempleteExecuteStrategy> bindingExecuteStraties;
}