package com.biz.crm.dms.business.policy.local.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity; 

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 促销政策/销售策略模板已设定的执行策略明细
 * @author yinwenjie
 */
@Getter
@Setter
@TableName("dms_sale_policy_templete_execute_strategy")
@Entity
@Table(name = "dms_sale_policy_templete_execute_strategy" , indexes = @Index(columnList = "templete_id , binding_execute_strategy_code" , unique = true))
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_templete_execute_strategy", comment = "促销政策/销售策略模板已设定的执行策略明细")
public class SalePolicyTempleteExecuteStrategy extends UuidEntity {
  private static final long serialVersionUID = 1586007749759480546L;
  /**
   * 对应的促销政策/优惠政策优惠流水
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "templete_id", nullable = false)
  @TableField(exist = false)
  @ApiModelProperty("促销政策/销售策略模板")
  private SalePolicyTemplete salePolicyTemplete;
  /**
   * 在JPA中只读性质的“促销政策/优惠政策模板ID”技术编码
   */
  @Column(name = "templete_id", length = 255, nullable = false, insertable = false, updatable = false)
  @ApiModelProperty("对应的促销政策/优惠政策优惠流水")
  private String templeteId;
  /**
   * 已绑定的优惠政策执行策略的编号
   */
  @Column(name = "binding_execute_strategy_code", length = 255, nullable = false, columnDefinition = "VARCHAR(255) COMMENT '已绑定的优惠政策执行策略的编号'")
  @ApiModelProperty("已绑定的优惠政策执行策略的编号")
  private String bindingExecuteStrategyCode;
  /**
   * 该模板下，这个执行策略所支持的执行阶梯，多个以“,”分割
   */
  @Column(name = "binding_execute_ladders" , length = 225 , nullable = false, columnDefinition = "VARCHAR(225) COMMENT '该模板下，这个执行策略所支持的执行阶梯，多个以“,”分割'")
  @ApiModelProperty("该模板下，这个执行策略所支持的执行阶梯，多个以“,”分割")
  private String bindingExecuteLadders;
}
