package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Set;

/**
 * 促销政策/销售策略 商品促销门槛，也就是需求设计中“只有多个商品的总价达到1000，才能进行促销”的需求点</p>
 * 
 * 适合标品中的商品满减、商品满赠、商品特价等优惠政策模式使用
 * @author yinwenjie
 */
@TableName("dms_sale_policy_threshold")
@Entity
@Table(name = "dms_sale_policy_threshold" , indexes = {@Index(columnList = "sale_policy_code , tenant_code" , unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_threshold", comment = "促销政策，按照租户进行隔离")
public class SalePolicyThreshold extends  TenantEntity {
  private static final long serialVersionUID = 4209232312766796134L;
  
  /**
   * 优惠政策业务编号
   */
  @Column(name = "sale_policy_code" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '优惠政策业务编号'")
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  /**
   * 产品组合的阈值单位（ 1：总金额；2：数量）
   */
  @Column(name = "compose_unit"  , nullable = true, columnDefinition = "INT(11) COMMENT '产品组合的阈值单位（ 1：总金额；2：数量）'")
  @ApiModelProperty("产品组合的阈值单位（ 1：总金额；2：数量）")
  private Integer composeUnit;
  /**
   * 产品组合的阈值数量(默认为0)
   */
  @Column(name = "compose_number" , nullable = false, columnDefinition = "INT(11) COMMENT '产品组合的阈值数量(默认为0)'")
  @ApiModelProperty("商品优惠门槛的总阈值数量(默认为0)")
  private Integer composeNumber = 0;
  /**
   * 门槛详情信息<br>
   * （不一定是includeType==2且includeNumber==0时，才会有这些信息）。</br>
   * 只要某个商品需要必须包括或者存在最低限价，就有这个明细信息
   */
  @TableField(exist = false)
  @ApiModelProperty(name="thresholdDetails" , value="门槛详情信息" , required=false , hidden=true)
  @OneToMany(mappedBy = "salePolicyThreshold" , fetch = FetchType.LAZY)
  private Set<SalePolicyThresholdDetail> thresholdDetails;
  public String getSalePolicyCode() {
    return salePolicyCode;
  }
  public void setSalePolicyCode(String salePolicyCode) {
    this.salePolicyCode = salePolicyCode;
  }
  public Integer getComposeUnit() {
    return composeUnit;
  }
  public void setComposeUnit(Integer composeUnit) {
    this.composeUnit = composeUnit;
  }
  public Integer getComposeNumber() {
    return composeNumber;
  }
  public void setComposeNumber(Integer composeNumber) {
    this.composeNumber = composeNumber;
  }
  public Set<SalePolicyThresholdDetail> getThresholdDetails() {
    return thresholdDetails;
  }
  public void setThresholdDetails(Set<SalePolicyThresholdDetail> thresholdDetails) {
    this.thresholdDetails = thresholdDetails;
  }
}
