package com.biz.crm.dms.business.policy.local.executestrategy;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;

import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVarVo;
import com.google.common.collect.Maps;

/**
 * TODO 注释要进行完善
 * @author yinwenjie
 */
public abstract class AbstractExecuteStrategy {
  /**
   * 在本次执行前，计入策略的自设定控件的传值
   * @param vars 本次计算
   * @param params
   */
  protected Map<String, Object> mappingVariableValues( Set<SalePolicyExecutorLadderVarVo> vars) {
    Map<String, Object> params = Maps.newLinkedHashMap();
    for (SalePolicyExecutorLadderVarVo var : vars) {
      String variableName = var.getVariableName();
      Integer variableType = var.getVariableType();
      String variableValue = var.getVariableValue();
      // TODO 这里对值的判定还要再精确
      switch (variableType) {
        // boolean
        case 1:
          Boolean valueBoolean = Boolean.valueOf(variableValue);
          params.put(variableName, valueBoolean);
          break;
        // 小数
        case 2:
          BigDecimal valueString = BigDecimal.valueOf(Float.valueOf(variableValue));
          params.put(variableName, valueString);
          break;
        // 整数
        case 3:
          Integer valueInteger = Integer.valueOf(variableValue);
          params.put(variableName, valueInteger);
          break;
        // 字符串
        case 4:
          params.put(variableName, variableValue);
          break;
        default:
          throw new IllegalArgumentException("策略执行过程中，发现未知类型的参数！！");
      }
    }
    return params;
  }
}
