package com.biz.crm.dms.business.policy.local.init;

import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import com.biz.crm.dms.business.policy.local.notifier.CacheRedisMessageForSalePolicyGlobalListenerImpl;
import com.biz.crm.dms.business.policy.local.service.task.SalePolicyCacheLoadingService;

/**
 * 在应用程序启动完成后，订阅redis的监听，以便资源桶中任何进程的优惠政策缓存发生变化后（优惠政策全局变化）
 * 本进程能知晓这个变化，并进行相关处理
 * @author yinwenjie
 */
@Component
public class CacheRedisMessageStartupRunnerForSalePolicyGlobal implements ApplicationListener<ApplicationReadyEvent> {

  @Autowired(required = false)
  private Redisson redisson;
  @Autowired(required = false)
  private CacheRedisMessageForSalePolicyGlobalListenerImpl cacheRedisMessageForSalePolicyGlobalListener;
  
  @Override
  public void onApplicationEvent(ApplicationReadyEvent event) { 
    // 此处是功能按钮模块的redis订阅 
    RTopic topicForTenantRole = this.redisson.getTopic(SalePolicyCacheLoadingService.SALE_POLICY_NOTIFY);
    topicForTenantRole.addListener(String.class, this.cacheRedisMessageForSalePolicyGlobalListener);
  } 
} 