package com.biz.crm.dms.business.policy.local.limitstrategy;

import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecord;
import com.biz.crm.dms.business.policy.local.service.SalePolicyRecordService;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Set;

/**
 * 三、本政策优惠金额总上限策略
 *
 * @author pengxi
 * @date 2022/01/11
 */
@Slf4j
public abstract class AbstractGiftTotalAmountLimitStrategy extends AbstractBaseSalePolicyLimitStrategy implements SalePolicyLimitStrategy<SalePolicyLimitVo> {

  @Autowired(required = false)
  private SalePolicyRecordService salePolicyRecordService;

  /**
   * 取得本政策维度的优惠总金额
   */
  @Override
  public void preValidate(AbstractPolicyExecuteContext policyExecuteContext, AbstractCycleExecuteContext cycleExecuteContext, SalePolicyVo currentSalePolicy, AbstractSalePolicyLimitInfo salePolicyLimitInfo) {
    // 1、
    String varValue = super.getVarValue(salePolicyLimitInfo);
    if (varValue == null) {
      log.warn("请设置本政策优惠金额总上限！");
      return;
    }
    // 2、
    DefaultPolicyExecuteContext executeContext = (DefaultPolicyExecuteContext)policyExecuteContext;
    Set<SalePolicyRecord> salePolicyRecords = salePolicyRecordService.findByTenantCodeAndSalePolicyCode(
        executeContext.getTenantCode(), currentSalePolicy.getSalePolicyCode());
    log.info("AbstractGiftTotalAmountLimitStrategy：tenantCode={}, salePolicyCode={}", executeContext.getTenantCode(), currentSalePolicy.getSalePolicyCode());
    super.amountValidateGift(policyExecuteContext, cycleExecuteContext, currentSalePolicy, varValue, salePolicyRecords);
  }
}
