package com.biz.crm.dms.business.policy.local.mapper;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.policy.local.entity.SalePolicy;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyPageDto;

/**
 * 优惠政策基本数据(SalePolicy)表数据库访问层
 * @author yinwenjie
 */
public interface SalePolicyMapper extends BaseMapper<SalePolicy> {
  /**
   * 针对特定二级租户的已存在的优惠政策分页查询信息
   * @param page 分页信息 
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<SalePolicy> findByConditions(Page<SalePolicy> page, @Param("dto") SalePolicyPageDto dto);
}
