package com.biz.crm.dms.business.policy.local.notifier;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyTempleteLogDto;
import com.biz.crm.dms.business.policy.sdk.event.SalePolicyTempleteLogEventListener;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyTempleteVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * impl销售政策模板日志事件侦听器
 *
 * @author hefan
 * @date 2022/05/25
 */
@Component
public class SalePolicyTempleteLogEventListenerImpl implements SalePolicyTempleteLogEventListener {

  @Autowired(required = false)
  private CrmBusinessLogVoService crmBusinessLogVoService;

  @Override
  public void onCreate(SalePolicyTempleteLogDto salePolicyTempleteLogDto) {
    this.saveRecord(salePolicyTempleteLogDto, OperationTypeEunm.CREATE);
  }

  @Override
  public void onUpdate(SalePolicyTempleteLogDto salePolicyTempleteLogDto) {
    this.saveRecord(salePolicyTempleteLogDto, OperationTypeEunm.UPDATE);
  }

  @Override
  public void OnEnable(SalePolicyTempleteLogDto salePolicyTempleteLogDto) {
    this.saveRecord(salePolicyTempleteLogDto, OperationTypeEunm.UPDATE);
  }

  @Override
  public void OnDisable(SalePolicyTempleteLogDto salePolicyTempleteLogDto) {
    this.saveRecord(salePolicyTempleteLogDto, OperationTypeEunm.UPDATE);

  }

  @Override
  public void OnDelete(SalePolicyTempleteLogDto salePolicyTempleteLogDto) {
    this.saveRecord(salePolicyTempleteLogDto, OperationTypeEunm.DELETE);
  }

  /**
   * 保存日志记录
   *
   * @param salePolicyTempleteLogDto 销售政策模板日志dto
   * @param operationTypeEunm                   更新
   */
  private void saveRecord(SalePolicyTempleteLogDto salePolicyTempleteLogDto, OperationTypeEunm operationTypeEunm) {
    SalePolicyTempleteVo original = salePolicyTempleteLogDto.getOriginal();
    SalePolicyTempleteVo newest = salePolicyTempleteLogDto.getNewest();
    // 分别从original和newest中获取ID，如果都没有就没必要保存了
    String onlyKey = null;
    if (original != null) {
      onlyKey = original.getId();
    } else if (newest != null) {
      onlyKey = newest.getId();
    }
    if (onlyKey == null) {
      return;
    }
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(operationTypeEunm.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setOldObject(original);
    crmBusinessLogDto.setNewObject(newest);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }
}
