package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.NotStackingCharacteristicInfo;
import com.biz.crm.dms.business.policy.local.mapper.NotStackingCharacteristicInfoMapper;


import org.springframework.stereotype.Component;

/**
 * 和标品中“不允许叠加执行”的执行特性有关的数据层功能汇总
 * @author yinwenjie
 */
@Component
public class NotStackingCharacteristicInfoRepository extends ServiceImpl<NotStackingCharacteristicInfoMapper, NotStackingCharacteristicInfo> {
  
  private static final String CHARACTERISTIC_CODE =  "notStackingCharacteristicStrategy";
  
  /**
   * TODO 注释未写
   * @param salePolicyCode 指定的优惠政策业务编码
   */
  public NotStackingCharacteristicInfo findBySalePolicyCodeAndTenantCode(String salePolicyCode , String tenantCode) {
    LambdaQueryWrapper<NotStackingCharacteristicInfo> lambdaQuery = Wrappers.<NotStackingCharacteristicInfo>lambdaQuery();
    lambdaQuery
      .eq(NotStackingCharacteristicInfo::getSalePolicyCode, salePolicyCode)
      .eq(NotStackingCharacteristicInfo::getTenantCode, tenantCode)
      .eq(NotStackingCharacteristicInfo::getCharacteristicCode, CHARACTERISTIC_CODE);
    return this.baseMapper.selectOne(lambdaQuery);
  }
  
  /**
   * TODO 注释未写
   * @param salePolicyCode 指定的优惠政策业务编码
   */
  public void deleteBySalePolicyCodeAndTenantCode(String salePolicyCode , String tenantCode) {
    LambdaQueryWrapper<NotStackingCharacteristicInfo> lambdaQuery = Wrappers.<NotStackingCharacteristicInfo>lambdaQuery();
    lambdaQuery
      .eq(NotStackingCharacteristicInfo::getSalePolicyCode, salePolicyCode)
      .eq(NotStackingCharacteristicInfo::getTenantCode, tenantCode)
      .eq(NotStackingCharacteristicInfo::getCharacteristicCode, CHARACTERISTIC_CODE);
    this.baseMapper.delete(lambdaQuery);
  }
}
